//   _______
// _| Scale |_________________________________________________________________
// Copyright John Cooke (bebox@dircon.co.uk) 1997
// You may use/abuse/hack/modify/disembowel this code in whatever way you desire
//
#ifndef SCALE_H
#include "Scale.h"
#endif

void rgbset (rgb_color *c, uint8 r, uint8 g, uint8 b, uint8 a=0)
{
	c->red = r;
	c->green = g;
	c->blue = b;
	c->alpha = a;
}

Scale::Scale (
	BRect frame,
	const char *name,
	float tick_gap,
	unsigned tick_count,
	uint32 resizeMode,
	uint32 flags
) : BView(frame, name, resizeMode, flags)
{
	minor_gap = tick_gap < 1.0 ? 1.0 : tick_gap;
	npermajor = tick_count;
	rgbset(&pen_color, 0,0,0,0);
}

void
Scale::SetColor (rgb_color color)
{
	pen_color = color;
}

// this is not very efficient - it ignores updrect for a start!
//
void
Scale::Draw(BRect updrect)
{
// get Bounds - yes, this should be cached
	BRect bounds = Bounds();

// determine orientation - cached again
	float ht = bounds.Height();
	float wd = bounds.Width();

// Vertical
	if(ht > wd)
	{
		int nlines = (int)(ht/minor_gap) + 2;
		BPoint start(bounds.LeftBottom());
		BPoint end(bounds.LeftTop());
		BPoint gap(0,-minor_gap);
		float tick = bounds.bottom; 
		float lasttick = bounds.top; 
		int ct;

		BeginLineArray(nlines);
	// base line
		AddLine(start, end, pen_color);

		end = bounds.RightBottom();

		for(ct=npermajor;tick>lasttick;tick-=minor_gap,ct++)
		{
			if(ct == npermajor)
			{
				ct = 0;
				end.Set(bounds.right, start.y);
			}
			else
				end.Set(bounds.right/2, start.y);
			AddLine(start,end,pen_color);
			start += gap;
		}

		EndLineArray();
	}

// Horizontal
	else
	{
		int nlines = (int)(wd/minor_gap) + 2;
		BPoint start(bounds.LeftBottom());
		BPoint end(bounds.RightBottom());
		BPoint gap(minor_gap,0);
		float tick = bounds.left; 
		float lasttick = bounds.right; 
		int ct;

		BeginLineArray(nlines);
	// base line
		AddLine(start, end, pen_color);

		end = bounds.LeftTop();

		for(ct=npermajor;tick<lasttick;tick+=minor_gap,ct++)
		{
			if(ct == npermajor)
			{
				ct = 0;
				end.Set(start.x, bounds.top);
			}
			else
				end.Set(start.x, bounds.bottom/2);
			AddLine(start,end,pen_color);
			start += gap;
		}

		EndLineArray();
	}
}
