#include "ProxyManager.h"
#include "HTTPProxy.h"
#include "GenericProxy.h"
#include "ProxyAppMsg.h"

ProxyManager::ProxyManager( DNSResolver *nameResolver, const char *name, 
	int32 maxConnections, int32 port )
	: TCPListener( name, maxConnections, port )
{
	this->nameResolver = nameResolver;
}

//*********************
// Proxy Manager Types
//*********************
HTTPProxyManager::HTTPProxyManager( DNSResolver *nameResolver, 
	const char *name, uint16 port, int32 maxConnections )
	: ProxyManager( nameResolver, name, maxConnections, port )
{
	
}

TCPConnection *HTTPProxyManager::NewConnection( int32 socket )
{
	return new HTTPProxy( socket, nameResolver, this, 16384 );
}

int32 HTTPProxyManager::GetType( void )
{
	return HTTP_PROXY_TYPE;
}

GenericProxyManager::GenericProxyManager( DNSResolver *nameResolver, const char *name, 
	uint16 localPort, const char *host, uint16 remotePort, int32 maxConnections )
	: ProxyManager( nameResolver, name, maxConnections, localPort )
{
	strncpy( this->host, host, 255 );
	this->remotePort = remotePort;
}

TCPConnection *GenericProxyManager::NewConnection( int32 socket )
{
	return new GenericProxy( socket, nameResolver, this, host, remotePort );
}

int32 GenericProxyManager::GetType( void )
{
	return GENERIC_PROXY_TYPE;
}

const char *GenericProxyManager::GetHost( void )
{
	return host;
}

uint16 GenericProxyManager::GetRemotePort( void )
{
	return remotePort;
}
