/******************************************************************************
//
//	File:		ProxyManager.h
//
//	Description: Proxy Administration HTTP Server class
//		Used to monitor and configure HTTP Proxy from any web browser
//		It's independant of HTTP Proxy and could be run in it's own thread
//
//	Copyright 1998, Joe Kloss
//
*******************************************************************************/

#ifndef PROXY_ADMIN_H
#define PROXY_ADMIN_H

#include "TCPListener.h"

class ProxyAdmin : public TCPListener//, public BLooper
{
	public:
		ProxyAdmin( const BMessenger *messenger, uint16 port = 25000 );
		~ProxyAdmin( void );
		
		const char *GetBodyHead( size_t *size );
		const char *GetBodyFoot( size_t *size );
		const char *GetTableRow( size_t *size );
		const char *GetUser( void );
		const char *GetPass( void );
		
		status_t LoadNetworkSettings( void );
		
	protected:
		virtual TCPConnection *NewConnection( int32 socket );
		
	protected:
		BMessenger		*messenger;
		char			*head, *foot, *tableRow;
		char			user[64], pass[64];
		size_t			headSize, footSize, tableRowSize;
};

#endif
