#include "Base64.h"

// ascii to base64 table
// Starts at ascii #43
static const char ascii_to_base64T[80] = { 62, -1, -1, -1, 63, // + ... / ( 5 )
52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, // 0 - 9 ( 13 )
0, -1, -1, -1, // = ( 4 )
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, // A - U ( 21 )
21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, // V - Z ( 11 )
26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, // a - r ( 18 )
44, 45, 46, 47, 48, 49, 50, 51 }; // s - z ( 8 )

// Yes, the soruce can be the same as the destination
size_t decode_base64( char *dst, const char *src, size_t length )
{
	uint8		inGroup[4];
	
	const char	*srcPtr;
	char		*dstPtr, c, b64;
	size_t		size;
	
	int32		i, last = 0, blocks;
	
	// Get source bytes in groups of four until we reach the size specified in length
	for( srcPtr = src, dstPtr = dst, blocks = 0; ((srcPtr-src) <= length); srcPtr += 4, dstPtr += 3, blocks++ )
	{
		// Get next group of four
		for( i = 0; i < 4; i++ )
		{
			c = srcPtr[i];
			if( (c >= 43) && (c < 123 ) ) // is it in range?
			{
				b64 = ascii_to_base64T[c-43]; // translate ascii to base64
				if( b64 == -1 )
					inGroup[i] = 0;
				else
					inGroup[i] = (uint8)b64;
				if( c == '=' ) // Make note if pad character encountered
				{
					if( i == 2 )
						last = 2;
					else if( i == 3 )
						last = 1;
				}
			}
			else
				inGroup[i] = 0;
		}
		// Translate 4 6-bit characters to 3 8-bit bytes
		dstPtr[0] = ((inGroup[0]&0x3F)<<2) | ((inGroup[1]&0x30)>>4);
		dstPtr[1] = ((inGroup[1]&0x3F)<<4) | ((inGroup[2]&0x3C)>>2);
		dstPtr[2] = ((inGroup[2]&0x03)<<6) | (inGroup[3]&0x3F);
	}
	return( blocks*3 - last ); // return size of decoded data
}

