/*  sshLogin- written by Brian Hill, perelandra@iname.com
    
    This program was written for BeOS (www.be.com) and provides a simple
    graphical interface for using ssh, ftp, and other telnet and ftp clients.
    
    
    --Protected under General Public License--
    
    Copyright (C) 2001,  Brian Hill <perelandra@iname.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef SSHLOGIN_H
#define SSHLOGIN_H
#include <SupportKit.h>
#include <AppKit.h>
#include <InterfaceKit.h>
#include <StorageKit.h>
#include <fstream.h>
#include <iostream.h>
#include <vector.h>

//supported protocols (used for testing)
#define ssh_support 1
#define telnet_support 1
#define ftp_support 1
#define nftp_support 1
#define ncftp_support 1

//classes
class SSHLWindow;
class RecentItem;
class SSHLApp : public BApplication
{public:
					SSHLApp();
					~SSHLApp();
//	virtual void	ReadyToRun();
private:
	SSHLWindow		*aWindow;
};
class SSHLWindow : public BWindow
{public:
					SSHLWindow(BRect);
					~SSHLWindow();
	virtual	bool	QuitRequested();
	void			AboutRequested();
	virtual void	MessageReceived(BMessage*);
private:
	BMenuBar		*mainMenuBar;
	BMenuField		*protocolField;
	BMenu			*fileMenu, *recentMenu, *recentNumMenu, *settingsMenu;
	BPopUpMenu		*protocolMenu;
	BView			*mainView;
	BTextControl	*hostTC, *usernameTC, *portnumberTC;//, *passTC;
	BCheckBox		*usernameCB, *portnumberCB;
	BButton			*loginB;
	BPath			settingsP;
	vector<RecentItem> recentList;
	bool			login();
	BString			protocol_command();
	void			updateRecent();
	bool			add_recent(RecentItem&);
	void			clearRecent();
	void			storeSettings(BMessage&);
	void			restoreSettings(BMessage&);
};
class RecentItem
{friend class SSHLWindow;
public:
					RecentItem();
					RecentItem(const char*, const char*, const char*, const char*);
	bool			operator==(RecentItem&);
	void			SetTo(char*);
private:
	BString			host, username, port, protocol;
};
enum messages{
	NEW_HOST = 1,
	NEW_USERNAME,
	NEW_PORT,
	SSH_LOGIN,
	SPECIFY_RECENT,
	CLEAR_RECENT,
	PROTOCOL_CHANGED
};

#endif
