/*
  reader.h - class readstdin_c for rlogin client for BeOS
  Copyright (C) 1998 Uwe Ohse

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.
*/                                                                                            
typedef enum {MODE_UNINIT,MODE_COOKED, MODE_RAW} io_mode_t;

class readstdin_c {
private:
    thread_id id;
    int sock;
    bool got_sigwinch;
    struct winsize winsize;
    io_mode_t mode;

public:
    	void change_mode(io_mode_t);
	// they should be private, but why bother?
	const char *luser;	// local luser
	const char *ruser;	// remote luser
	const char *term;	// term/baud
	int escapechar; // -1 == "no escapechar"
	bool eightbit;

	readstdin_c(int sock);
	~readstdin_c();

	thread_id getid(void) { return id; };
	void Sigwinch(void) { got_sigwinch=true; }

	int32 thread_func(void);
	static int32 static_thread_func(void *arg) {
		return (((readstdin_c *) arg)->thread_func());
	};
	status_t wait(void) { return wait_for_thread(id, NULL); };
	void write(char *,int);
	void go(void) { resume_thread(id); };
	int sendwinsize(struct winsize ws);
	void echo(unsigned char);
};


