/*
  reader.cpp - local2remote thread for rlogin client for BeOS
  Copyright (C) 1998 Uwe Ohse

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.
*/                                                                                            

#include "rlogin.h"

static void 
sigwinch_handler(int sig)
{
	// we want to get a EINTR!
	readstdin->Sigwinch();
}

int
readstdin_c::sendwinsize(struct winsize ws)
{
	short t;
	char buf[4+sizeof(struct winsize)];
	buf[0]=255;
	buf[1]=255;
	buf[2]='s';
	buf[3]='s';
	t=htons(ws.ws_row);
	memcpy(buf+4,&t,sizeof(t));
	t=htons(ws.ws_col);
	memcpy(buf+4+sizeof(t),&t,sizeof(t));
	t=htons(ws.ws_xpixel);
	memcpy(buf+4+sizeof(t)*2,&t,sizeof(t));
	t=htons(ws.ws_ypixel);
	memcpy(buf+4+sizeof(t)*3,&t,sizeof(t));
	send(sock,buf,sizeof(buf),0);
}

void 
readstdin_c::write(char *buf,int len)
{
	int r;
	int off=0;
	int count=len;
	do {
	    r = send(sock, buf+off, count, 0);
	    if (r < 0) {
	    	if (errno==EINTR || errno==EAGAIN)
			continue;
		myperror("write to remote");
		kill_thread(writestdout->getid());
		exit_thread(errno);
	    }
	    off+=r;
	    count-=r;
	} while (count);
}

int32 
readstdin_c::thread_func(void)
{
    // read from stdin, write to remote 

    // rlogin is a widespread hack, not a protocol. look at the escape 
    // handling

    // first the protocol
    send(sock, "", 1, 0); // strange ... 
    send(sock, luser, strlen(luser) + 1, 0); // local user name
    send(sock, ruser, strlen(ruser) + 1, 0); // remote user name
    send(sock, term, strlen(term) + 1, 0); // term/baud

    // no setup SIGWINCH handler and inform remote about window size
    signal(SIGWINCH, sigwinch_handler);

	//    sendwinsize(winsize); /* yessir, remote needs to know */

    int linechars=0;
    int got_escape=0;

    while (1) {
	char buf[10];
	char buf2[100];
	int r;
	int len;
	int i;
	// why read more then one char? Because i often work over 
	// overloaded network connections ... my home connection.
	r = read(0, buf, sizeof(buf));
	if (got_sigwinch) {
		struct winsize ws;
		ioctl(0,TIOCGWINSZ,&ws);
		sendwinsize(ws);
		got_sigwinch=0;
	}
	if (r <= 0) {
		if (errno==EINTR)
			continue;
		// main process waits for writestdout
		// so kill writestdout.
		kill_thread(writestdout->getid());
    		exit_thread(r ? errno : 0);
	}
	// now the funny business of escaping

	// things are even more funny as BeOS doesn't support out-of-band
	// data (fundamental ip feature, IMO), so we have to get that data
	// out of the normal data stream - not good! This leaves us now
	// possibility to be really 8bit-clean.
	for (len=0,i=0;i<r;i++) {
		unsigned char c=buf[i];
		if (linechars==0 
			&& c==escapechar)
			got_escape=1;
		else if (got_escape) {
			got_escape=0;
			if (c=='.') {
				echo('.');
				// main process waits for writestdout
				// so kill writestdout.
				kill_thread(writestdout->getid());
    				exit_thread(0);
			} 
			if (c!=escapechar) {
				buf2[len++]=escapechar;
				buf2[len++]=c;
			}
		} else {
			buf2[len++]=c;
		}
		linechars++;
		if (c=='\r' || c=='\n') {
			linechars=0;
		}
	}
	write(buf2,len);
    }
}

void
readstdin_c::echo(unsigned char c)
{
	unsigned char buf[8],*p;
	p=buf;
	*p++=escapechar;
	if ((c & 0x7f)<' ') { // XXX this is ISO-8859-1 specific!
		*p++='^';
		*p++=c+'@';
	} else if (c==0x7f) {
		*p++='^';
		*p++='?';
	} else
		*p++=c;
	*p++='\r';
	*p++='\n';
	::write(1,buf,p-buf);
	
}

readstdin_c::readstdin_c(int sock)
{
	this->sock = sock;
	this->id = spawn_thread(static_thread_func, "local2remote", 
		B_LOW_PRIORITY, this);
	// for comparision
	ioctl(0,TIOCGWINSZ,&this->winsize);
	// rfc1258 says we start in cooked mode
	change_mode(MODE_COOKED);
}

void
readstdin_c::change_mode(io_mode_t nmode)
{
	struct termios tio;
	if (nmode==mode)
		return;
	// leave cooked mode, _we_'ll do that
	tcgetattr(0,&tio);
	if (mode==MODE_UNINIT) {
		// first change of the mode. do basic things 
		// no canon mode, no echo, no signal characters
		// (hey, remote shall be interrupted, not me!).
		tio.c_lflag &= ~(ECHO|ICANON|ISIG);
		// no cr->lf conversion
		tio.c_iflag &= ~(ICRNL);
		tio.c_cc[VTIME] = 1;
		tio.c_cc[VMIN] = 1;                                  
		// no nl/cr conversion
		tio.c_oflag &= ~(ONLCR|OCRNL);
		if (eightbit)
			tio.c_iflag &= ~(ISTRIP); // shouldn't ne a problem with beos
		else {
			tio.c_iflag |= (ISTRIP); // _this_ doesn't work.
		}
		// special characters
		tio.c_cc[VSUSP] = 255;
		tio.c_cc[VEOL] = 255;
		tio.c_cc[VEOL2] = 255;
	}
	if (nmode==MODE_COOKED)
		tio.c_iflag |= IXON;
	else
		tio.c_iflag &= ~(IXON);
	tcsetattr(0,TCSAFLUSH,&tio);
	mode=nmode;
}
