//	DateView.cpp
//
//	Tetsuo Yamada
//	Created: Sat, Nov. 21 1998
//	Modified: Mon, Dec. 06 1999

#include	<string.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<math.h>
#include	<interface/Dragger.h>
#include	<time.h>
#include	"DateView.h"
#include	"CalendarWindow.h"
#include	<interface/Shelf.h>
#include	<interface/MenuItem.h>
#include	<interface/Alert.h>
#include	<support/Beep.h>
#include	<app/Roster.h>
#include	<storage/Mime.h>
#include	<interface/Screen.h>


extern const char *d_signature ;
extern rgb_color gWeekday ;
extern rgb_color gSaturday ;
extern rgb_color gHoliday ;



//==================================================================
//	class DateView
//==================================================================
DateView::DateView (BRect frame) 
			: BView (frame, "Date", B_FOLLOW_NONE, B_WILL_DRAW|B_PULSE_NEEDED), 
			fDownLoc (-3000, 0) {
	fText = strdup ("") ;
	fContextMenu = NULL ;
	fFormat = strdup ("%a, %b. %d %Y") ;
	SetAlignment (B_ALIGN_CENTER, B_ALIGN_MIDDLE) ;
	SetText (B_EMPTY_STRING) ;
	Pulse () ;
	InitContextMenu () ;
	AddChild (new BDragger(BRect (0, 0, 7, 7), this, B_FOLLOW_LEFT | B_FOLLOW_TOP));
} ;

DateView::~DateView () {
	delete[] fText ;
	delete[] fFormat ;
	delete fContextMenu ;
} ;

DateView* DateView::Instantiate (BMessage *archive) {
	if (!validate_instantiation (archive, "DateView")) return NULL ;
	return new DateView (archive) ;
} ;

status_t DateView::Archive (BMessage *msg, bool deep) const {
	status_t err = B_OK ;
	
	err = BView::Archive(msg, deep) ;
	if (err!=B_OK) return err ;
	
	msg->AddString ("add_on", d_signature) ;
	
	msg->AddInt32 ("h_align", (int32)fHAlign) ;
	msg->AddInt32 ("v_align", (int32)fVAlign) ;
	msg->AddString ("format", fFormat) ;
	
	/* archive globals */
	msg->AddData ("weekday", B_RGB_COLOR_TYPE, d_weekday, 4) ;
	msg->AddData ("saturday", B_RGB_COLOR_TYPE, d_saturday, 4) ;
	msg->AddData ("holiday", B_RGB_COLOR_TYPE, d_holiday, 4) ;
	
	return B_OK ;
} ;

DateView::DateView (BMessage *archive) 
			: BView (archive), 
			fDownLoc (-3000, 0) {
	const char *format = NULL ;
	const rgb_color *color = NULL ;
	ssize_t size = 0 ;
	
	fText = NULL ;
	fContextMenu = NULL ;
	fFormat = NULL ;
	SetText (B_EMPTY_STRING) ;
	archive->FindInt32 ("h_align", (int32*)&fHAlign) ;
	archive->FindInt32 ("v_align", (int32*)&fVAlign) ;
	archive->FindString ("format", &format) ;
	SetFormat (format) ;
	Pulse () ;
	InitContextMenu () ;
	
	archive->FindData ("weekday", B_RGB_COLOR_TYPE, 0, (const void **)&color, &size) ;
	gWeekday = *color ;
	archive->FindData ("saturday", B_RGB_COLOR_TYPE, 0, (const void **)&color, &size) ;
	gSaturday = *color ;
	archive->FindData ("holiday", B_RGB_COLOR_TYPE, 0, (const void **)&color, &size) ;
	gHoliday = *color ;
} ;

void DateView::AttachedToWindow () {
	if (Parent()) {
		SetViewColor (Parent()->ViewColor()) ;
		SetLowColor (ViewColor()) ; // make sure low color equals view color.
	}
	fContextMenu->SetTargetForItems (this) ;
	BView::AttachedToWindow() ;
} ;

void DateView::Pulse () {
	time_t now = time (NULL) ;
	struct tm *nowtm = localtime (&now) ;
	char timestr [128] ;
	size_t size = 0 ;
	
	size = strftime (timestr, 127, fFormat, nowtm) ;
	if (size==0) {
		//	error handling
		strcpy (timestr, "Failed to get time") ;
	}
	
	if (Text() && strcmp (timestr, Text()) != 0) {
		//	update text
		SetText (timestr) ;
	}
} ;

void DateView::Draw (BRect update) {
	DrawDate (this, update) ;
} ;

void DateView::DrawDate (BView *view, BRect update) {
	update = update ;
	
	BPoint p ; // point to start drawing
	BRect rect = view->Bounds() ;
	font_height fh ;
	float width = view->StringWidth (fText) ;
	const float gap = 5 ;
	
	view->GetFontHeight (&fh) ;
	
	switch (fHAlign) {
		case B_ALIGN_LEFT : 
			p.x = gap ;
			break ;
		case B_ALIGN_RIGHT : 
			p.x = rect.right - width - gap ;
			break ;
		case B_ALIGN_CENTER : 
			p.x = (rect.Width() - width)/2 ;
			break ;
	}
	/*p.y = ceil (fh.ascent) + floor((rect.Height() - font.Size() - 1.0)/2.0) ;*/
	/* I dont know why. But this is the only way to draw string */
	/* into the same position as the time view does, I believe. */
	p.y = fh.ascent + fh.descent - 2 + (rect.Height() - fh.ascent - fh.descent - fh.leading)/2 ;
	
	view->DrawString (fText, p) ;
} ;

void DateView::SetText (const char *text) {
	if (!text) {
		//	error handling
		return ;
	}
	if (fText && strcmp (text, fText) == 0) return ;
	
	if (fText) delete[] fText ;
	fText = new char [strlen (text) + 1] ;
	strcpy (fText, text) ;
	Invalidate () ;
} ;

const char *DateView::Text () const {
	return fText ;
} ;

void DateView::SetFormat (const char *format) {
	if (!format) return ;
	
	delete[] fFormat ;
	fFormat = strdup (format) ;
	Pulse () ;
	Invalidate () ;
} ;

const char *DateView::Format () const {
	return fFormat ;
} ;

void DateView::SetAlignment (alignment h_align, vertical_alignment v_align) {
	fHAlign = h_align ;
	fVAlign = v_align ;
	Pulse () ;
	Invalidate() ;
} ;

void DateView::GetAlignment (alignment *h_align, vertical_alignment *v_align) const {
	*h_align = fHAlign ;
	*v_align = fVAlign ;
} ;

/*void DateView::MouseDown (BPoint where) {
	int32 clicks = 0 ;
	uint32 buttons = 0 ;
	uint32 modifiers = 0 ;
	BMessage *msg = Looper()->CurrentMessage() ;
	bigtime_t start = system_time() ;
	const bigtime_t interval = 500*1000 ;
	
	printf ("async -- %d.\n", (bool)(Window()->Flags() & B_ASYNCHRONOUS_CONTROLS)) ;
	
	msg->FindInt32 ("clicks", &clicks) ;
	msg->FindInt32 ("modifiers", (int32*)&modifiers) ;
	msg->FindInt32 ("buttons", (int32*)&buttons) ;
	
	if (clicks >= 2) {
		ConvertToScreen (&where) ;
		CalendarWindow *window = new CalendarWindow (where) ;
		window->Show () ;
		return ;
	}
	
	while (buttons) {
		if (buttons == B_SECONDARY_MOUSE_BUTTON || 
					system_time() - start >= interval || 
					(modifiers & B_CONTROL_KEY)) {
			fContextMenu->Go (ConvertToScreen (where), true, false, true) ;
			break ;
		}
		
		snooze (20*1000) ;
		GetMouse (&where, &buttons) ;
	}
} ;*/

void DateView::MouseUp (BPoint where) {
	fDownLoc.Set (-100, -3000) ;
} ;

void DateView::MouseMoved (BPoint where, uint32 transit, const BMessage *message) {
	if (Bounds().Contains (fDownLoc)) {
		if (pow(where.y - fDownLoc.y, 2) + pow (where.x - fDownLoc.x, 2) > 16) {
			// the user is trying to drag me.
			BMessage msg (B_MIME_DATA) ;
			time_t now = time (NULL) ;
			struct tm *nowtm = localtime (&now) ;
			char str [128] ;
			uint32 modifiers ;
			
			Window()->CurrentMessage()->FindInt32 ("modifiers", (int32*)&modifiers) ;
			
			strcpy (str, fText) ;
			
			// some jokes
			if ((modifiers & B_LEFT_SHIFT_KEY) && (modifiers & B_LEFT_OPTION_KEY)) {
				if (nowtm->tm_year == 100 && nowtm->tm_yday == 0) {
					// 1/1/2000
					strcat (str, " A Happy New Millenium!!") ;
				} else if (nowtm->tm_year%100 == 1 && nowtm->tm_yday == 0) {
					// 1/1/XXX1, the first day of the century.
					strcat (str, " A Happy New Century!") ;
				}
			} else if (nowtm->tm_mon == 9 && nowtm->tm_mday == 31) {
				// halloween
				strcpy (str, "trick or not treat! :-P") ;
			}
			
			msg.AddData ("text/plain", B_MIME_TYPE, str, strlen (str), false) ;
			
			DragMessage (&msg, DragImage(), B_OP_ALPHA, where) ;
			
			fDownLoc.Set (-10000, 0) ;
		}
	}
} ;

BBitmap *DateView::DragImage () {
	BRect rect = Bounds() ;
	BBitmap *image ;
	BView *view ;
	rgb_color high = HighColor() ;
	BFont font ;
	
	rect.right = ((int32)(rect.right - rect.left + 4)/4)*4 - 1 ;
	rect.left = (int32)rect.left ;
	rect.top = (int32)rect.top ;
	rect.bottom = (int32)(ceil (rect.bottom)) ;
	
	image = new BBitmap (rect, BScreen(Window()).ColorSpace(), true) ;
	view = new BView (rect, "view", B_FOLLOW_NONE, 0) ;
	
	GetFont (&font) ;
	
	image->Lock() ;
	image->AddChild (view) ;
	view->SetViewColor (B_TRANSPARENT_COLOR) ;
	view->SetLowColor (B_TRANSPARENT_COLOR) ;
	view->FillRect (view->Bounds(), B_SOLID_LOW) ;
	view->SetDrawingMode (B_OP_ALPHA) ;
	view->SetBlendingMode (B_CONSTANT_ALPHA, B_ALPHA_OVERLAY) ;
	view->SetFont (&font) ;
	high.alpha = 192 ;
	view->SetHighColor (high) ;
	DrawDate (view, view->Bounds()) ;
	view->Sync() ;
	image->Unlock () ;
	
	return image ;
} ;

void DateView::MouseDown (BPoint where) {
	uint32 modifiers, clicks, buttons ;
	BMessage *crtmsg = Looper()->CurrentMessage() ;
	
	crtmsg->FindInt32 ("modifiers", (int32*)&modifiers) ;
	crtmsg->FindInt32 ("clicks", (int32*)&clicks) ;
	crtmsg->FindInt32 ("buttons", (int32*)&buttons) ;
	
	if (	buttons == B_SECONDARY_MOUSE_BUTTON || 
			(buttons == B_PRIMARY_MOUSE_BUTTON && (modifiers & B_CONTROL_KEY))) {
		// context menu
		fDownLoc.Set (-3000, 0) ;
		ConvertToScreen (&where) ;
		fContextMenu->Go (where, true, true, BRect (where, where).InsetBySelf(-4, -4), true) ;
	} else if (clicks >= 2) {
		// show calendar
		fDownLoc.Set (-3000, 0) ;
		ConvertToScreen (&where) ;
		CalendarWindow *window = new CalendarWindow (where) ;
		window->Show () ;
	} else if (buttons == B_PRIMARY_MOUSE_BUTTON) {
		// pending
		BMessage msg (D_KEIZOKU) ;
		
		msg.AddInt64 ("till", system_time() + 1000*1000) ;
		Window()->PostMessage (&msg, this) ;
		
		SetMouseEventMask (B_POINTER_EVENTS) ;
		fDownLoc = where ;
	}
} ;

status_t DateView::Uninstall () {
	status_t err = B_OK ;
	BShelf *sh = NULL ;
	BWindow *window = Window () ;
	int32 count = window->CountHandlers() ;
	BMessage msg (B_DELETE_PROPERTY) ;
//	BMessage specifier (B_NAME_SPECIFIER) ;
	
	for (int32 i=0 ; i<count ; i++) {
		sh = dynamic_cast<BShelf *>(window->HandlerAt (i)) ;
		if (sh) break ;
	}
	if (!sh) return B_ERROR ;
	
	BMessenger msgr (sh) ;
	
	//---
	msg.AddSpecifier ("Replicant", sh->IndexOf (this)) ;
	//---
	
/*	specifier.AddString ("name", "Date") ;
	specifier.AddString ("property", "Replicant") ;
	msg.AddSpecifier (&specifier) ;*/
	
	err = msgr.SendMessage (&msg, (BHandler*)NULL) ;
	if (err != B_OK) return err ;
	
	return B_OK ;
} ;

void DateView::InitContextMenu () {
	BMenuItem *item = NULL ;
	
	fContextMenu = new BPopUpMenu ("context_menu", false, false) ;
	
	item = new BMenuItem ("About"B_UTF8_ELLIPSIS, new BMessage (D_ABOUT_REQUESTED)) ;
	fContextMenu->AddItem (item) ;
	
	item = new BMenuItem ("Contact to Author", new BMessage (D_MAIL_TO_AUTHOR)) ;
	fContextMenu->AddItem (item) ;
	
	fContextMenu->AddSeparatorItem () ;
	
	item = new BMenuItem ("Delete", new BMessage (D_DELETE_REPLICANT)) ;
	fContextMenu->AddItem (item) ;
} ;

void DateView::MessageReceived (BMessage *msg) {
	switch (msg->what) {
		case D_DELETE_REPLICANT : 
			if (Uninstall() != B_OK) beep () ;
			break ;
			
		case D_ABOUT_REQUESTED : 
			AboutRequested () ;
			break ;
		
		case D_MAIL_TO_AUTHOR : 
			MailToAuthor () ;
			break ;
		
		case D_KEIZOKU : 
			if (Bounds().Contains(fDownLoc)) {
				bigtime_t till ;
				
				msg->FindInt64 ("till", &till) ;
				
				if (till <= system_time()) {
					// now the time to show context menu.
					BPoint where ;
					uint32 buttons ;
					
					GetMouse (&where, &buttons) ;
					
					SetMouseEventMask (0) ;
					fDownLoc.Set (-100, -3000) ;
					
					ConvertToScreen (&where) ;
					fContextMenu->Go (where, true, true, BRect (where, where).InsetBySelf (-4, -4), true) ;
				} else {
					// wait more
					BMessage sent (*msg) ;
					
					Window()->PostMessage (&sent, this) ;
				}
			}
			break ;
		
		default : 
			BView::MessageReceived (msg) ;
			break ;
	}
} ;

void DateView::MailToAuthor () {
	BMimeType mime (B_URL_MAILTO) ;
	status_t err ;
	char sig [B_MIME_TYPE_LENGTH] ;
	char *argv[3] ;
	
	argv[0] = "" ;
	argv[1] = "mailto:ivy@ma.kcom.ne.jp" ;
	argv[2] = NULL ;
	
	err = mime.InitCheck () ;
	if (err != B_OK) goto TryEMail ;
	
	if (!mime.IsInstalled()) goto TryEMail ;
	
	err = mime.GetPreferredApp (sig) ;
	if (err != B_OK) goto TryEMail ;
	
	be_roster->Launch (sig, 2, argv) ;
	return ;
	
TryEMail : 
	
	err = mime.SetTo ("text/x-email") ;
	if (err != B_OK) goto GiveUp ;
	
	err = mime.GetPreferredApp (sig) ;
	if (err != B_OK) goto GiveUp ;
	
	err = be_roster->Launch (sig, 2, argv) ;
	return ;
	
GiveUp : 
	beep () ;
} ;

void DateView::AboutRequested () {
	time_t now = time (NULL) ;
	struct tm *nowtm = localtime (&now) ;
	
	BAlert *a = new BAlert ("About Date", 
			"Date\n"
			"\n"
			"Version: 1.3b1\n"
			"Author: Tetsuo Yamada\n"
			"Contact: ivy@ma.kcom.ne.jp\n"
			"URL: http://www.duelists.org/~ivy/", 
			(nowtm->tm_mon == 3 && nowtm->tm_mday == 1) ? "Can You Believe This?" : "OK", 
			NULL, NULL, B_WIDTH_FROM_LABEL) ;
	a->TextView()->MakeSelectable (true) ;
	a->Go (NULL) ;
} ;

