//	CalendarWindow.h
//
//	Tetsuo Yamada
//	Created: Mon, Feb. 08 1999
//	Modified: Mon, Dec. 06 1999


#ifndef		D_CALENDAR_WINDOW_h_
#define		D_CALENDAR_WINDOW_h_


#include	<time.h>
#include	<interface/Window.h>
#include	<interface/StringView.h>
#include	<interface/Control.h>


//==================================================================
//	global functions which helps struct tm
//==================================================================
//	returns the number of days in the month. if failed, returns -1.
//	t が示す月の日数を返す
int32						days_in_month (const struct tm *t) ;

//	returns weekday of the first day of the month in int (0-6).
//	その月の１日の曜日を返す
int							first_weekday (const struct tm *t) ;

//	現在の時刻を tm で返す。 tm は static な自動ローカル変数
struct tm					*now_as_tm () ;


//==================================================================
//	class CalendarView
//==================================================================
class CalendarView : public BView {
//	fields
private : 
	const struct tm			*fWhen ;
	
//	methods
public : 
							CalendarView (BPoint lefttop, 
									const char *name, 
									const struct tm *when, 
									uint32 resize = B_FOLLOW_LEFT|B_FOLLOW_TOP) ;
							~CalendarView () ;
	
	virtual void			AttachedToWindow () ;
	virtual void			MouseUp (BPoint where) ;
	virtual void			GetPreferredSize (float *width, float *height) ;
	virtual void			Draw (BRect update) ;
	
private : 
	void					DrawAlignedString (const char *string, 
									BRect block, 
									bool emphasize = false) ;
} ;


//==================================================================
//	class IteratorButton
//==================================================================
enum iterator_type {
	D_NEXT, 
	D_PREV
} ;

//	キーボードからの操作には対応してないっす
class IteratorButton : public BControl {
//	fields
private : 
	iterator_type			fType ;
	bigtime_t				fLast ;
	int32					fCounter ;
	BRect					fBounds ;
	
//	methods
public : 
							IteratorButton (BRect frame, 
									const char *name, 
									iterator_type type, 
									BMessage *msg, 
									uint32 resizie = B_FOLLOW_RIGHT|B_FOLLOW_TOP) ;
							~IteratorButton () ;
	
	virtual void			MouseDown (BPoint p) ;
	virtual void			MessageReceived (BMessage *msg) ;
	virtual void			Draw (BRect update) ;
	virtual status_t		Invoke (BMessage *msg = NULL) ;
	virtual void			FrameResized (float width, float height) ;
	virtual void			AllAttached () ;
	
private : 
	void					Keizoku () ;
} ;


//==================================================================
//	class CalendarWindow
//==================================================================
class CalendarWindow : public BWindow {
//	fields
private : 
	struct tm				fWhen ;
	CalendarView			*fCalendar ;
	BStringView				*fMonth ;
	
//	methods
public : 
							CalendarWindow (BPoint point) ;
							~CalendarWindow () ;
	
	virtual void			MessageReceived (BMessage *msg) ;
	virtual void			WindowActivated (bool active) ;
	virtual void			Show () ;
	
private : 
	void					BuildChildren () ;
	BPoint					ScreenLocation (BPoint point) ;
	void					GetMonthString (char *buf, size_t size) const ;
} ;


extern const rgb_color *d_weekday ;
extern const rgb_color *d_saturday ;
extern const rgb_color *d_holiday ;


#endif

