//	DateView.h
//
//	Tetsuo Yamada
//	Created: Sat, Nov. 21 1998
//	Modified: Mon, Dec. 06 1999

#ifndef		D_DATE_VIEW_h_
#define		D_DATE_VIEW_h_

#include	<interface/View.h>
#include	<interface/PopUpMenu.h>
#include	<app/Application.h>
#include	<interface/Bitmap.h>


enum {
	D_ABOUT_REQUESTED = 'dAAA', 
	D_DELETE_REPLICANT, 
	D_KEIZOKU, 
	D_NEXT_MONTH, 
	D_PREV_MONTH, 
	D_MAIL_TO_AUTHOR, 
	D_END_OF_ENUM
} ;


class _EXPORT				DateView ;


//==================================================================
//	class DateView
//==================================================================
//	Deskbar に張り付けられるビュー
class DateView : public BView {
//	fields
private : 
	char					*fText ;
	char					*fFormat ;
	BPopUpMenu				*fContextMenu ;
	alignment				fHAlign ;
	vertical_alignment		fVAlign ;
	BPoint					fDownLoc ;
	
//	methods
public : 
							DateView (BRect frame) ;
	virtual					~DateView () ;
	
	static DateView*		Instantiate (BMessage *archive) ;
	virtual status_t		Archive (BMessage *msg, bool deep = true) const ;
							DateView (BMessage *archive) ;
	
	virtual void			Pulse () ;
	virtual void			Draw (BRect update) ;
	virtual void			AttachedToWindow () ;
	virtual void			MouseDown (BPoint where) ;
	virtual void			MouseUp (BPoint where) ;
	virtual void			MouseMoved (BPoint where, uint32 transit, const BMessage *msg) ;
	virtual void			MessageReceived (BMessage *msg) ;
	
	void					SetText (const char *text) ;
	const char				*Text () const ;
	
	void					SetFormat (const char *format) ;
	const char				*Format () const ;
	
	void					SetAlignment (alignment h_align, 
									vertical_alignment v_align) ;
	void					GetAlignment (alignment *h_align, 
									vertical_alignment *v_align) const ;
	
	status_t				Uninstall () ;
	
private : 
	void					InitContextMenu () ;
	void					AboutRequested () ;
	void					MailToAuthor () ;
	BBitmap					*DragImage () ;
	void					DrawDate (BView *view, BRect update) ;
} ;


#endif

