//	main.cpp
//
//	Tetsuo Yamada
//	Modified: Mon, Dec. 06 1999


#include	<app/Application.h>
#include	"DateView.h"
#include	<getopt.h>
#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>
#include	<time.h>


/* globals */
const char *d_signature = "application/x-vnd.TY-DATE" ;
rgb_color gWeekday = {0, 0, 0} ;
rgb_color gSaturday = {51, 102, 152} ;
rgb_color gHoliday = {255, 0, 0} ;
const rgb_color *d_weekday = &gWeekday ;
const rgb_color *d_saturday = &gSaturday ;
const rgb_color *d_holiday = &gHoliday ;


void usage (const char *arg) ;
void get_color (rgb_color *c, const char *rgbstr) ;


void usage (const char *arg) {
	printf ("Usage: %s [ALIGN][OPTIONS]\n"
			"  -l, --left            align to the left\n"
			"  -c, --center          align to the center\n"
			"  -r, --right           align to the right\n"
			"  -f, --format=FORMAT   specify format string to FORMAT\n"
			"  -w, --width=WIDTH     specify width of the replicant (1-105)\n"
			"  -W, --weekday=COLOR   specify weekday day color with RRGGBB\n"
			"  -S, --saturday=COLOR  specify saturday color with RRGGBB\n"
			"  -H, --holiday=COLOR   specify holiday color with RRGGBB\n"
			"  -h, --help            display this help and exit\n\n", 
			arg) ;
	exit (0) ;
} ;

void get_color (rgb_color *c, const char *rgbstr) {
	uint32 rrggbb = strtoul (rgbstr, NULL, 16) ;
	c->blue = rrggbb & 0xff ;
	rrggbb >>= 8 ;
	c->green = rrggbb & 0xff ;
	rrggbb >>= 8 ;
	c->red = rrggbb & 0xff ;
} ;

int main (int argc, char **argv) {
	float width = 105 ;
	alignment align = B_ALIGN_CENTER ;
	char *format = NULL ;
	int value = -1 ;
	int index = 0 ;
	
	static struct option ops[] = {
		{"left", 0, 0, 'l'}, 
		{"center", 0, 0, 'c'}, 
		{"right", 0, 0, 'r'}, 
		{"format", 1, 0, 'f'}, 
		{"width", 1, 0, 'w'}, 
		{"weekday", 1, 0, 'W'}, 
		{"saturday", 1, 0, 'S'}, 
		{"holiday", 1, 0, 'H'}, 
		{"help", 0, 0, 'h'}, 
		{0, 0, 0, 0}
	} ;
	
	do {
		value = getopt_long (argc, argv, "lcrf:w:W:S:H:h", ops, &index) ;
		switch (value) {
			case 'l' : // left
				align = B_ALIGN_LEFT ;
				break ;
			case 'c' : // center
				align = B_ALIGN_CENTER ;
				break ;
			case 'r' : // right
				align = B_ALIGN_RIGHT ;
				break ;
			case 'f' : // format
				if (format) {
					delete[] format ;
					format = NULL ;
				}
				format = strdup (optarg) ;
				break ;
			case 'w' : // width
				width = (float)(atof (optarg)) ;
				break ;
			case 'W' : // weekday
				get_color (&gWeekday, optarg) ;
				break ;
			case 'S' : // saturday
				get_color (&gSaturday, optarg) ;
				break ;
			case 'H' : // holiday
				get_color (&gHoliday, optarg) ;
				break ;
			case 'h' : // help
				usage (argv[0]) ;
				break ;
		}
	} while (value != -1) ;
	if (optind < argc) usage (argv[0]) ;
	
	BApplication app (d_signature) ;
	
	BMessenger msgr ("application/x-vnd.Be-TSKB", -1, NULL) ;
	BMessage archive (B_ARCHIVED_OBJECT) ;
	DateView *view = new DateView (BRect (0, 0, width, 16)) ;
	
	if (format) view->SetFormat (format) ;
	view->SetAlignment (align, B_ALIGN_BOTTOM) ;
	
	view->Archive (&archive) ;
	msgr.SendMessage (&archive) ;
	
	delete view ;
	
//	printf ("format=%s, width=%f, align=%d, weekday=%08x, saturday=%08x, holiday=%08x\n", 
//			format, width, align, *((uint32*)d_weekday), *((uint32*)d_saturday), *((uint32*)d_holiday)) ;
	
	
	return 0 ;
} ;