#include <Alert.h>
#include "PreferencesTools.h"

ToolsException::ToolsException(const std::string s)
{
	std::string m = "Settings file error:\n\t" + s;
	(new BAlert("Simple Date", m.c_str(),"OK"))->Go();
}

std::string getString(FILE *f)
{
	std::string s = "";
	char c = 0;
	
	while ( !feof(f) && isspace(c = fgetc(f)) ) ;
	
	if (c != '\"')
		throw ToolsException("Expected \" (begin string)");
	
	while ( !feof(f) && (c = fgetc(f)) != '\"' && c != '\n')
	{
		if (!feof(f) && c == '\\')
			c = fgetc(f);
			
		s += c;
	}
		
	if (c != '\"')
		throw ToolsException("Expected \" (end string)");
		
	return std::string(s.c_str());
}

float getFloat(FILE *f)
{
	float x = 0.0;
	
	if (fscanf(f, "%f", &x) != 1)
		throw ToolsException("Expected integer value");
	
	return x;
}

int getInteger(FILE *f)
{
	int x = 0;
	
	if (fscanf(f, "%d", &x) != 1)
		throw ToolsException("Expected integer value");
	
	return x;
}

bool getBoolean(FILE *f)
{
	std::string s = getString(f);
	
	if (s != "On" && s != "Off")
		throw ToolsException("Expected boolean value (\"On\"/\"Off\")");
		
	return (s == "On")? true: false;
}

CharStyled getCharStyle(FILE *f)
{
	std::string s = getString(f);
	
	if (s != "Upper" && s != "Lower" && s != "Normal")
		throw ToolsException("Expected char style value (\"Upper\"/\"Lower\"/\"Normal\")");
		
	return (s == "Upper") ? s_upper: (s == "Lower")? s_lower: 0;
}

void s_lower(char *s)
{
  for (unsigned i = 0; i < strlen(s); i++)
    s[i] = tolower(s[i]);
}

void s_upper(char *s)
{
  for (unsigned i = 0; i < strlen(s); i++)
    s[i] = toupper(s[i]);
}