/*  sshLogin- written by Brian Hill, perelandra@iname.com
    
    This program was written for BeOS (www.be.com) and provides a simple
    graphical interface for using ssh, ftp, and other telnet and ftp clients.
    
    
    --Protected under General Public License--
    
    Copyright (C) 2001,  Brian Hill <perelandra@iname.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "sshLogin.h"

#define app_sig "application/x-vnd.CT-SSHLogin"
#define SSHL_settingsDir "sshLogin"
#define SSHL_version "1.2"
const rgb_color bg_color = {216,216,216,0};

int main(int argc, char** argv)
{	SSHLApp myApp;
	myApp.Run();
	return(0);
}
SSHLApp::SSHLApp()
	:BApplication(app_sig)
{	aWindow = new SSHLWindow(BRect(200,50,370,120));
}
SSHLApp::~SSHLApp()
{	}
/*void SSHLApp::ReadyToRun()
{	BEntry sshEntry("/bin/ssh");
	if(!sshEntry.Exists())
	{	sshEntry.SetTo("/boot/home/config/bin/ssh");
		if(!sshEntry.Exists())
		{	(new BAlert("", "The ssh shell does not exist in /bin or ~/config/bin.  "
					"Please download ssh with the provided bookmark.",
					"OK", NULL, NULL, B_WIDTH_AS_USUAL, B_STOP_ALERT))->Go();
			be_app->PostMessage(B_QUIT_REQUESTED);
		}
	}
}*/
SSHLWindow::SSHLWindow(BRect viewRect)
	:BWindow(viewRect, "sshLogin", B_TITLED_WINDOW, B_NOT_ZOOMABLE | B_NOT_V_RESIZABLE)
{	Lock();
	BRect dummyRect(0,0,0,0);
	mainMenuBar = new BMenuBar(dummyRect, "Main Menu");
	//File menu
	fileMenu = new BMenu("File");
	fileMenu->AddItem(new BMenuItem("About...", new BMessage(B_ABOUT_REQUESTED)));
	fileMenu->AddSeparatorItem();
	fileMenu->AddItem(new BMenuItem("Quit", new BMessage(B_QUIT_REQUESTED), 'Q'));
	mainMenuBar->AddItem(fileMenu);
	//Recent menu
	recentMenu = new BMenu("Recent");
	mainMenuBar->AddItem(recentMenu);
	//Settings menu
	settingsMenu = new BMenu("Settings");
	recentNumMenu = new BMenu("Save the last...");
	recentNumMenu->AddItem(new BMenuItem("Don't save hosts", NULL));
	recentNumMenu->AddItem(new BMenuItem("Save the last 10 hosts", NULL));
	recentNumMenu->AddItem(new BMenuItem("Save the last 20 hosts", NULL));
	recentNumMenu->AddItem(new BMenuItem("Save all hosts", NULL));
	recentNumMenu->SetRadioMode(true);
	recentNumMenu->SetLabelFromMarked(true);
	recentNumMenu->ItemAt(0)->SetMarked(true);
	settingsMenu->AddItem(recentNumMenu);
	settingsMenu->AddItem(new BMenuItem("Clear all recent hosts now",
							new BMessage(CLEAR_RECENT)));
	mainMenuBar->AddItem(settingsMenu);
	AddChild(mainMenuBar);
	//Main View
	viewRect = Bounds();
	viewRect.top = (mainMenuBar->Frame().bottom + 1);
	mainView = new BView(viewRect, "Main View", B_FOLLOW_ALL, B_WILL_DRAW);
	mainView->SetViewColor(bg_color);
	dummyRect.OffsetTo(5,5);
	dummyRect.right = Bounds().right - 5;
	dummyRect.bottom = dummyRect.top + 10;
	hostTC = new BTextControl(dummyRect, "Host name", "Host:", NULL,
							new BMessage(NEW_HOST), B_FOLLOW_LEFT_RIGHT);
	hostTC->SetDivider(be_plain_font->StringWidth(hostTC->Label()) + 4);
	mainView->AddChild(hostTC);
	dummyRect.OffsetTo(hostTC->Frame().left, hostTC->Frame().bottom + 5);
	usernameCB = new BCheckBox(dummyRect, "User Name", "Use user name:", NULL);
	usernameCB->ResizeToPreferred();
	mainView->AddChild(usernameCB);
	dummyRect.OffsetBy(usernameCB->Frame().Width(), 0);
	dummyRect.right = Bounds().right - 5;
	usernameTC = new BTextControl(dummyRect, "User Name Text", NULL, NULL,
							new BMessage(NEW_USERNAME), B_FOLLOW_LEFT_RIGHT);
	mainView->AddChild(usernameTC);
	dummyRect.OffsetTo(usernameCB->Frame().left, usernameCB->Frame().bottom + 5);
	portnumberCB = new BCheckBox(dummyRect, "Use Port", "Use Port:", NULL);
	portnumberCB->ResizeToPreferred();
	mainView->AddChild(portnumberCB);
	dummyRect.OffsetBy(portnumberCB->Frame().Width(), 0);
	//dummyRect.right = dummyRect.left + be_plain_font->StringWidth("0000000000");
	dummyRect.right = hostTC->Frame().right;
	portnumberTC = new BTextControl(dummyRect, "Port Number", NULL, NULL,
							new BMessage(NEW_PORT), B_FOLLOW_LEFT_RIGHT);
	long i;
	for (i = 0; i < 256; i++) portnumberTC->TextView()->DisallowChar(i);
	for (i = '0'; i <= '9'; i++) portnumberTC->TextView()->AllowChar(i);
	portnumberTC->TextView()->AllowChar(B_BACKSPACE);
	mainView->AddChild(portnumberTC);
	
/*	dummyRect.OffsetTo(hostTC->Frame().left, portnumberTC->Frame().bottom + 5);
	dummyRect.right = hostTC->Frame().right;
	passTC = new BTextControl(dummyRect, "Password", "Password:", NULL, NULL,
								B_FOLLOW_LEFT_RIGHT);
	passTC->SetDivider(be_plain_font->StringWidth(passTC->Label()) + 4);
	passTC->TextView()->HideTyping(true);
	mainView->AddChild(passTC);
*/	protocolMenu = new BPopUpMenu("Choose Protocol");
	BEntry bin, hbin;
	BPath systembinPath, userbinPath;
	BDirectory systembinDir, userbinDir;
	find_directory(B_USER_SETTINGS_DIRECTORY, &settingsP);
	find_directory(B_BEOS_BIN_DIRECTORY, &systembinPath);
	find_directory(B_COMMON_BIN_DIRECTORY, &userbinPath);
	systembinDir.SetTo(systembinPath.Path());
	userbinDir.SetTo(userbinPath.Path());
#if ssh_support//ssh
	protocolMenu->AddItem(new BMenuItem("ssh", new BMessage(PROTOCOL_CHANGED)));
	bin.SetTo(&systembinDir, "ssh");
	hbin.SetTo(&userbinDir, "ssh");
	if( !bin.Exists() && !hbin.Exists()) { protocolMenu->ItemAt(0)->SetEnabled(false); }
#endif
#if telnet_support//telnet
	protocolMenu->AddItem(new BMenuItem("telnet", new BMessage(PROTOCOL_CHANGED)));
	bin.SetTo(&systembinDir, "telnet");
	hbin.SetTo(&userbinDir, "telnet");
	if( !bin.Exists() && !hbin.Exists()) { protocolMenu->ItemAt(1)->SetEnabled(false); }
#endif
#if ftp_support//ftp
	protocolMenu->AddItem(new BMenuItem("ftp", new BMessage(PROTOCOL_CHANGED)));
	bin.SetTo(&systembinDir, "ftp");
	hbin.SetTo(&userbinDir, "ftp");
	if( !bin.Exists() && !hbin.Exists()) { protocolMenu->ItemAt(2)->SetEnabled(false); }
#endif
#if nftp_support//nftp
	protocolMenu->AddItem(new BMenuItem("nftp", new BMessage(PROTOCOL_CHANGED)));
	bin.SetTo(&systembinDir, "nftp");
	hbin.SetTo(&userbinDir, "nftp");
	if( !bin.Exists() && !hbin.Exists()) { protocolMenu->ItemAt(3)->SetEnabled(false); }
#endif
#if ncftp_support//ncftp
	protocolMenu->AddItem(new BMenuItem("ncftp", new BMessage(PROTOCOL_CHANGED)));
	bin.SetTo(&systembinDir, "ncftp");
	hbin.SetTo(&userbinDir, "ncftp");
	if( !bin.Exists() && !hbin.Exists()) { protocolMenu->ItemAt(4)->SetEnabled(false); }
#endif
	for(int i=0; i<protocolMenu->CountItems(); i++)
	{	if(protocolMenu->ItemAt(i)->IsEnabled())
		{	protocolMenu->ItemAt(i)->SetMarked(true);
			break;
		}
	}
	dummyRect.OffsetTo(hostTC->Frame().left, portnumberTC->Frame().bottom + 3);
	dummyRect.right = hostTC->Frame().right;
	protocolField = new BMenuField(dummyRect, "Protocol Field", "Protocol:",
							protocolMenu);
	protocolField->SetDivider(be_plain_font->StringWidth(protocolField->Label()) + 4);
	mainView->AddChild(protocolField);
	dummyRect.OffsetTo(protocolField->Frame().right + 5, dummyRect.top);
	loginB = new BButton(dummyRect, "Login Button", "Login", new BMessage(SSH_LOGIN),
							B_FOLLOW_NONE);
	loginB->ResizeTo(be_plain_font->StringWidth(loginB->Label()) + 12,
					portnumberTC->Frame().Height() + 1);
	loginB->MoveTo(hostTC->Frame().right - loginB->Frame().Width(), loginB->Frame().top);
	mainView->AddChild(loginB);
	AddChild(mainView);
	ResizeTo(loginB->Frame().right + 5,
				mainView->Frame().top + protocolField->Frame().bottom + 3);
	loginB->SetResizingMode(B_FOLLOW_RIGHT);
	SetSizeLimits(Bounds().Width(), 1000, 0, 1000);
	//Settings
	BPath settingsPath(settingsP.Path(), SSHL_settingsDir);
	BDirectory settingsDir;
	if( settingsDir.SetTo(settingsPath.Path()) == B_ENTRY_NOT_FOUND )
	{	//(new BAlert("","Settings directory not found, creating directory "
						//"~/config/settings/sshLogin", "OK"))->Go();
		if(settingsDir.CreateDirectory(settingsPath.Path(), &settingsDir)!=B_OK)
		{	(new BAlert("","Error creating settings folder","OK"))->Go(); }
	}
	settingsPath.Append("settings");
	BEntry archiveEntry(settingsPath.Path());
	if(archiveEntry.Exists())
	{	BFile archiveFile(&archiveEntry, B_READ_ONLY);
		off_t datasize;
		archiveFile.GetSize(&datasize);
		char *databuf = new char[datasize];
		BMessage archive;
		if((archiveFile.Read(databuf, datasize))!=datasize)
		{	//(new BAlert("","Error loading archive file","OK",
			//				NULL, NULL, B_WIDTH_AS_USUAL, B_STOP_ALERT))->Go();
		}
		else if(archive.Unflatten(databuf)!=B_OK)
		{	//(new BAlert("","Error reading archived settings","OK",
			//				NULL, NULL, B_WIDTH_AS_USUAL, B_STOP_ALERT))->Go();
		}
		else
		{	float windowTop, windowLeft;
			if( archive.FindFloat("SSHL:windowTop",&windowTop) == B_OK
				&& archive.FindFloat("SSHL:windowLeft",&windowLeft) == B_OK)
			{	MoveTo(windowLeft,windowTop); }
			if(archive.FindFloat("SSHL:windowWidth",&windowTop) == B_OK)
			{	ResizeTo(windowTop, Bounds().Height()); }
			restoreSettings(archive);
		}
		delete[] databuf;
	}
	recentList.clear();
	settingsPath.GetParent(&settingsPath);
	settingsPath.Append("recent");
	ifstream readfile(settingsPath.Path(), ios::in);
	if(readfile)
	{	char *buffer = new char[256];
		RecentItem item;
		while(!readfile.eof())
		{	readfile.getline(buffer, 256);
			if(strcmp(buffer,"")==0) { continue; }
			item.SetTo(buffer);
			recentList.push_back(item);
		}
		delete[] buffer;
		updateRecent();
	}
	Unlock();
	Show();
}
SSHLWindow::~SSHLWindow()
{	BMessage archive;
	archive.AddFloat("SSHL:windowTop", Frame().top);
	archive.AddFloat("SSHL:windowLeft", Frame().left);
	archive.AddFloat("SSHL:windowWidth", Bounds().Width());
	storeSettings(archive);
	BPath settingsPath(settingsP.Path(), SSHL_settingsDir"/settings");
	BFile saveFile(settingsPath.Path(), B_READ_WRITE | B_CREATE_FILE | B_ERASE_FILE);
	int datasize = archive.FlattenedSize();
	char *databuf = new char[datasize];
	if(archive.Flatten(databuf, datasize)!=B_OK)
	{	//(new BAlert("","Error flattening data archive.","OK",
		//				NULL, NULL, B_WIDTH_AS_USUAL, B_STOP_ALERT))->Go();
	}
	else if( (saveFile.Write(databuf, datasize))!=datasize )
	{	//(new BAlert("","Error writing archive file.","OK",
		//				NULL, NULL, B_WIDTH_AS_USUAL, B_STOP_ALERT))->Go();
	}
	delete[] databuf;
	recentList.clear();
}
bool SSHLWindow::QuitRequested()
{	be_app->PostMessage(B_QUIT_REQUESTED);
	return(true);
}
void SSHLWindow::AboutRequested()
{	(new BAlert("About sshLogin",	"sshLogin v"SSHL_version"\n\n"
								"An application for remotely logging into "
								"systems using telnet or ftp protocols.\n\n"
								"Brian Hill, Perelandra@iname.com\n"
								"Copyright 2001",
								"OK"))->Go();
	return;
}
bool SSHLWindow::login()
{	int arg_c = 0;
	char *arg_v[6];
	arg_v[arg_c++] = "/bin/sh";
	arg_v[arg_c++] = "--login";
	arg_v[arg_c++] = "-i";
	arg_v[arg_c++] = "-c";
	BString loginArg(protocol_command());
	//(new BAlert("",loginArg.String(),"OK"))->Go();
	arg_v[arg_c++] = (char*)loginArg.String();
	char *termSig = "application/x-vnd.Be-SHEL";
	team_id termTeam;
	status_t result = be_roster->Launch(termSig, arg_c, arg_v, &termTeam);
	if (result != B_NO_ERROR)
	{	(new BAlert("", "Error launching terminal", "OK", NULL, NULL,
					B_WIDTH_AS_USUAL, B_STOP_ALERT))->Go();
		return false;
	}
	return true;
}
BString SSHLWindow::protocol_command()
{	BString protoArg("echo Logging into ");
	protoArg.Append(hostTC->Text());
	protoArg.Append(" using ");
	protoArg.Append(protocolMenu->FindMarked()->Label());
	protoArg.Append("...; ");
	protoArg.Append(protocolMenu->FindMarked()->Label());
	protoArg.Append(" ");
	switch(protocolMenu->IndexOf(protocolMenu->FindMarked()))
	{case 0: {//ssh
		if(usernameCB->Value())
		{	protoArg.Append("-l ");
			protoArg.Append(usernameTC->Text());
			protoArg.Append(" ");
		}
		if(portnumberCB->Value())
		{	protoArg.Append("-p ");
			protoArg.Append(portnumberTC->Text());
			protoArg.Append(" ");
		}
		protoArg.Append(hostTC->Text());
		break; }
	case 1://telnet
	case 2: {//ftp
		protoArg.Append(hostTC->Text());
		if(portnumberCB->Value())
		{	protoArg.Append(" ");
			protoArg.Append(portnumberTC->Text());
		}
		break; }
	case 3: {//nftp
		if(usernameCB->Value())
		{	protoArg.Append(usernameTC->Text());
			protoArg.Append("@");
		}
		protoArg.Append(hostTC->Text());
		if(portnumberCB->Value())
		{	protoArg.Append(":");
			protoArg.Append(portnumberTC->Text());
		}
		break; }
	case 4: {//ncftp
		if(usernameCB->Value())
		{	protoArg.Append("-u ");
			protoArg.Append(usernameTC->Text());
			protoArg.Append(" ");
		}
		if(portnumberCB->Value())
		{	protoArg.Append("-P ");
			protoArg.Append(portnumberTC->Text());
			protoArg.Append(" ");
		}
		protoArg.Append(hostTC->Text());
		break; }
	}
	return protoArg;
}
void SSHLWindow::updateRecent()
{	int i, count;
	count = recentMenu->CountItems();
	for(i=count-1; i>=0; i--)
	{	delete recentMenu->RemoveItem(i); }
	count = recentList.size();
	BString msgLabel("");
	
	for(i=0; i<count; i++)
	{	msgLabel.SetTo(recentList[i].host);
		if(recentList[i].protocol != "")
		{	msgLabel.Append(" (");
			msgLabel.Append(recentList[i].protocol);
			msgLabel.Append(")");
		}
		if(recentList[i].username != "")
		{	msgLabel.Append("  user:");
			msgLabel.Append(recentList[i].username);
		}
		if(recentList[i].port != "")
		{	msgLabel.Append("  port:");
			msgLabel.Append(recentList[i].port);
		}
		recentMenu->AddItem(new BMenuItem(msgLabel.String(), new BMessage(SPECIFY_RECENT)), i);
	}
	return;
}
bool SSHLWindow::add_recent(RecentItem& recent)
{	int recentCount = recentNumMenu->IndexOf(recentNumMenu->FindMarked());
	if(recentCount == 0) return true;
	if(recentCount == 1) recentCount = 10;
	else if(recentCount == 2) recentCount = 20;
	else recentCount = 99;
	for(int i=0; i<(int)recentList.size(); i++)
	{	if(recentList[i] == recent) { recentList.erase(&recentList[i]); } }
	recentList.insert(recentList.begin(), recent);
	BPath settingsPath(settingsP.Path(), SSHL_settingsDir"/recent");
	BFile recentFile(settingsPath.Path(), B_READ_WRITE | B_CREATE_FILE | B_ERASE_FILE);
	BString recentString;
	for(int j=0; j<(int)recentList.size(); j++)
	{	recentString.SetTo(recentList[j].host);
		if(recentList[j].username != "")
		{	recentString.Append(" user:");
			recentString.Append(recentList[j].username);
		}
		if(recentList[j].port != "")
		{	recentString.Append(" port:");
			recentString.Append(recentList[j].port);
		}
		if(recentList[j].protocol != "")
		{	recentString.Append(" protocol:");
			recentString.Append(recentList[j].protocol);
		}
		recentFile.Write(recentString.String(), recentString.Length());
		recentFile.Write("\n",1);
	}
	updateRecent();
	return true;
}
void SSHLWindow::clearRecent()
{	int ans = (new BAlert("", "Are you sure you want to delete all recent hosts?",
						"Delete All", "NO!", NULL,
						B_WIDTH_AS_USUAL, B_WARNING_ALERT))->Go();
	if(ans==0)
	{	BPath settingsPath(settingsP.Path(), SSHL_settingsDir"/recent");
		BFile recentFile(settingsPath.Path(), B_READ_WRITE | B_CREATE_FILE | B_ERASE_FILE);
		recentList.clear();
		updateRecent();
	}
}
void SSHLWindow::storeSettings(BMessage &archive)
{	archive.AddString("host", hostTC->Text());
	archive.AddBool("usernameCB", usernameCB->Value());
	archive.AddString("username", usernameTC->Text());
	archive.AddBool("portCB", portnumberCB->Value());
	archive.AddString("port", portnumberTC->Text());
	archive.AddString("protocol", protocolMenu->FindMarked()->Label());
	archive.AddInt32("recentNumber", recentNumMenu->IndexOf(recentNumMenu->FindMarked()) );
}
void SSHLWindow::restoreSettings(BMessage &archive)
{	Lock();
	const char *charPtr;
	bool bvalue;
	int32 ivalue;
	if(archive.FindString("host", &charPtr)==B_OK)
		hostTC->SetText(charPtr);
	if(archive.FindBool("usernameCB", &bvalue)==B_OK)
		usernameCB->SetValue(bvalue);
	if(archive.FindString("username", &charPtr)==B_OK)
		usernameTC->SetText(charPtr);
	if(archive.FindBool("portCB", &bvalue)==B_OK)
		portnumberCB->SetValue(bvalue);
	if(archive.FindString("port", &charPtr)==B_OK)
		portnumberTC->SetText(charPtr);
	if(archive.FindInt32("recentNumber", &ivalue)==B_OK)
		recentNumMenu->ItemAt(ivalue)->SetMarked(true);
	if(archive.FindString("protocol", &charPtr)==B_OK)
	{	protocolMenu->FindItem(charPtr)->SetMarked(true);
		PostMessage(PROTOCOL_CHANGED);
	}
	Unlock();
}
void SSHLWindow::MessageReceived(BMessage* msg)
{	switch(msg->what)
	{	case B_ABOUT_REQUESTED: {
			AboutRequested();
			break; }
		case SSH_LOGIN: {
			if(recentNumMenu->IndexOf(recentNumMenu->FindMarked()) != 0)
			{	RecentItem recent(hostTC->Text(), usernameCB->Value()?usernameTC->Text():"",
								portnumberCB->Value()?portnumberTC->Text():"",
								protocolMenu->FindMarked()->Label());
				add_recent(recent);
			}
			login();
			break; }
		case SPECIFY_RECENT: {
			Lock();
			int32 index;
			msg->FindInt32("index", &index);
			hostTC->SetText(recentList[index].host.String());
			usernameCB->SetValue(recentList[index].username != "");
			usernameTC->SetText(recentList[index].username.String());
			portnumberCB->SetValue(recentList[index].port != "");
			portnumberTC->SetText(recentList[index].port.String());
			if(recentList[index].protocol != "")
			{	protocolMenu->FindItem(recentList[index].protocol.String())->SetMarked(true);
				if(recentList[index].protocol=="ftp" || recentList[index].protocol=="telnet")
				{	usernameCB->SetEnabled(false); }
				else { usernameCB->SetEnabled(true); }
			}
			Unlock();
			break; }
		case PROTOCOL_CHANGED: {
			if(strcmp(protocolMenu->FindMarked()->Label(), "ftp")==0 ||
				strcmp(protocolMenu->FindMarked()->Label(), "telnet")==0)
			{	usernameCB->SetValue(0);
				usernameCB->SetEnabled(false);
			}
			else { usernameCB->SetEnabled(true); }
			break; }
		case CLEAR_RECENT: {
			clearRecent();
			break; }
	}
}
RecentItem::RecentItem()
	: host(""), username(""), port(""), protocol("")
{	}
RecentItem::RecentItem(const char* h, const char* u, const char* po, const char* pr)
	: host(h), username(u), port(po), protocol(pr)
{	}
bool RecentItem::operator==(RecentItem& ri)
{	return ( host==ri.host && username==ri.username && port==ri.port
			&& protocol==ri.protocol); }
void RecentItem::SetTo(char* t)
{	host = username = port = protocol = "";
	BString text(t), data("");
	vector<BString> dataVec;
	dataVec.clear();
	int i;
	while( (i = text.IFindFirst(" "))!=B_ERROR )//split settings into BStrings
	{	text.CopyInto(data, 0, i);
		text.Remove(0, i+1);
		dataVec.push_back(data);
	}
	text.RemoveSet(" ");
	if(text!="") { dataVec.push_back(text); }
	for(int j=0; j<(int)dataVec.size(); j++)//get each data setting
	{	if( (i = dataVec[j].IFindFirst(":"))!=B_ERROR )
		{	if(strncmp(dataVec[j].String(), "user", 4)==0)//user setting
			{	dataVec[j].CopyInto(username, i+1, dataVec[j].CountChars()-i); }
			else if(strncmp(dataVec[j].String(), "port", 4)==0)//port setting
			{	dataVec[j].CopyInto(port, i+1, dataVec[j].CountChars()-i); }
			else if(strncmp(dataVec[j].String(), "protocol", 8)==0)//protocol setting
			{	dataVec[j].CopyInto(protocol, i+1, dataVec[j].CountChars()-i);
				if(protocol!="ssh" && protocol!="telnet" && protocol!="ftp" && protocol!="nftp" && protocol!="ncftp")
				{	protocol = ""; }
			}
		}
		else//must be the host
		{	host = dataVec[j]; }
	}
	dataVec.clear();
	return;
}