#include "URLStatus.h"

char *find_header_end(char *buf, int bytes);

char *find_header_end(char *buf, int bytes) {

	char *end = buf + bytes;
  
	while (buf < end && !(*buf++ == '\n'
			      && (*buf == '\n'
				  || (*buf++ == '\r'
				      && *buf == '\n')))) ;
	if (*buf == '\n')
		return buf + 1;
	return NULL;
}

URLStatus::URLStatus( char *url, BRect rect, record_ref bfile ) : WinStatusBar( rect, 0 )
{
	strcpy( urlcp, url );
	SetText( urlcp );
	SetTrailingText( "Connecting..." );
	sock = 0;
	file.SetRef( bfile );
	Go();
}

URLStatus::~URLStatus()
{
}

void URLStatus::Stop()
{
	printf( "URLStatus::Stop()\n" );
	if( sock != 0 )
		delete sock;
	if( find_thread( NULL ) != my_thread )
	{
		printf( "Killing kids\n" );
		kill_thread( my_thread );
		printf( "Killed\n" );
	}
	printf( "sock deleted\n" );
	file.Close();
	printf( "close file\n" );
	WinStatusBar::Stop();
	printf( "stopped\n" );
}

long URLStatus::entry_func( void *arg )
{
	URLStatus *obj = (URLStatus *)arg;
	return( obj->entryFunc() );
}

#define BUFLEN 10 * 1024

long URLStatus::entryFunc()
{
	char buf[BUFLEN];
	char header[1024];
	char request[MAXPATHLEN + 40];
	char *h_end_ptr, *length;
	BDirectory bdir;
	fd_set set;
	int in_header;
	int total_bytes, header_bytes;
	int bytes;
	int contentlen, response;
	int delta;
	bool found = TRUE;
	StatusWindow *win;
	struct timeval tv;

	header[0] = 0;
	sock = new URLSocket( urlcp );
	win = ((StatusWindow *)Window());
	if( sock->Error() == NSERR_NONE )
	{
		FD_ZERO( &set );
		sock->SetMask( &set );
		tv.tv_sec = 0;
		tv.tv_usec = 500000;
		sock->Connect();
		if( sock->Error() == NSERR_NONE )
		{
			sprintf( request, "GET %s HTTP/1.0\r\n", sock->Path() );
			strcat( request, "Accept: */*\r\n\r\n" );
			sock->Write( request, strlen( request ), 0 );
			select( 32, &set, NULL, NULL, NULL );
			in_header = 1;
			total_bytes = 0;
			header_bytes = 0;
			file.Open( B_EXCLUSIVE );
			while( (bytes = sock->Read( buf, BUFLEN, 0 )) != 0 )
			{
				total_bytes += bytes;
				if( in_header )
				{
					h_end_ptr = find_header_end( buf, total_bytes );
					
					if (h_end_ptr != NULL)
					{
						/* Found, print up to delimiter to stderr and rest to stdout */
						//fwrite(buf, h_end_ptr - buf, 1, stderr);
						header_bytes += h_end_ptr - buf;
						strncat( header, buf, h_end_ptr - buf );
						sscanf( header + 9, "%d", &response );
						if( !((response >= 200) && (response < 300)) )
						{
							BAlert *alert;
							char errorstr[256];
		
							sprintf( errorstr, "Response %d from server\nUnable to get %s", response, urlcp );
							alert = new BAlert( "HTTPGet", errorstr, "OK" );
							alert->Go();
							file.Close();
							file.GetParent( &bdir );
							bdir.Remove( &file );
							Stop();
							exit_thread( 0 );
						}
						if( !(length = strstr( header, "Content-length" )) )
						{
							length = strstr( header, "Content-Length" );
						}
						if( length )
						{
							length += 16;
							sscanf( length, "%d", &contentlen );
						}
						else
							contentlen = 0;
						win->Lock();
						SetText( 0 );
						SetTrailingText( 0 );
						file.GetName( request );
						Reset( request, 0 );
						SetMaximum( (float)contentlen );
						//fprintf(stderr, "----- HTTP reply header end -----\n");
						//fwrite(h_end_ptr, bytes - (h_end_ptr - buf), 1, stdout);
						file.Write( h_end_ptr, bytes - (h_end_ptr - buf) );
						delta = bytes - (h_end_ptr - buf);
						sprintf( header, "%d/%d", delta, contentlen );
						Progress( (float)delta, 0, header );
						win->Unlock();
						in_header = 0;
					}
					else
					{
						/* Not found, print all in buf to stderr and read for more headers */
						fwrite(buf, bytes, 1, stderr);
						strncat( header, buf, bytes );
						header_bytes += bytes;
					}
					fflush(stderr);
				}
				else
				{
					win->Lock();
					sprintf( header, "%d/%d", total_bytes - header_bytes, contentlen );
					Progress( (float)bytes, 0, header );
					win->Unlock();
					//fwrite(buf, bytes, 1, stdout);
					file.Write( buf, bytes );
				}
			}
			file.Close();
		}
		else
		{
			BAlert *alert;
			char errorstr[256];
		
			sprintf( errorstr, "Cannot connect to url:\n%s", urlcp );
			alert = new BAlert( "HTTPGet", errorstr, "OK" );
			alert->Go();
			file.Close();
			file.GetParent( &bdir );
			bdir.Remove( &file );
		}
	}
	else
	{
		BAlert *alert;
		char errorstr[256];
		
		sprintf( errorstr, "Cannot connect to url:\n%s", urlcp );
		alert = new BAlert( "HTTPGet", errorstr, "OK" );
		alert->Go();
		file.Close();
		file.GetParent( &bdir );
		bdir.Remove( &file );
	}
	Stop();
	return( 0 );
}

long URLStatus::Go()
{
	if( (my_thread = spawn_thread( entry_func, "URLThread", B_NORMAL_PRIORITY, this )) < B_NO_ERROR )
		return( B_ERROR );
	else
		return( resume_thread( my_thread ) );
}
