#include "StatusWindow.h"

StatusWindow::StatusWindow( BRect frame, char *name ) : BWindow( frame, name, B_TITLED_WINDOW, B_NOT_V_RESIZABLE|B_NOT_CLOSABLE|B_NOT_ZOOMABLE )
{
	BRect rect;
	BStatusBar *temp;
		
	Lock();

	frame.Set( 0, 0, frame.Width(), frame.Height() );
	background = new BView( frame, "Background", B_FOLLOW_ALL_SIDES, B_FRAME_EVENTS|B_WILL_DRAW );
	AddChild( background );
	background->SetViewColor( 200, 200, 200 );
	background->SetLowColor( 200, 200, 200 );
	
	stopfr.Set( 10, 10, 20, 20 );
	stop = new BButton( stopfr, "Stop", "Stop", new BMessage( SW_StopButton ) );
	background->AddChild( stop );
	stop->ResizeBy( stop->StringWidth( "  Stop  " ), 0 );
	stopfr = stop->Frame();
	ResizeTo( stopfr.Width() + 20, stopfr.Height() + 20 );
	stop->SetResizingMode( B_FOLLOW_H_CENTER|B_FOLLOW_BOTTOM );
	
	rect.Set( 10, 10, 20, 20 );
	temp = new BStatusBar( rect, 0, 0 );
	AddChild( temp );
	rect = temp->Bounds();
	height = rect.Height();
	delete temp;
	
	Unlock();
}

void StatusWindow::Quit()
{
	WinStatusBar *sbar;
	
	Lock();
	sbar = (WinStatusBar *)background->ChildAt( 1 );
	while( sbar )
	{
		sbar->Stop();
		sbar = (WinStatusBar *)background->ChildAt( 1 );
	}
	Unlock();
	BWindow::Quit();
}

StatusWindow::AddStatusBar( WinStatusBar *sbar )
{
	BRect rect, sbarrect;
	
	Lock();
	rect = Bounds();
	sbarrect = sbar->Bounds();
	sbar->MoveTo( STATXGUTTER, rect.Height() - stopfr.Height() - 20 + 1 );
	ResizeBy( (sbarrect.Width() > rect.Width()) ? sbarrect.Width() - rect.Width() + 2*STATXGUTTER : 0, height + 1 );
	rect = Bounds();
	sbar->ResizeBy( rect.Width() - sbarrect.Width() - 2 * STATXGUTTER, 0 );
	background->AddChild( sbar );
	Unlock();
	if( IsHidden() )
		Show();
}

StatusWindow::RemStatusBar( WinStatusBar *sbar )
{
	BRect rect;
	WinStatusBar *next;
	
	Lock();
	rect = sbar->Bounds();
	next = (WinStatusBar *)sbar->NextSibling();
	background->RemoveChild( sbar );
	for( ; next; next = (WinStatusBar *)next->NextSibling() )
	{
		next->MoveBy( 0, -rect.Height() );
	}
	if( background->CountChildren() == 1 )
		Hide();
	ResizeBy( 0, -rect.Height() );
	Unlock();
}

void StatusWindow::MessageReceived( BMessage *msg )
{
	switch( msg->what )
	{
		case SW_StopButton:
			{
				int index, count;
				WinStatusBar *sbar;
				
				count = background->CountChildren();
				for( index = 1; index < count; index++ )
				{
					sbar = (WinStatusBar *)background->ChildAt( index );
					if( sbar->StopRequested() )
					{
						sbar->Stop();
						index--;
						count--;
					}
				}
			}
			break;
		default:
			BWindow::MessageReceived( msg );
			break;
	}
}

WinStatusBar::WinStatusBar( BRect frame,
							const char *name,
							const char *static_label,
							const char *trailing_static_label ) :
							BStatusBar( frame, name, static_label, trailing_static_label )
{
	selected = FALSE;
	SetResizingMode( B_FOLLOW_LEFT_RIGHT );
	SetFlags( Flags()|B_FULL_UPDATE_ON_RESIZE );
}

WinStatusBar::~WinStatusBar()
{
}

bool WinStatusBar::StopRequested()
{
	return( selected );
}

void WinStatusBar::Stop()
{
	((StatusWindow *)Window())->RemStatusBar( this );
	delete this;
}

void WinStatusBar::MouseDown( BPoint point )
{
	rgb_color old;

	old = HighColor();
	selected ^= TRUE;
	if( selected )
		SetHighColor( 0, 0, 0 );
	else
		SetHighColor( 200, 200, 200 );
	StrokeRect( Bounds() );
	SetHighColor( old );
}

void WinStatusBar::Draw( BRect rect )
{
	rgb_color old;
	
	BStatusBar::Draw( rect );
	old = HighColor();
	if( selected )
		SetHighColor( 0, 0, 0 );
	else
		SetHighColor( 200, 200, 200 );
	StrokeRect( Bounds() );
	SetHighColor( old );
}
