/*
	SocketClass.h
*/
#ifndef NetSocket_h
#define NetSocket_h

#include <stdio.h>

#include <sys/types.h>
#include <sys/param.h>
#include <net/socket.h>
#include <net/netdb.h>

#define NSB_CONNECTED 0
#define NSB_AVAIL 1

#define NSF_CONNECTED (1L << NSB_CONNECTED)
#define NSF_AVAIL (1L << NSB_AVAIL)

#define NSERR_NONE 0
#define NSERR_UNKNOWNHOST 1
#define NSERR_SOCKET 2
#define NSERR_CONNECT 3

class NetSocket : public BObject {
	
	public:
		NetSocket();
		NetSocket( char *host, int port );
		~NetSocket();
	int SetHostPort( char *host, int port );
	int Connect()
		{
			if( error == NSERR_NONE )
			{
				if( connect( s, (struct sockaddr *)&addr, sizeof( addr ) ) == -1 )
				{
					error = NSERR_CONNECT;
					return( 0 );
				}
				flags |= NSF_CONNECTED;
				return( 1 );
			}
			return( 0 );
		};
	int	Connected()
		{
			return( flags & NSF_CONNECTED );
		};
	int Write( const char *buffer, int size, int flags )
		{
			return( send( s, buffer, size, flags ) );
		};
	int Read( char *buffer, int size, int flags )
		{
			return( recv( s, buffer, size, flags ) );
		};
	int Blocking( int flag )
		{
			char zero = 0;
			
			if( flag )
			{
				return( setsockopt( s, SOL_SOCKET, SO_NONBLOCK, (char *)&zero, sizeof( char ) ) );
			}
			else
			{
				zero = 1;
				return( setsockopt( s, SOL_SOCKET, SO_NONBLOCK, (char *)&zero, sizeof( char ) ) );
			}
		};
	void SetMask( fd_set *set )
		{
			FD_SET( s, set );
		};
	void ClearFromMask( fd_set *set )
		{
			FD_CLR( s, set );
		};
	int IsMaskSet( fd_set *set )
		{
			return( FD_ISSET( s, set ) );
		};
	int Error()
		{
			return( error );
		};
		
	private:
		struct hostent *nameinfo;
		struct sockaddr_in addr;
		int s;
		unsigned long flags;
		int error;
};

#endif
