#include "NetSocket.h"

NetSocket::NetSocket()
{
	flags = 0;
}

NetSocket::NetSocket( char *host, int port )
{
	flags = 0;
	error = NSERR_NONE;
	SetHostPort( host, port );
}

NetSocket::~NetSocket()
{
	closesocket( s );
}

int NetSocket::SetHostPort( char *host, int port )
{
	if( flags & NSF_CONNECTED )
	{
		closesocket( s );
		flags &= ~(NSF_CONNECTED|NSF_AVAIL);
	}
	if( (nameinfo = gethostbyname( host )) == NULL )
	{
		addr.sin_addr.s_addr = inet_addr( host );
		if( (int)addr.sin_addr.s_addr == -1 )
		{
			error = NSERR_UNKNOWNHOST;
			return( 0 );
		}
	}
	else
	{
		memcpy( (char *)&addr.sin_addr.s_addr, nameinfo->h_addr, nameinfo->h_length );
	}
	if( (s = socket( AF_INET, SOCK_STREAM, 0 )) == -1 )
	{
		error = NSERR_SOCKET;
		return( 0 );
	}
	error = NSERR_NONE;
	flags |= NSF_AVAIL;
	addr.sin_family = AF_INET;
	addr.sin_port = htons( port );
	return( 0 );
}
