
#include <netdb.h>
#include <socket.h>
#include <stdio.h>
#include <signal.h>

typedef struct ident_data
{
	FILE		*log_file;
	
	char		*username;
	
	int			client;
	
}ident_data;

void main(int argc, char **argv);

void _identd(char *log_file);
long _ident_thread(ident_data *data);

void print_to_log(FILE *file, char *data);

bool		running = true;

void main(int argc, char **argv)
{
	/*if (argc == 2)
		_identd(argv[1]);	// With a log file
	else*/
	_identd(NULL);		// Without one
}

void _identd(char *log_file)
{
	FILE			*file = NULL;
	
	char			username[256];
	
	ident_data		*ident;
	
	int				server;
	sockaddr_in		saddr_in;
	
	int				client;
	sockaddr_in		c_addr;
	int				c_size;
	
	thread_id		ident_t;
	
	if (log_file != NULL)
	{
		file = fopen(log_file, "wb+");
	}
	
	print_to_log(file, "Starting up identd....\n");
	
	saddr_in.sin_family = AF_INET;
	saddr_in.sin_port = htonl(113);
	saddr_in.sin_addr.s_addr = 0;
	memset(saddr_in.sin_zero, 0, sizeof(saddr_in.sin_zero));
	
	if (getusername(username, 256) == 0)
	{
		// Handle error
		return;
	}
	
	server = socket(AF_INET, SOCK_STREAM, 0);
	if (server < 0)
	{
		// Handle error
		return;
	}
	
	if (bind(server, (sockaddr *)&saddr_in, sizeof(saddr_in)) < 0)
	{
		// Handle error
		closesocket(server);
	}
	
	// We should be bound at this point
	// Listen on the socket
	if (listen(server, 5) < 0)
	{
		// Handle error
		closesocket(server);
	}
	
	while(running)
	{
		// We should be listening now...
		if ((client = accept(server, (sockaddr *)&c_addr, &c_size)) < 0)
		{
			// Handle error
			closesocket(server);
			return;
		}
	
		ident = (ident_data *)malloc(sizeof(ident_data));
		
		if (ident == NULL)
		{
			closesocket(client);
			closesocket(server);
			return;
		}
		
		ident->client = client;
		ident->log_file = file;
		ident->username = username;
		
		ident_t = spawn_thread((thread_entry)_ident_thread, "identd processor thread", B_LOW_PRIORITY, ident);
		resume_thread(ident_t);
	}
	
	printf("Closing everything...\n");
	
	closesocket(server);
	fclose(file);
}

long _ident_thread(ident_data *data)
{
	int				data_len;
	char			in_data[1024];
	
	char			out_data[1024];
	
	// Get the data
	data_len = recv(data->client, in_data, 1024, 0);
	
	// Tack on our return
	in_data[strlen(in_data) - 2] = '\0';
	strcpy(out_data, strtok(in_data, "\r"));
	strcat(out_data, " : USERID : BEOS : ");
	strcat(out_data, data->username);
	strcat(out_data, "\r\n");
	
	print_to_log(data->log_file, out_data);
	
	// Send the data back out
	send(data->client, out_data, strlen(out_data), 0);
	
	// Get rid of the socket
	closesocket(data->client);
	
	return 0;
}

void print_to_log(FILE *file, char *data)
{
	if (file != NULL)
	{
		fprintf(file, "%s", data);
		fflush(file);
	}
}
