*** gdevpng.c.orig	Sun Jun  1 15:11:40 1997
--- gdevpng.c	Sun Jun  1 15:30:24 1997
***************
*** 122,155 ****
  	if ( row == 0 )			/* can't allocate row buffer */
  	  return_error(gs_error_VMerror);
  
! 	/* allocate the necessary structures */
! 	png_ptr = gs_malloc(sizeof (png_struct), 1, "png structure");
! 	if (!png_ptr)
! 	  return_error(gs_error_VMerror);
! 
! 	info_ptr = gs_malloc(sizeof (png_info), 1, "png info_ptr");
! 	if (!info_ptr)
! 	  {
  		gs_free((char *)row, raster, 1, "png raster buffer");
- 		gs_free((char *)png_ptr, sizeof (png_struct), 1, "png structure");
  		return_error(gs_error_VMerror);
! 	  }
  
  	/* set error handling */
  	if (setjmp(png_ptr->jmpbuf))
  	{
- 		png_write_destroy(png_ptr);
  		gs_free((char *)row, raster, 1, "png raster buffer");
! 		gs_free((char *)png_ptr, sizeof (png_struct), 1, "png structure");
! 		gs_free((char *)info_ptr, sizeof (png_info), 1, "png info_ptr");
  		/* If we get here, we had a problem reading the file */
  		return_error(gs_error_VMerror);
  	}
  
- 	/* initialize the structures */
- 	png_info_init(info_ptr);
- 	png_write_init(png_ptr);
- 
  	/* set up the output control */
  	png_init_io(png_ptr, file);
  
--- 122,151 ----
  	if ( row == 0 )			/* can't allocate row buffer */
  	  return_error(gs_error_VMerror);
  
! 	/* allocate and initialize the structures */
! 	png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING,
! 									  NULL, NULL, NULL);
! 	if (!png_ptr) {
  		gs_free((char *)row, raster, 1, "png raster buffer");
  		return_error(gs_error_VMerror);
! 	}
! 
! 	info_ptr = png_create_info_struct(png_ptr);
! 	if (!info_ptr) {
! 		gs_free((char *)row, raster, 1, "png raster buffer");
! 		png_destroy_write_struct(&png_ptr, (png_infopp)NULL);
! 		return_error(gs_error_VMerror);
! 	}
  
  	/* set error handling */
  	if (setjmp(png_ptr->jmpbuf))
  	{
  		gs_free((char *)row, raster, 1, "png raster buffer");
! 		png_destroy_write_struct(&png_ptr, &info_ptr);
  		/* If we get here, we had a problem reading the file */
  		return_error(gs_error_VMerror);
  	}
  
  	/* set up the output control */
  	png_init_io(png_ptr, file);
  
***************
*** 223,239 ****
  	/* write the rest of the file */
  	png_write_end(png_ptr, info_ptr);
  
- 	/* clean up after the write, and free any memory allocated */
- 	png_write_destroy(png_ptr);
- 
  	/* if you malloced the palette, free it here */
  	if (info_ptr->palette)
  	     gs_free(info_ptr->palette, 256 * sizeof (png_color), 1, "png palette");
  
  	/* free the structures */
  	gs_free((char *)row, raster, 1, "png raster buffer");
! 	gs_free((char *)png_ptr, sizeof (png_struct), 1, "png structure");
! 	gs_free((char *)info_ptr, sizeof (png_info), 1, "png info_ptr");
  
  	return code;
  }
--- 219,231 ----
  	/* write the rest of the file */
  	png_write_end(png_ptr, info_ptr);
  
  	/* if you malloced the palette, free it here */
  	if (info_ptr->palette)
  	     gs_free(info_ptr->palette, 256 * sizeof (png_color), 1, "png palette");
  
  	/* free the structures */
  	gs_free((char *)row, raster, 1, "png raster buffer");
! 	png_destroy_write_struct(&png_ptr, &info_ptr);
  
  	return code;
  }
