/* Copyright (C) 1997, Jake Hamby.  All rights reserved.

  This file is part of Aladdin Ghostscript.

  Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
  License (the "License") for full details.

  Every copy of Aladdin Ghostscript must include a copy of the License,
  normally in a plain ASCII text file named PUBLIC.  The License grants you
  the right to copy, modify and redistribute Aladdin Ghostscript, but only
  under certain conditions described in the License.  Among other things, the
  License requires that the copyright notice and this notice be preserved on
  all copies.
*/

/* gsfront.cpp */
/* Shared library front-end to Ghostscript.  Simulates traditional "gs" */
/* executable, but opens a window for the native BeBox GUI driver */

#include <stdio.h>
#include <string.h>
#include <Application.h>
#include <ScrollView.h>
#include <MenuItem.h>
#include <Alert.h>
#include "PSView.h"
typedef PSView * HWND;		// Windows throwback
extern "C" {
#include "gsdll.h"
}

// Private message types
#define SHOW_FILE_PANEL	'SPNL'
#define NEXT_PAGE		'NXPG'

class PSWindow : public BWindow {
public:
	PSWindow(BRect frame, const char *title, window_type type, ulong flags, BView *scrview);
	bool QuitRequested();
};

PSWindow::PSWindow(BRect frame, const char *title, window_type type,
			ulong flags, BView *scrview) : BWindow(frame, title, type, flags)
{
	// SetDiscipline(false);	// Speed up drawing
	Lock();
	AddChild(scrview);
	Unlock();
}

bool PSWindow::QuitRequested() {
	be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
}

class PSApplication : public BApplication {
public:
    PSApplication(ulong sig);
    void AboutRequested();
//    void ArgvReceived(int argc, char **argv);
    void MessageReceived(BMessage *message);
    bool QuitRequested();
    void RefsReceived(BMessage *message);

    PSWindow *mywind;
	PSView *psview;
	BScrollView *myscrollview;
	thread_id my_thread;
};

// Only used to open and close BWindow
int
gsdll_callback(int message, char *str, unsigned long count)
{
	static bool child_added = 0;
    char *p;
    switch (message) {
    case GSDLL_STDIN:
        p = fgets(str, count, stdin);
        if (p)
             return strlen(str);
        else
             return 0; 
    case GSDLL_STDOUT:
        if (str != (char *)NULL)
            fwrite(str, 1, count, stderr);
        return count;
    case GSDLL_DEVICE:
		fprintf(stderr, "GSDLL_DEVICE called\n");
		if (count && !child_added) {	// open window
			child_added = 1;
			PSApplication *my_app = static_cast<PSApplication *>(be_app);
			my_app->mywind->Lock();
			my_app->mywind->Show();
			my_app->mywind->Unlock();
		} else {	// close window
			// do nothing right now
		}
		break;
    case GSDLL_SYNC:
        fprintf(stderr,"Callback: SYNC %p\n", str);
        break;
    case GSDLL_PAGE:
        fprintf(stderr,"Callback: PAGE %p\n", str);
        break;
    case GSDLL_SIZE:
        fprintf(stderr,"Callback: SIZE %p width=%d height=%d\n", str,
            (int)(count & 0xffff), (int)((count>>16) & 0xffff) );
        break;
    case GSDLL_POLL:
        return 0; /* no error */
    default:
        fprintf(stderr,"Callback: Unknown message=%d\n",message);
        break;
    }
            return 0;
}

char buf[256];

int myargc;
char **myargv;

int main(int argc, char *argv[]) {
	myargc = argc;
	myargv = argv;
    PSApplication myapp('GHST');
    myapp.Run();
    return 0;
}

long gsloop(void *foo);

PSApplication::PSApplication(ulong sig) : BApplication(sig) {
	screen_info myscreen;
    get_screen_info(&myscreen);
	BRect frame(205, 10, myscreen.frame.right, myscreen.frame.bottom);
	frame.OffsetTo(B_ORIGIN);
	psview = new PSView(BRect(0, 0, myscreen.frame.right-206-B_V_SCROLL_BAR_WIDTH,
							myscreen.frame.bottom-11-B_H_SCROLL_BAR_HEIGHT));
	myscrollview = new BScrollView("Scroll View", psview, B_FOLLOW_ALL,
			0, true, true, B_FANCY_BORDER);
	myscrollview->ScrollBar(B_HORIZONTAL)->SetRange(0, 611);
	myscrollview->ScrollBar(B_VERTICAL)->SetRange(0, 791);
    mywind = new PSWindow(frame, "Main Ghostscript Window", B_DOCUMENT_WINDOW, 0,
		myscrollview);
	mywind->Run();

//	BPopUpMenu *menu = new BPopUpMenu("File", false, false);
//    BMenuItem *item = new BMenuItem("About Ghostscript...", new BMessage(B_ABOUT_REQUESTED));
//    menu->AddItem(item);
//   menu->AddSeparatorItem();

// These don't work yet, so comment them out to avoid confusing users
//    item = new BMenuItem("Open...", new BMessage(SHOW_FILE_PANEL), 'O');
//    menu->AddItem(item);
//    menu->AddSeparatorItem();
//	item = new BMenuItem("Next Page", new BMessage(NEXT_PAGE), 'N');
//	menu->AddItem(item);
//	menu->AddSeparatorItem();

//    item = new BMenuItem("Quit", new BMessage(B_QUIT_REQUESTED), 'Q');
//    menu->AddItem(item);

//    SetMainMenu(menu);

	my_thread = spawn_thread(gsloop, "GS Loop", B_NORMAL_PRIORITY, (void *)psview);
	resume_thread(my_thread);
}

long gsloop(void *psview)
{
    int code;
    code = gsdll_init(gsdll_callback, (PSView *)psview, myargc, myargv);
    fprintf(stderr, "gsdll_init returns %d\n", code);
    code = gsdll_execute_begin();
    if (code==0) {
		fprintf(stderr, "GS>");
		fflush(stderr);
		while(fgets(buf, sizeof(buf), stdin)) {
			code = gsdll_execute_cont(buf, strlen(buf));
			fprintf(stderr, "gsdll_execute returns %d\n", code);
			if (code < 0)
		    	break;
			fprintf(stderr, "GS>");
			fflush(stderr);
		}
		if (!code)
			code = gsdll_execute_end();
		code = gsdll_exit();
		fprintf(stderr, "gsdll_exit returns %d\n", code);
    }

	be_app->PostMessage(B_QUIT_REQUESTED);
    return 0;
}

void PSApplication::AboutRequested() {
   BAlert *alert;

   alert = new BAlert("", "Ghostscript DR8\nCopyright 1996 Aladdin Enterprises.\n\
BeOS port by Jake Hamby.\nPlease send all comments to:\n    jehamby@lightside.com",
                      "OK", NULL, NULL, B_WIDTH_AS_USUAL, B_INFO_ALERT);
   alert->Go();
}

void PSApplication::MessageReceived(BMessage *message) {
        switch (message->what) {
        case SHOW_FILE_PANEL:
//                RunFilePanel();         // Use default values
		fprintf(stderr, "Open file...\n");
                break;
        case NEXT_PAGE:
                fprintf(stderr, "Next page...\n");
                break;
        default:
                BApplication::MessageReceived(message);
                break;
        }
}

bool PSApplication::QuitRequested() {
	kill_thread(my_thread);	// Kill Ghostscript thread if still running
	return true;			// and exit app
}

void PSApplication::RefsReceived(BMessage *message) {
/*        ulong type;
        long count;

        message->GetInfo("refs", &type, &count);
        for(long i=--count; i>=0; i--) {
                record_ref *item = new record_ref;
                *item = message->FindRef("refs", i);
                if (does_ref_conform(*item, "File")) {
                        // reflist->AddItem(item);
					fprintf(stderr, "File dropped!\n");
                }
        }
*/
}
