/* Ghostscript BeBox GUI headers.
 * Right now this mostly contains dummy entries.
 *
 * Copyright 1996, Jake Hamby
 * Send all comments, bug fixes, etc. to:  jehamby@lightside.com
 */

typedef enum redraw_cmd {
	cmd_fill_rectangle,
	cmd_draw_line,
	cmd_copy_mono,
	cmd_copy_color,
	cmd_strip_tile_rectangle
};

/* Define struct to store Draw commands for redraw */
typedef struct be_redraw_s {
	struct be_redraw_s *next;
	redraw_cmd cmd;
	int x, y, w, h;
	gx_color_index zero, one;
	int sourcex, raster;
	gx_bitmap_id id;
};

/* typedef struct bmapcache_s {
	gx_bitmap_id id;
	void *bitmap;		// Actually a BBitmap ptr
	struct bmapcache_s *next;
};
*/

struct bmapcache_s;   /* Contains a BBitmap, so can't define from C */

/* Define the BeBox device */
typedef struct gx_device_be_s {
	gx_device_common;
	bool islocked;		/* Has the BWindow been locked */
	bool redrawing;		/* Are we currently refreshing the screen */
	struct bmapcache_s *bmapcache, **bmapcache_current;
	be_redraw_s *be_redraw_queue, **be_redraw_current_ptr;
} gx_device_be;

/* Default dots-per-inch (be sure to choose an even number!) */
#define FAKE_RES (76)
