/* Here is where the Ghostscript BeBox GUI driver will go.
 * Right now it contains dummy entries for everything.
 *
 * Copyright 1996, Jake Hamby
 * Send all comments, bug fixes, etc. to:  jehamby@lightside.com
 */

extern "C" int gsdll_lock_device(unsigned char *device, int flag);
int gsdll_lock_device(unsigned char *device, int flag) {
    // This will be a mutex to make the GS shared lib threadsafe
    return 0;
}

#include "PSView.h"
typedef PSView * HWND;		/* For old DLL interface */
HWND hwndtext;				/* Pointer to our PSView */

extern "C" {
#define __PROTOTYPES__		/* C++ needs prototypes, of course */
#include "gx.h"			/* for gx_bitmap; includes std.h */
#include "math_.h"
#include "memory_.h"
#include "gserrors.h"
#include "gsparam.h"
#include "gxdevice.h"
#include "gdevbe.h"
#include "gsdll.h"
}

/* Procedures */

private dev_proc_open_device(be_open);
private dev_proc_sync_output(be_sync);
private dev_proc_close_device(be_close);
private dev_proc_map_rgb_color(be_map_rgb_color);
private dev_proc_map_color_rgb(be_map_color_rgb);
private dev_proc_fill_rectangle(be_fill_rectangle);
private dev_proc_copy_mono(be_copy_mono);
private dev_proc_copy_color(be_copy_color);
private dev_proc_draw_line(be_draw_line);
private dev_proc_strip_tile_rectangle(be_strip_tile_rectangle);
private dev_proc_get_initial_matrix(be_get_initial_matrix);
private dev_proc_get_bits(be_get_bits);
private dev_proc_get_page_device(be_get_page_device);

/* The device descriptor */
private gx_device_procs be_procs = {
	be_open,
	gx_default_get_initial_matrix,
	be_sync,
	NULL,			/* output_page */
	be_close,
	be_map_rgb_color,
	be_map_color_rgb,
	be_fill_rectangle,
	NULL,			/* tile_rectangle */
	be_copy_mono,
	NULL,			/* copy_color */
	be_draw_line,
	NULL,			/* get_bits */
	NULL,			/* get_params */
	NULL,			/* put_params */
	NULL,			/* map_cmyk_color */
	NULL,			/* get_xfont_procs */
	NULL,			/* get_xfont_device */
	NULL,			/* map_rgb_alpha_color */
	gx_page_device_get_page_device,
	NULL,			/* get_alpha_bits */
	NULL,			/* copy_alpha */
	NULL,			/* get_band */
	NULL,			/* copy_rop */
	NULL,			/* fill_path */
	NULL,			/* stroke_path */
	NULL,			/* fill_mask */
	NULL,			/* fill_trapezoid */
	NULL,			/* fill_parallelogram */
	NULL,			/* fill_triangle */
	NULL,			/* draw_thin_line */
	NULL,			/* begin_image */
	NULL,			/* image_data */
	NULL,			/* end_image */
	NULL			/* be_strip_tile_rectangle */
};

/* The instance is public. */
gx_device_be gs_bebox_device = {
	std_device_color_body(gx_device_be, &be_procs, "bebox",
	  FAKE_RES*85/10, FAKE_RES*11,	/* x and y extent (nominal) */
	  FAKE_RES, FAKE_RES,	/* x and y density (nominal) */
	  /*dci_color(*/24, 255, 256/*)*/),
	{ 0 },			/* std_procs */
	false,			/* islocked */
	false,			/* redrawing */
	NULL,			/* bmapcache ptr */
	0,				/* next bitmap to use */
	NULL,			/* first item in redraw queue */
	NULL			/* where to place next redraw item ptr */
};

/* The BBitmap cache struct */
struct bmapcache_s {
	gx_bitmap_id id;
	struct bmapcache_s *next;
	BBitmap bitmap;
	
	bmapcache_s(gx_bitmap_id id, BRect bounds, color_space mode) :
		id(id), bitmap(bounds, mode), next(NULL) { }
};

/* Open the device. */
private int
be_open(gx_device *dev)
{
	// signal gsfront to open the window
	(*pgsdll_callback)(GSDLL_DEVICE, NULL, 1);

    gx_device_be *bdev = (gx_device_be *)dev;
	if(!hwndtext)
		return_error(gs_error_ioerror);
	bdev->be_redraw_current_ptr = &(bdev->be_redraw_queue);
	bdev->bmapcache_current = &(bdev->bmapcache);
	hwndtext->bdevice = (void *)dev;
	hwndtext->Window()->Lock();
	bdev->islocked = true;
    return 0;
}

/* Close the device. */
private int
be_close(gx_device *dev)
{
    gx_device_be *bdev = (gx_device_be *)dev;
	be_redraw_s *current = bdev->be_redraw_queue;
	while(current) {
		be_redraw_s *next = current->next;
		delete current;
		current = next;
	}
	bmapcache_s *cur2 = bdev->bmapcache;
	while(cur2) {
		bmapcache_s *next = cur2->next;
		delete cur2;
		cur2 = next;
	}
	if(bdev->islocked) {
		hwndtext->Window()->Unlock();
	}
	// signal gsfront to close the window (not currently used)
	(*pgsdll_callback)(GSDLL_DEVICE, NULL, 0);
    return 0;
}

/* Map a color.  The "device colors" are rgb_color structs. */
private gx_color_index
be_map_rgb_color(register gx_device *dev,
		gx_color_value r, gx_color_value g, gx_color_value b)
{
    gx_device_be *bdev = (gx_device_be *)dev;
    union {
		rgb_color r;
		gx_color_index g;
	} colorcast;
	colorcast.r.red = r >> 8;
	colorcast.r.green = g >> 8;
	colorcast.r.blue = b >> 8;
	colorcast.r.alpha = 0;
	return colorcast.g;
}


/* Map a "device color" back to r-g-b. */
/* Foreground and background may be mapped to other colors, so */
/* they are handled specially. */
private int
be_map_color_rgb(register gx_device *dev, gx_color_index color,
		gx_color_value prgb[3])
{
    gx_device_be *bdev = (gx_device_be *)dev;
    union {
		rgb_color r;
		gx_color_index g;
	} colorcast;
	colorcast.g = color;
	prgb[0] = colorcast.r.red << 8;
	prgb[1] = colorcast.r.green << 8;
	prgb[2] = colorcast.r.blue << 8;
	return 0;
}

/* Synchronize the display with the commands already given */
private int
be_sync(register gx_device *dev)
{
    gx_device_be *bdev = (gx_device_be *)dev;
	if(!bdev->islocked)
		hwndtext->Window()->Lock();
	hwndtext->Sync();	// Update the screen
	hwndtext->Window()->Unlock();
	bdev->islocked = false;
    return 0;
}

/* Fill a rectangle with a color. */
private int
be_fill_rectangle(register gx_device *dev,
		 int x, int y, int w, int h, gx_color_index color)
{
    gx_device_be *bdev = (gx_device_be *)dev;
	union {
		rgb_color r;
		gx_color_index g;
	} colorcast;
	if(!bdev->islocked) {
		hwndtext->Window()->Lock();
		bdev->islocked = true;
	}
	colorcast.g = color;
	hwndtext->SetHighColor(colorcast.r);
	hwndtext->FillRect(BRect(x, y, w+x-1, y+h-1));
	if(!bdev->redrawing) {
		if(x==0 && y==0 && w==bdev->width && h==bdev->height) {
			/* Just cleared the screen so clear the redraw queue */
			be_redraw_s *current = bdev->be_redraw_queue;
			while(current) {
				be_redraw_s *next = current->next;
				delete current;
				current = next;
			}
			bdev->be_redraw_queue = NULL;
			bdev->be_redraw_current_ptr = &(bdev->be_redraw_queue);
			/* Also clear the bitmap cache */
			bmapcache_s *cur2 = bdev->bmapcache;
			while(cur2) {
				bmapcache_s *next = cur2->next;
				delete cur2;
				cur2 = next;
			}
			bdev->bmapcache = NULL;
			bdev->bmapcache_current = &(bdev->bmapcache);
		}
		be_redraw_s *drawrect = new be_redraw_s;
		drawrect->next = NULL;
		drawrect->cmd = cmd_fill_rectangle;
		drawrect->x = x;
		drawrect->y = y;
		drawrect->w = w;
		drawrect->h = h;
		drawrect->zero = color;
		*(bdev->be_redraw_current_ptr) = drawrect;
		bdev->be_redraw_current_ptr = &(drawrect->next);
	}
	return 0;
}

/* Copy a monochrome bitmap. */
private int
be_copy_mono(register gx_device *dev,
	    const byte *base, int sourcex, int raster, gx_bitmap_id id,
	    int x, int y, int w, int h,
	    gx_color_index zero, gx_color_index one)
{
    gx_device_be *bdev = (gx_device_be *)dev;
    if(raster) {
	union {
		rgb_color r;
		gx_color_index g;
	} colorcast;
	if(!bdev->islocked) {
		hwndtext->Window()->Lock();
		bdev->islocked = true;
	}
	colorcast.g = one;
	hwndtext->SetHighColor(colorcast.r);
	if(zero == gx_no_color_index)
		hwndtext->SetDrawingMode(B_OP_OVER);
	else {
		colorcast.g = zero;
		hwndtext->SetLowColor(colorcast.r);
		hwndtext->SetDrawingMode(B_OP_COPY);
	}

	bool found=false;
	BBitmap *bitmap;
	bmapcache_s *current = bdev->bmapcache;
	while(current) {
	    if(current->id == id) {
	    	bitmap = &(current->bitmap);
			found=true;
			break;
	    }
		current = current->next;
	}
	if(!found) {
		bmapcache_s *bmapc = new bmapcache_s(id, BRect(0.0, 0.0, (raster << 3) - 1, h-1), B_MONOCHROME_1_BIT);
	    bmapc->bitmap.SetBits(base, raster * h, 0, B_MONOCHROME_1_BIT);
		*(bdev->bmapcache_current) = bmapc;
		bdev->bmapcache_current = &(bmapc->next);
		bitmap = &(bmapc->bitmap);
	}
	hwndtext->DrawBitmapAsync(bitmap, BRect(sourcex, 0, sourcex+w-1, h-1), BRect(x, y, x+w-1, y+h-1));
	if(!bdev->redrawing) {
		be_redraw_s *drawmono = new be_redraw_s;
		drawmono->next = NULL;
		drawmono->cmd = cmd_copy_mono;
		drawmono->x = x;
		drawmono->y = y;
		drawmono->w = w;
		drawmono->h = h;
		drawmono->zero = zero;
		drawmono->one = one;
		drawmono->sourcex = sourcex;
		drawmono->raster = raster;
		drawmono->id = id;
		*(bdev->be_redraw_current_ptr) = drawmono;
		bdev->be_redraw_current_ptr = &(drawmono->next);
	}
    }
    return 0;
}

/* Copy a color bitmap. */
/* Note:  I couldn't find any PS file which uses this function, so I left
 * it unimplemented for now.  -jeh
 */
private int
be_copy_color(register gx_device *dev,
	     const byte *base, int sourcex, int raster, gx_bitmap_id id,
	     int x, int y, int w, int h)
{
    gx_device_be *bdev = (gx_device_be *)dev;
    return 0;
}

/* Draw a line */
private int
be_draw_line(register gx_device *dev,
  	     int x0, int y0, int x1, int y1, gx_color_index color)
{
    gx_device_be *bdev = (gx_device_be *)dev;
	union {
		rgb_color r;
		gx_color_index g;
	} colorcast;
	if(!bdev->islocked) {
		hwndtext->Window()->Lock();
		bdev->islocked = true;
	}
	colorcast.g = color;
	hwndtext->SetHighColor(colorcast.r);
	hwndtext->StrokeLine(BPoint(x0, y0), BPoint(x1, y1));
	if(!bdev->redrawing) {
		be_redraw_s *drawline = new be_redraw_s;
		drawline->next = NULL;
		drawline->cmd = cmd_draw_line;
		drawline->x = x0;
		drawline->y = y0;
		drawline->w = x1;
		drawline->h = y1;
		drawline->zero = color;
		*(bdev->be_redraw_current_ptr) = drawline;
		bdev->be_redraw_current_ptr = &(drawline->next);
	}
    return 0;
}

/* Tile a rectangle. */
/* Note:  Because the Be GUI always has at least 256 colors, and because
 *   this function is only used for halftoning, I left it unimplemented for
 *   now.  -jeh
 */
private int
be_strip_tile_rectangle(register gx_device *dev, const gx_strip_bitmap *tiles,
		       int x, int y, int w, int h,
		       gx_color_index zero, gx_color_index one,
		       int px, int py)
{
    gx_device_be *bdev = (gx_device_be *)dev;
    fprintf(stderr, "Striptile rectangle\n");
    return 0;
}

/* PSView constructor */
PSView::PSView(BRect area) :
                BView(area, "View", B_FOLLOW_ALL, B_WILL_DRAW)
{
    bdevice = NULL;
}

/* Replay drawing instructions when window needs refreshing */
void PSView::Draw(BRect area) {
	if(bdevice) {
		gx_device_be bdev = *(gx_device_be *)bdevice;	// make a copy
		this->Window()->Lock();
		bdev.islocked = bdev.redrawing = true;
		be_redraw_s *current = bdev.be_redraw_queue;
		while(current) {
			if((current->cmd == cmd_draw_line) ||
					area.Intersects(BRect(current->x, current->y,
								current->w + current->x - 1,
								current->h + current->y - 1))) {
				switch(current->cmd) {
				case cmd_fill_rectangle:
					be_fill_rectangle((gx_device_s *)&bdev, current->x,
						current->y, current->w, current->h, current->zero);
					break;
				case cmd_copy_mono:
					be_copy_mono((gx_device_s *)&bdev, NULL,
						current->sourcex, current->raster, current->id,
						current->x, current->y, current->w, current->h,
						current->zero, current->one);
					break;
				case cmd_draw_line:
					be_draw_line((gx_device_s *)&bdev, current->x,
						current->y, current->w, current->h, current->zero);
					break;
				case cmd_copy_color:
					break;
				case cmd_strip_tile_rectangle:
					break;
				}
			}
			current = current->next;
		}
		this->Window()->Unlock();
	}
}
