//
// STATIC, the software TV tuner.
// Copyright 1997 Marco Nelissen
//

#include "static.h"

typedef struct space
{
	char *name;
	long spec;
};

typedef struct prefstruct
{
	long currentspec;
	bool color;
	bool sound;
};

prefstruct *mypref;

space spaces[]=
{
	"640x480",  B_8_BIT_640x480,
	"800x600",  B_8_BIT_800x600,
	"1024x768", B_8_BIT_1024x768,
	"1152x900", B_8_BIT_1152x900,
	"1280x1024",B_8_BIT_1280x1024,
	"1600x1200",B_8_BIT_1600x1200
};

unsigned long idum=0;

inline unsigned long lrand()
{
	// quick and dirty linear congruential random number generator
	idum=1664525L*idum+1013904223L;
	
	// this is a touch of my own, needed to prevent visible patterns in the static
	if(idum&0x00800200)
		idum=1664525L*idum+1013904223L;
	return idum;
}

// things I need for the prefs
BPopUpMenu *popup=NULL;
BCheckBox *colcheck=NULL;
BCheckBox *audcheck=NULL;
BAudioSubscriber *audsub=NULL;

// used for color-cycling in color mode
long rc=0;
long gc=170;
long bc=170;
long ri=1;
long gi=1;
long bi=-1;

CstaticThread	*gstatic = NULL;

void module_initialize(void *inSettings, long inSettingsSize)
{

	if(inSettingsSize&&inSettings)
	{
		mypref=(prefstruct*)inSettings;
	}
	else
	{
		mypref=(prefstruct*)malloc(sizeof(prefstruct));
		mypref->currentspec=B_8_BIT_640x480;
		mypref->color=false;
		mypref->sound=false;
	}
}

void module_cleanup(void **outSettings, long *outSettingsSize)
{
	*outSettings = mypref;
	*outSettingsSize = sizeof(prefstruct);
}


void module_start_saving(BView	*inView)
{
	gstatic=new CstaticThread(20000.0);
	gstatic->StartSaving(inView);	
}


void module_stop_saving()
{
	gstatic->StopSaving();
	delete (gstatic);
	gstatic = NULL;
}


void module_start_config(BView *inView)
{
	BRect frame;
	BMenuItem *item;
	screen_info info;

	if (!inView->Window()->Lock())
		return;
		
	frame = inView->Bounds();
	frame.top += 10.0;
	frame.left += 20.0;
	frame.bottom = frame.top + 32.0;
	BStringView *view = new BStringView(frame, B_EMPTY_STRING, "STATIC");
	inView->AddChild(view);
	view->SetViewColor(inView->ViewColor());
	view->SetFontName("Times New Roman");
	view->SetFontSize(24);
	
	frame = inView->Bounds();
	frame.top += 40.0;
	frame.bottom = frame.top + 24.0;
	frame.left += 24.0;
	frame.right -= 30.0;
	BRect textArea = frame;
	textArea.OffsetTo(B_ORIGIN);
	BTextView *caption = new BTextView(frame, B_EMPTY_STRING, textArea,
						   			   B_FOLLOW_ALL, B_WILL_DRAW);
	caption->SetText("the software TV-tuner.\n" 
					 "by Marco Nelissen <marcone@xs4all.nl>");	
	inView->AddChild(caption);
	caption->SetViewColor(inView->ViewColor());
	caption->SetDrawingMode(B_OP_OVER);
	caption->SetFontName("Erich");
	caption->MakeEditable(FALSE);
	caption->MakeSelectable(FALSE);
	caption->SetWordWrap(TRUE);
	
	get_screen_info(&info);
	popup=new BPopUpMenu("<select>");
	for(int i=0;i<6;i++)
	{
		if(info.spaces&spaces[i].spec)
		{
			popup->AddItem(item=new BMenuItem(spaces[i].name,new BMessage()));
			if(spaces[i].spec== mypref->currentspec)
				item->SetMarked(true);
		}
	}
	inView->AddChild(new BMenuField(BRect(20,90,150,110), "", "resolution:",popup));

	colcheck=new BCheckBox(BRect(20,120,70,130),"","color",new BMessage());
	if(mypref->color)
		colcheck->SetValue(1);
	inView->AddChild(colcheck);

	audcheck=new BCheckBox(BRect(20,135,70,145),"","sound",new BMessage());
	if(mypref->sound)
		audcheck->SetValue(1);
	inView->AddChild(audcheck);

	inView->Window()->UpdateIfNeeded();
	inView->Window()->Unlock();
}


void module_stop_config()
{
	if(popup)
	{
		BMenuItem *item;

		item=popup->FindMarked();
		if(item)
			mypref->currentspec=spaces[popup->IndexOf(item)].spec;
		popup=NULL;
		mypref->color=colcheck->Value();
		colcheck=NULL;
		mypref->sound=audcheck->Value();
		audcheck=NULL;
	}
}


// audio subscriber used to generate noise
bool _process_sound(void *arg, char *buf, long count);
bool _process_sound(void *arg, char *buf, long count)
{
	while(--count > 0)
		*buf++=lrand()&0x07;  // should give good results for all audio-modes

	// Note that this subscriber doesn't mix. 
	// But that's OK. After all: it's a blanker ;)

	return true;
}

CstaticThread::CstaticThread(double	sleep)
	: CSaveThread()
{
	mSleep=sleep;	
}


void CstaticThread::StartSaving(BView	*view)
{
	if (!view->Window()->Lock())
		return;
		
	if(popup)
	{
		BMenuItem *item;

		item=popup->FindMarked();
		if(item)
			mypref->currentspec=spaces[popup->IndexOf(item)].spec;
		mypref->color=colcheck->Value();
		mypref->sound=audcheck->Value();
	}

	// create a BWindowScreen of the desired resolution
	winscreen=new mywin("static",mypref->currentspec);
	if(!(winscreen->Error()==B_NO_ERROR))
	{
		winscreen=NULL;
		return;
	}
	view->Window()->Unlock();
	CSaveThread::StartSaving(view);	
}

	
void CstaticThread::StopSaving()
{
	CSaveThread::StopSaving();
	if(winscreen)
	{
		winscreen->Quit();
		winscreen=NULL;
		mView->Window()->Show();
		mView->Window()->Activate(true);
	}
}

	
double CstaticThread::Save()
{
	// post a refresh message to the BWindowScreen
	if(winscreen)
		winscreen->PostMessage('noiz');
	return (mSleep);
}


mywin::mywin(char *name, ulong space)
	: BWindowScreen(name,space)
{
	palette=new rgb_color[256];
}


void mywin::MessageReceived(BMessage *mes)
{
	if(drawing_allowed && mes->what == 'noiz')
	{
		randompalette();
	}
	else
		inherited::MessageReceived(mes);

}

void mywin::ScreenConnected(bool allow)
{
	if(drawing_allowed=allow)
	{
		// clear palette so we don't see the screen being filled
		long *longpal=(long*)palette;

		for(int i=0;i<256;i++)
			*longpal++ = 0;
		SetColorList(palette,1);

		// fill buffer with random data, making sure we don't use color 0
		unsigned long *buf;
		long buflen;

		buf=(unsigned long*)CardInfo()->frame_buffer;
		buflen=CardInfo()->width*CardInfo()->height/4;
		for(int i=0;i<buflen;i++)
		{
			unsigned long val;
			
			val=lrand();
			if((val&0xff000000)==0) val|=0x01000000;
			if((val&0x00ff0000)==0) val|=0x00010000;
			if((val&0x0000ff00)==0) val|=0x00000100;
			if((val&0x000000ff)==0) val|=0x00000001;
			buf[i]=val;
		}
		// if sound was asked for, create an audiosubscriber
		if(!audsub && mypref->sound)
		{
			audsub=new BAudioSubscriber("BASE-subscriber");
			audsub->Subscribe(B_DAC_STREAM,B_INVISIBLE_SUBSCRIBER_ID,FALSE);
			audsub->EnterStream(NULL,FALSE, /* neighbor, before */
							audsub,
							_process_sound,
							NULL,
							TRUE /* run as seperate thread */
						 );
		}
	}
	else if(audsub)
	{
		audsub->ExitStream(true);	// wait for it
		delete audsub;
		audsub=NULL;
	}
}


void mywin::randompalette()
{
	long *longpal=(long*)palette;

	if(mypref->color)
	{
		/* colored noise */
		for(int i=1;i<256;i++)
		{
			long r,g,b;
			r=(((lrand()&0xff)*rc)>>8)&0xff;
			g=(((lrand()&0xff)*gc)>>8)&0xff;
			b=(((lrand()&0xff)*bc)>>8)&0xff;
			if(lrand()&0x80010) r=g=b=0;
			*longpal++ = r<<24|g<<16|b<<8;
		}
		(rc+=ri);
		(gc+=gi);
		(bc+=bi);
		if((rc&=0xff)==0) ri= -ri;
		if((gc&=0xff)==0) gi= -gi;
		if((bc&=0xff)==0) bi= -bi;
	}
	else
	{
		for(int i=0;i<256;i++)
		{
			// monochrome noise
			unsigned long tmp=lrand();
			if(tmp&0x10000)  		// make sure we get lots of black ...
				*longpal++=0;
			else if (tmp&0x10000010)
				*longpal++=250;		// ... and a fair amount of white as well
			else
			{
				tmp&=0xc0;			// fill the rest with shades of grey
				*longpal++ = tmp<<24|tmp<<16|tmp<<8;
			}
		}
	}
	// load new palette, but don't use color 0
	SetColorList(palette,1);
}
