

#pragma once


#pragma export on


extern "C" {

extern void	module_initialize(void *inSettings, long inSettingsSize);
extern void	module_cleanup(void **outSettings, long *outSettingsSize);
extern void	module_start_saving(BView *inView);
extern void	module_stop_saving();
extern void module_start_config(BView *inView);
extern void module_stop_config();

}
#pragma export reset
#include "CSaveThread.h"


// taken from "rock.c"
#include <math.h>
#include <stdio.h>

#define RESOLUTION 1000
#define MIN_DEPTH 2		/* rocks disappear when they get this close */
#define MAX_DEPTH 60		/* this is where rocks appear */
#define MAX_WIDTH 100		/* how big (in pixels) rocks are at depth 1 */
#define DEPTH_SCALE 100		/* how many ticks there are between depths */
#define MAX_DEP 0.3             /* how far the displacement can be (percents)*/
#define DIRECTION_CHANGE_RATE 60 /* 0 is always */
#define MAX_DEP_SPEED 5         /* Maximum speed for movement */
#define MOVE_STYLE 0            /* Only 0 and 1. Distinguishes the fact that
				   these are the rocks that are moving (1) 
				   or the rocks source (0). */

/* there's not much point in the above being user-customizable, but those
   numbers might want to be tweaked for displays with an order of magnitude
   higher resolution or compute power.
 */

#define DOUBLE float

class arock
{
public:
// arock, adapted from xwindows' "rock.c"
  int real_size;
  int r;
  rgb_color color;
  int theta;
  int depth;
  int size, x, y;
};


class CrockThread : CSaveThread {
public:
					CrockThread(double sleep);
					
	virtual void	StartSaving(BView *view);
	virtual void	StopSaving();

protected:
	virtual double	Save();
			int		compute_move(int);
			void	rock_tick(arock *, int);
			void	rock_draw(arock *, bool);
			void	rock_compute(arock *);
			void	rock_reset(arock *);

protected:
	double	mSleep;
	
	long	batchcount;

// rockstruct, adapted from xwindows' "rock.c"
    int	width;
    int	height;
    int midx, midy;
    int rotate_p, speed, nrocks;
    int move_p;
    int dep_x, dep_y;
    DOUBLE cos_array[RESOLUTION], sin_array[RESOLUTION];
    DOUBLE depths[(MAX_DEPTH + 1) * DEPTH_SCALE];
    arock *arocks;

// from the "drawrock" function (were static variables)
    int current_delta;	/* observer Z rotation */
	int window_tick;
	int new_delta;
	int dchange_tick;

// from the "compute_move" function (were static variables)
	int current_dep[2];
	int cm_speed[2];
	short direction[2];
	int limit[2];
};

