/*
 * The 'rock' screensaver, taken from Linux OpenWindows, and adapted for
 * Hiroshi Lockheimer's screensaver by Marco Nelissen <marcone@xs4all.nl>
 *
 * Porting consisted mainly of moving static variables into classes, and
 * changing the indentation style.
 */

/*
 * Flying through an asteroid field.  Based on TI Explorer Lisp code by
 *  John Nguyen <johnn@hx.lcs.mit.edu>
 *
 * Copyright (c) 1992 by Jamie Zawinski
 *
 * 14-Apr-95: Jeremie PETIT <petit@aurora.unice.fr> added a "move" feature.
 * 2-Sep-93: xlock version (David Bagley bagleyd@source.asset.com)
 * 1992:     xscreensaver version (Jamie Zawinski jwz@lucid.com)
 */

/* original copyright
 * Copyright (c) 1992 by Jamie Zawinski
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 */

/*
 * Some parts 1996 Hiroshi Lockheimer
 */

#include "rock.h"


static void init_pixmaps(), tick_rocks();


const rgb_color	kBlack		= {0, 0, 0, 0};
const rgb_color	kWhite		= {255, 255, 255, 0};


CrockThread	*grock = NULL;
CrockThread	*gMinirock = NULL;


void
module_initialize(
	void	*inSettings,
	long 	inSettingsSize)
{
#pragma unused (inSettings, inSettingsSize)
}


void
module_cleanup(
	void	**outSettings,
	long	*outSettingsSize)
{
	*outSettings = NULL;
	*outSettingsSize = 0;
}


void
module_start_saving(
	BView	*inView)
{	
	srand((long)system_time());

	inView->Window()->Show();

	grock = new CrockThread(12500.0);
	grock->StartSaving(inView);	
}


void
module_stop_saving()
{
	grock->StopSaving();
	delete (grock);
	grock = NULL;
}


void
module_start_config(
	BView *inView)
{
	if (!inView->Window()->Lock())
		return;
		
	BRect frame;
	
	frame = inView->Bounds();
	frame.top += 10.0;
	frame.left += 10.0;
	frame.bottom = frame.top + 12.0;
	BStringView *view = new BStringView(frame, B_EMPTY_STRING, "rock, a starfield with a twist");
	inView->AddChild(view);
	view->SetViewColor(inView->ViewColor());
	view->SetFontName("Emily");
	
	frame = inView->Bounds();
	frame.top += 30.0;
	frame.bottom = frame.top + 44.0;
	frame.left += 20.0;
	frame.right -= 20.0;
	BRect textArea = frame;
	textArea.OffsetTo(B_ORIGIN);
	BTextView *caption = new BTextView(frame, B_EMPTY_STRING, textArea,
						   			   B_FOLLOW_ALL, B_WILL_DRAW);
	caption->SetText("a port of the 'rock' blanker, taken from Linux' OpenWindows\n" 
					 "by Marco Nelissen <marcone@xs4all.nl>");
	inView->AddChild(caption);
	caption->SetViewColor(inView->ViewColor());
	caption->SetDrawingMode(B_OP_OVER);
	caption->SetFontName("Erich");
	caption->MakeEditable(FALSE);
	caption->MakeSelectable(FALSE);
	caption->SetWordWrap(TRUE);	
	
	BRect previewFrame = inView->Bounds();
	previewFrame.top = frame.bottom + 10.0;
	previewFrame.left += 10.0;
	previewFrame.right -= 10.0;
	previewFrame.bottom -= 10.0;
	BView *preview = new BView(previewFrame, B_EMPTY_STRING, 
							   B_FOLLOW_ALL, B_WILL_DRAW);
	inView->AddChild(preview);		
	preview->SetViewColor(0,0,0);
	preview->SetLowColor(0,0,0);
	preview->Invalidate();
	
	inView->Window()->UpdateIfNeeded();
	
	inView->Window()->Unlock();
	
	gMinirock = new CrockThread(25000.0);
	gMinirock->StartSaving(preview);
}


void
module_stop_config()
{
	gMinirock->StopSaving();
	delete (gMinirock);
	gMinirock = NULL;
}




CrockThread::CrockThread(double	sleep)
	: CSaveThread()
{
	int i;

	mSleep = sleep;

	speed = 100;
	rotate_p = true;
	move_p = true;
	dep_x = 0;
	dep_y = 0;
	batchcount = 100;

	nrocks = batchcount;
	if (speed < 1) speed = 1;
	if (speed > 100) speed = 100;
	
	for (i = 0; i < RESOLUTION; i++)
	{
	    sin_array[i] = sin((((DOUBLE) i) / (RESOLUTION / 2)) * M_PI);
	    cos_array[i] = cos((((DOUBLE) i) / (RESOLUTION / 2)) * M_PI);
	}
	/* we actually only need i/speed of these, but wtf */
	for (i = 1; i < (sizeof(depths) / sizeof(depths[0])); i++)
		depths[i] = atan(((DOUBLE) 0.5) / (((DOUBLE) i) / DEPTH_SCALE));
	depths[0] = (PI/2); /* avoid division by 0 */
	
	if (!arocks)
	 	arocks = new arock[nrocks];
//	init_pixmaps(win);
}


void CrockThread::StartSaving(BView	*view)
{
	if (!view->Window()->Lock())
		return;

	BRect bounds=view->Bounds();
	width = bounds.IntegerWidth();
	height = bounds.IntegerHeight();
	midx = width/2;
	midy = height/2;

// inits from "drawrock" function
    current_delta = 0;	/* observer Z rotation */
	window_tick = 50;
	new_delta = 0;
	dchange_tick = 0;

// inits from "compute_move" function
//	current_dep = {0,0};
//	speed       = {0,0};
//	direction   = {0,0};
//	limit       = {0,0};

	view->Window()->Unlock();
	CSaveThread::StartSaving(view);	
}

	
void
CrockThread::StopSaving()
{
	CSaveThread::StopSaving();
}

	
double CrockThread::Save()
{
	if (mView->Window()->Lock())
	{
// 'drawrock' function
		if(window_tick++ == 50)
			window_tick = 0;
		if(current_delta != new_delta)
		{
			if(dchange_tick++ == 5)
			{
				dchange_tick = 0;
				if (current_delta < new_delta)
					current_delta++;
				else
					current_delta--;
			}
		}
		else
		{
			if ((rand() % 50) == 0)
			{
				new_delta = ((rand() % 11) - 5);
				if ((rand() % 10) == 0)
					new_delta *= 5;
			}
		}
		
	// "tick_rocks" function
		if(move_p)
		{
			dep_x = compute_move(0);
			dep_y = compute_move(1);
		}
		for(int i = 0; i < nrocks; i++)
			rock_tick(&arocks[i], current_delta);
			
		mView->Window()->Unlock();
	}
	return (mSleep);
}



int CrockThread::compute_move(int axe) /* 0 for x, 1 for y */
{
  int change = 0;
  
	limit[0] = midx;
	limit[1] = midy;

	current_dep[axe] += cm_speed[axe]; /* We adjust the displacement */

	if (current_dep[axe] > (int)(limit[axe] * MAX_DEP))
	{
		if (current_dep[axe] > limit[axe])
			current_dep[axe] = limit[axe];
		direction[axe] = -1;
	}/* This is when we reach the upper screen limit */
	if (current_dep[axe] < (int)(-limit[axe] * MAX_DEP))
	{
		if (current_dep[axe] < -limit[axe])
			current_dep[axe] = -limit[axe];
		direction[axe] = 1;
	}/* This is when we reach the lower screen limit */

	if (direction[axe] == 1)/* We adjust the speed */
		cm_speed[axe] += 1;
	else if (direction[axe] == -1)
		cm_speed[axe] -= 1;

	if (cm_speed[axe] > MAX_DEP_SPEED)
		cm_speed[axe] = MAX_DEP_SPEED;
	else if (cm_speed[axe] < -MAX_DEP_SPEED)
		cm_speed[axe] = -MAX_DEP_SPEED;

	if((rand() % DIRECTION_CHANGE_RATE) == 0)
	{
		/* We change direction */
		change = rand() % 2;
		if (change != 1)
			if (direction[axe] == 0)
				direction[axe] = change - 1; /* 0 becomes either 1 or -1 */
      		else
				direction[axe] = 0; /* -1 or 1 become 0 */
	}
	return(current_dep[axe]);
}

void CrockThread::rock_tick(arock *arocks, int d)
{
	if (arocks->depth > 0)
    {
		rock_draw(arocks, false);
		arocks->depth -= speed;
		if(rotate_p)
			arocks->theta = (arocks->theta + d) % RESOLUTION;
		while(arocks->theta < 0)
			arocks->theta += RESOLUTION;
		if(arocks->depth < (MIN_DEPTH * DEPTH_SCALE))
			arocks->depth = 0;
		else
		{
			rock_compute(arocks);
			rock_draw(arocks, true);
		}
    }
	else if((rand() % 40) == 0)
		rock_reset(arocks);
}


void CrockThread::rock_compute(arock *arocks)
{
  DOUBLE factor = depths [arocks->depth];
  arocks->size = (int) ((arocks->real_size * factor) + 0.5);
  arocks->x = midx + (cos_array[arocks->theta] * arocks->r * factor);
  arocks->y = midy + (sin_array[arocks->theta] * arocks->r * factor);
  if (move_p) {
     DOUBLE move_factor = (DOUBLE)(MOVE_STYLE - (DOUBLE)arocks->depth /
 			  (DOUBLE)((MAX_DEPTH + 1) * (DOUBLE)DEPTH_SCALE));
     /* move_factor is 0 when the rock is close, 1 when far */
     arocks->x += (DOUBLE)dep_x * move_factor;
     arocks->y += (DOUBLE)dep_y * move_factor;
  }
}


void CrockThread::rock_draw(arock *arocks, bool draw_p)
{
	BRect visrock;

	if (draw_p)
		mView->SetHighColor(arocks->color);
	else
		mView->SetHighColor(0,0,0);

  if (arocks->x <= 0 || arocks->y <= 0 ||
      arocks->x >= width || arocks->y >= height)
    {
      /* this means that if a rock were to go off the screen at 12:00, but
	 would have been visible at 3:00, it won't come back once the observer
	 rotates around so that the rock would have been visible again.
	 Oh well.
       */
      if (!move_p) arocks->depth = 0;
      return;
    }
	if(arocks->size < MAX_WIDTH)
  	{
  		// draw a rock
		visrock.Set(0,0,arocks->size-1, arocks->size-1);
		visrock.OffsetTo(arocks->x - arocks->size/2, arocks->y - arocks->size/2);
		mView->FillRect(visrock,draw_p?B_SOLID_HIGH:B_SOLID_LOW);
	}
}

void CrockThread::rock_reset(arock *arocks)
{
	arocks->real_size = MAX_WIDTH;
	arocks->r = (RESOLUTION * 0.7) + (rand() % (30 * RESOLUTION));
	arocks->theta = rand() % RESOLUTION;
	arocks->depth = MAX_DEPTH * DEPTH_SCALE;
	arocks->color.red =   128+(rand()&127);
	arocks->color.green = 128+(rand()&127);
	arocks->color.blue =  128+(rand()&127);
	rock_compute(arocks);
	rock_draw(arocks, true);
}
