
/*
  See copyright notices in laser.cpp
*/

#pragma once


#pragma export on


extern "C" {

extern void	module_initialize(void *inSettings, long inSettingsSize);
extern void	module_cleanup(void **outSettings, long *outSettingsSize);
extern void	module_start_saving(BView *inView);
extern void	module_stop_saving();
extern void module_start_config(BView *inView);
extern void module_stop_config();

}
#pragma export reset
#include "CSaveThread.h"



#define LRAND(x) rand(x)
#define NRAND(X) ((int)(LRAND()%(X)))
#define MINREDRAW 3		/* Number of redrawn on each frame */
#define MAXREDRAW 8
#define MINLASER  1		/* Laser number */
#define MINWIDTH  2		/* Laser ray width range */
#define MAXWIDTH 40
#define MINSPEED  2		/* Speed range */
#define MAXSPEED 25
#define MINDIST  10		/* Minimal distance from edges */
#define COLORSTEP 3		/* Laser color step */
#define RANGE_RAND(min,max) ((min) + LRAND() % ((max) - (min)))
#define MI_CYCLES 150	/* number of runs before re-init */

typedef enum {
	TOP, RIGHT, BOTTOM, LEFT
} border;


class laserstruct
{
	public:
	int         bx;		/* border x */
	int         by;		/* border y */
	border      bn;		/* active border */
	int         dir;	/* direction */
	int         speed;	/* laser velocity from MINSPEED to MAXSPEED */
	int         sx[MAXWIDTH];	/* x stack */
	int         sy[MAXWIDTH];	/* y stack */
	long		gcv;	/* color-index */
};


class lasersstruct
{
	public:
	int         width;
	int         height;
	int         cx;		/* center x */
	int         cy;		/* center y */
	int         lw;		/* laser width */
	int         ln;		/* laser number */
	int         lr;		/* laser redraw */
	int         sw;		/* stack width */
	int         so;		/* stack offset */
	int         time;	/* up time */
	laserstruct *laser;
};





class ClaserThread : CSaveThread {
public:
					ClaserThread(double sleep);
					
	virtual void	StartSaving(BView *view);
	virtual void	StopSaving();

protected:
	virtual double	Save();
	void			init_laser(long);
	void			draw_laser_once();

protected:
	double	mSleep;
	long	batchcount;
	float	width,height;
	float	midx,midy;
	
// add all the variables you want here
	lasersstruct *lasers;
};

