/*
 * The 'laser' screensaver, taken from Linux OpenWindows, and adapted for
 * Hiroshi Lockheimer's screensaver by Marco Nelissen <marcone@xs4all.nl>
 */

/*-
 * laser.c - laser for xlockmore
 *
 * Copyright (c) 1995 Pascal Pensa <pensa@aurora.unice.fr>
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 */

/*
 * Some parts 1996 Hiroshi Lockheimer
 */

#include "laser.h"


static void init_pixmaps(), tick_lasers();


const rgb_color	kBlack		= {0, 0, 0, 0};
const rgb_color	kWhite		= {255, 255, 255, 0};

/*
 Added by Marco Nelissen
 This colortable wasn't in the original. It used some other method to make random
 colors, but I didn't want too spend too much time figuring out how it did it, so
 I hacked this together instead.
 If you don't like the colors, just change them...
*/
rgb_color lasercolors[]=
	{
		// some shades of red
		{255,70,70,0},
		{255,0,0,0},
		{200,0,0,0},
		{155,0,0,0},

		// some shades of green
		{70,255,100,0},
		{0,255,0,0},
		{0,200,0,0},
		{0,155,0,0},

		// some shades of blue
		{100,100,255,0},
		{0,0,255,0},
		{0,0,200,0},
		{0,0,155,0},

		// some shades of yellow
		{255,255,70},
		{255,255,0},
		{200,200,0},
		{155,155,0},

		// some shades of purple
		{255,0,255,0},
		{200,0,200,0},
		{155,0,155,0},
	};
// works best with a prime number of color
// (or randomize the different shades sufficiently and set COLORSTEP to 1)
const NUM_COLORS=sizeof(lasercolors)/sizeof(rgb_color);

ClaserThread	*glaser = NULL;
ClaserThread	*gMinilaser = NULL;


void
module_initialize(
	void	*inSettings,
	long 	inSettingsSize)
{
#pragma unused (inSettings, inSettingsSize)
}


void
module_cleanup(
	void	**outSettings,
	long	*outSettingsSize)
{
	*outSettings = NULL;
	*outSettingsSize = 0;
}


void
module_start_saving(
	BView	*inView)
{	
	srand((long)system_time());

	inView->Window()->Show();

	glaser = new ClaserThread(12500.0);
	glaser->StartSaving(inView);	
}


void
module_stop_saving()
{
	glaser->StopSaving();

//	// release_laser()
//
//	if (lasers != NULL)
//	{
//		if (lasers->laser != NULL)
//			delete[] lasers->laser;
//	}
//	delete lasers;
//	lasers = NULL;

	delete (glaser);
	glaser = NULL;
}


void
module_start_config(
	BView *inView)
{
	if (!inView->Window()->Lock())
		return;
		
	BRect frame;
	
	frame = inView->Bounds();
	frame.top += 10.0;
	frame.left += 10.0;
	frame.bottom = frame.top + 12.0;
	BStringView *view = new BStringView(frame, B_EMPTY_STRING, "laser, the Jarre-concert blanker");
	inView->AddChild(view);
	view->SetViewColor(inView->ViewColor());
	view->SetFontName("Emily");
	
	frame = inView->Bounds();
	frame.top += 30.0;
	frame.bottom = frame.top + 40.0;
	frame.left += 20.0;
	frame.right -= 20.0;
	BRect textArea = frame;
	textArea.OffsetTo(B_ORIGIN);
	BTextView *caption = new BTextView(frame, B_EMPTY_STRING, textArea,
						   			   B_FOLLOW_ALL, B_WILL_DRAW);
	caption->SetText("a port of the 'laser' blanker, taken from Linux' xlockmore\n" 
					 "by Marco Nelissen <marcone@xs4all.nl>");
	inView->AddChild(caption);
	caption->SetViewColor(inView->ViewColor());
	caption->SetDrawingMode(B_OP_OVER);
	caption->SetFontName("Erich");
	caption->MakeEditable(FALSE);
	caption->MakeSelectable(FALSE);
	caption->SetWordWrap(TRUE);	
	
	BRect previewFrame = inView->Bounds();
	previewFrame.top = frame.bottom + 10.0;
	previewFrame.left += 10.0;
	previewFrame.right -= 10.0;
	previewFrame.bottom -= 10.0;
	BView *preview = new BView(previewFrame, B_EMPTY_STRING, 
							   B_FOLLOW_ALL, B_WILL_DRAW);
	inView->AddChild(preview);		
	preview->SetViewColor(0,0,0);
	preview->SetLowColor(0,0,0);
	preview->Invalidate();
	
	inView->Window()->UpdateIfNeeded();
	
	inView->Window()->Unlock();
	
	gMinilaser = new ClaserThread(25000.0);
	gMinilaser->StartSaving(preview);
}


void
module_stop_config()
{
	gMinilaser->StopSaving();
	delete (gMinilaser);
	gMinilaser = NULL;
}




ClaserThread::ClaserThread(double	sleep)
	: CSaveThread()
{
	int i;

	mSleep = sleep;
	batchcount=-7;
// init code for blanker-class goes here

	lasers=new lasersstruct;
	lasers->laser=NULL;
	lasers->ln=0;
}


void ClaserThread::StartSaving(BView	*view)
{
	if (!view->Window()->Lock())
		return;

	BRect bounds=view->Bounds();
	width = bounds.IntegerWidth();
	height = bounds.IntegerHeight();
	midx = width/2;
	midy = height/2;
// more init code can be inserted here
	
	// for effect, start with one beam only
	srand(system_time());
	init_laser(1);
	lasers->time=MI_CYCLES/2;
// end of code
	view->Window()->Unlock();
	CSaveThread::StartSaving(view);	
}

	
void
ClaserThread::StopSaving()
{
	CSaveThread::StopSaving();
}

	
double ClaserThread::Save()
{
	if (mView->Window()->Lock())
	{
// insert saver-code here

		// draw_laser()
		lasersstruct *lp = lasers;
		int         i;


		mView->BeginLineArray(lp->lr*lp->ln*2);
		for (i = 0; i < lp->lr; i++)
			draw_laser_once();
		mView->EndLineArray();
		mView->Sync();

		if (++lp->time > MI_CYCLES)
			init_laser(batchcount);

// end of saver-code
		mView->Window()->Unlock();
	}
	return (mSleep);
}



void ClaserThread::draw_laser_once()
{
	lasersstruct *lp = lasers;
	int         i;
	rgb_color black={0,0,0,0};

	for (i = 0; i < lp->ln; i++) {
		laserstruct *l = &lp->laser[i];

		if (lp->sw >= lp->lw)
		{
			mView->AddLine(	BPoint(lp->cx, lp->cy),
								BPoint(l->sx[lp->so], l->sy[lp->so]),black);
		}
		if (l->dir) {
			switch (l->bn) {
				case TOP:
					l->bx -= l->speed;
					if (l->bx < 0) {
						l->by = -l->bx;
						l->bx = 0;
						l->bn = LEFT;
					}
					break;
				case RIGHT:
					l->by -= l->speed;
					if (l->by < 0) {
						l->bx = lp->width + l->by;
						l->by = 0;
						l->bn = TOP;
					}
					break;
				case BOTTOM:
					l->bx += l->speed;
					if (l->bx >= lp->width) {
						l->by = lp->height - l->bx % lp->width;
						l->bx = lp->width;
						l->bn = RIGHT;
					}
					break;
				case LEFT:
					l->by += l->speed;
					if (l->by >= lp->height) {
						l->bx = l->by % lp->height;
						l->by = lp->height;
						l->bn = BOTTOM;
					}
			}
		} else {
			switch (l->bn) {
				case TOP:
					l->bx += l->speed;
					if (l->bx >= lp->width) {
						l->by = l->bx % lp->width;
						l->bx = lp->width;
						l->bn = RIGHT;
					}
					break;
				case RIGHT:
					l->by += l->speed;
					if (l->by >= lp->height) {
						l->bx = lp->width - l->by % lp->height;
						l->by = lp->height;
						l->bn = BOTTOM;
					}
					break;
				case BOTTOM:
					l->bx -= l->speed;
					if (l->bx < 0) {
						l->by = lp->height + l->bx;
						l->bx = 0;
						l->bn = LEFT;
					}
					break;
				case LEFT:
					l->by -= l->speed;
					if (l->by < 0) {
						l->bx = -l->bx;
						l->by = 0;
						l->bn = TOP;
					}
			}
		}

	//	XChangeGC(display, lp->stippledGC, GCForeground, &l->gcv);
	//	XDrawLine(display, MI_WINDOW(mi), lp->stippledGC,
	//		  lp->cx, lp->cy, l->bx, l->by);
		mView->AddLine(	BPoint(lp->cx, lp->cy),
							BPoint(l->bx, l->by),
							lasercolors[l->gcv]);

		l->sx[lp->so] = l->bx;
		l->sy[lp->so] = l->by;

	}

	if (lp->sw < lp->lw)
		++lp->sw;

	lp->so = (lp->so + 1) % lp->lw;
}


void ClaserThread::init_laser(long numlasers)
{
	int         i, c = 0;
	lasersstruct *lp;

	if(lp=lasers)
	{
		lp->width = width;
		lp->height = height;
		lp->time = 0;
	
		lp->ln = numlasers;
		if (lp->ln < -MINLASER) {
			/* if lp->ln is random ... the size can change */
			if (lp->laser != NULL) {
				delete lp->laser;
				lp->laser = NULL;
			}
			lp->ln = NRAND(-lp->ln - MINLASER + 1) + MINLASER;
		} else if (lp->ln < MINLASER)
			lp->ln = MINLASER;
	
		if (!lp->laser)
			lp->laser = new laserstruct[lp->ln];
			
		if(mView)
			mView->FillRect(mView->Bounds(),B_SOLID_LOW);
	
		if (MINDIST < lp->width - MINDIST)
			lp->cx = RANGE_RAND(MINDIST, lp->width - MINDIST);
		else
			lp->cx = RANGE_RAND(0, lp->width);
		if (MINDIST < lp->height - MINDIST)
			lp->cy = RANGE_RAND(MINDIST, lp->height - MINDIST);
		else
			lp->cy = RANGE_RAND(0, lp->height);
		lp->lw = RANGE_RAND(MINWIDTH, MAXWIDTH);
		lp->lr = RANGE_RAND(MINREDRAW, MAXREDRAW);
		lp->sw = 0;
		lp->so = 0;

		c = LRAND();
	
		for (i = 0; i < lp->ln; i++) {
			laserstruct *l = &lp->laser[i];
	
			l->bn = (border) NRAND(4);
	
			switch (l->bn) {
				case TOP:
					l->bx = NRAND(lp->width);
					l->by = 0;
					break;
				case RIGHT:
					l->bx = lp->width;
					l->by = NRAND(lp->height);
					break;
				case BOTTOM:
					l->bx = NRAND(lp->width);
					l->by = lp->height;
					break;
				case LEFT:
					l->bx = 0;
					l->by = NRAND(lp->height);
			}
	
			l->dir = LRAND() & 1;
			l->speed = ((RANGE_RAND(MINSPEED, MAXSPEED) * lp->width) / 1000) + 1;

			l->gcv =  c%NUM_COLORS;
			c = (c + COLORSTEP);
		}
	}
}

