# include	<StBind.h>
# include	<CSaveThread.h>

# include	"Iconography.h"

# define SLEEP_MICROSECONDS		(1000000.0)
# define ICON_SIZE				(32)

class CIconographySaveThread;

static rgb_color kBackgroundColor = {255, 255, 255, 0};
CIconographySaveThread* gSaver = NULL;

class CIconographySaveThread : public CSaveThread
{
public:
					CIconographySaveThread();
					~CIconographySaveThread();
					
	virtual void	StartSaving(BView *view);
	virtual void	StopSaving();
	
private:
	virtual double	Save();
	virtual void	DrawIcon(uchar* inIconBits, long inBitsLength);

	BQuery*			mIconList;
};

CIconographySaveThread::CIconographySaveThread()
{
	mIconList = NULL;
}

CIconographySaveThread::~CIconographySaveThread()
{
	if (mIconList)
		delete mIconList;
}

void CIconographySaveThread::StartSaving(BView *view)
{
	BDatabase* db = boot_volume().Database();

		// XXX - Shame, shame, shame. "Icon" is a private table.
	BTable* iconTable = db->FindTable("Icon");
	if (iconTable == NULL)
		goto done;
	mIconList = new BQuery();
	if (mIconList == NULL)
		goto done;
		
		// Extract icons from database.
	mIconList->AddTree(iconTable);
	mIconList->PushOp(B_ALL);
	mIconList->Fetch();
	
done:
	CSaveThread::StartSaving(view);

		// Get our window and erase it.
	if (mView->Window()->Lock())
	{
		BRect viewBounds = mView->Bounds();
		mView->SetHighColor(kBackgroundColor);
		mView->FillRect(viewBounds);
		mView->Window()->Unlock();
	}
}

void CIconographySaveThread::StopSaving()
{
	CSaveThread::StopSaving();
	if (mIconList)
	{
		delete mIconList;
		mIconList = NULL;
	}
}

double CIconographySaveThread::Save()
{
	if (mIconList)
	{
		int iconCount = mIconList->CountRecordIDs();
		if (iconCount > 0)
		{
			int iconIndex = rand() % iconCount;
			BDatabase* db = boot_volume().Database();
			BRecord iconRecord(db, mIconList->RecordIDAt(iconIndex));
			if (iconRecord.Error() != B_NO_ERROR)
				goto done;
			
				// XXX - More abuse of private data structures...
			long bitsLength;
			uchar* iconBits = (uchar*) iconRecord.FindRaw("largeBits", &bitsLength);
			if (iconBits == NULL)
				goto done;
			
			DrawIcon(iconBits, bitsLength);
		}
	}

done:
	return SLEEP_MICROSECONDS;
}

void CIconographySaveThread::DrawIcon(uchar* inIconBits, long inBitsLength)
{
	if (!mView->Window()->Lock())
		return;

		// Get our window.
	BRect viewBounds = mView->Bounds();

		// Calculate how big each pixel in the icon will be.
	int maxHorizontalBlockSize = floor(viewBounds.right / ICON_SIZE);
	int maxVerticalBlockSize = floor(viewBounds.bottom / ICON_SIZE);
	int blockSize = (maxHorizontalBlockSize > maxVerticalBlockSize) ?
		maxVerticalBlockSize : maxHorizontalBlockSize;

		// Position the icon within the screen.
	double horizontalOffset = floor((viewBounds.right - blockSize * ICON_SIZE) / 2);
	double verticalOffset = floor((viewBounds.bottom - blockSize * ICON_SIZE) / 2);

		// Get the system color map.
	color_map* beColors = system_colors();

		// Draw the icon
	for (int x = 0; x < ICON_SIZE; x++)
	{
		for (int y = 0; y < ICON_SIZE; y++)
		{
				// Position rectangle for each pixel
			BRect pixelRect(0, 0, blockSize - 1, blockSize - 1);
			pixelRect.OffsetTo(horizontalOffset + x * blockSize,
				verticalOffset + y * blockSize);
			
				// Choose appropriate color
			uchar color = inIconBits[x + ICON_SIZE * y];
			if (color == B_TRANSPARENT_8_BIT)
				mView->SetHighColor(kBackgroundColor);
			else
				mView->SetHighColor(beColors->color_list[color]);
				
				// Fill it!
			mView->FillRect(pixelRect);
		}
	}

	mView->Sync();
	mView->Window()->Unlock();
}

void module_initialize(void *inSettings, long inSettingsSize)
{
}

void module_cleanup(void **outSettings, long *outSettingsSize)
{
	*outSettings = NULL;
	*outSettingsSize = 0;
}

void module_start_saving(BView *inView)
{	
	srand((long) system_time());

	inView->Window()->Show();

	gSaver = new CIconographySaveThread();
	gSaver->StartSaving(inView);	
}

void module_stop_saving()
{
	gSaver->StopSaving();
	delete (gSaver);
	gSaver = NULL;
}

void module_start_config(BView *inView)
{
	if (!inView->Window()->Lock())
		return;

	BStringView *view = NULL;
	
	view = new BStringView(BRect(20.0, 20.0, 100.0, 32.0),
		B_EMPTY_STRING, "Iconography");
	inView->AddChild(view);
	view->SetViewColor(inView->ViewColor());
	view->SetFontName("Emily");
	
	view = new BStringView(BRect(30.0, 40.0, 130.0, 52.0),
		B_EMPTY_STRING, "Copyright  1996 Eric Kidd");
	inView->AddChild(view);
	view->SetViewColor(inView->ViewColor());
	
	inView->Window()->Unlock();
}


void
module_stop_config()
{
}
