#include "main.h"
#ifdef PC_CRAP
#include "win_PC.cpp"
#else
#include <OS.h>
#endif

Win :: Win(BEntry paren, BRect r) : BWindow(r, "Hello", 
		B_TITLED_WINDOW, B_NOT_RESIZABLE) {
	uint16 i;
	srand(clock()*rand());
	z_buffer = NULL;
	for(i=0; i<NUM_T_MAPS; i++) tex[i]=NULL;
	for(i=0; i<NUM_B_MAPS; i++) bump[i]=NULL;
	parent=paren;
	rect.top=r.top;
	rect.bottom=r.bottom;
	rect.left=r.left;
	rect.right=r.right;
	r.OffsetTo(B_ORIGIN);
	r.right--;
//	s_buffer = new SBuffer[BOTTOM-TOP];
	z_buffer = (int32 *)malloc((BOTTOM-TOP)*(RIGHT-LEFT)*sizeof(int32));
	view=new BView(r, "", B_FOLLOW_ALL, B_WILL_DRAW);
	bitmap=new BBitmap(r, B_RGB_32_BIT, TRUE);
	bits=(uint32 *)bitmap->Bits();
	frames=0;
	a[0]=0;
	dir = 2;
	zoom =0;
	MakeTables();
	for(i=0; i<NUM_T_MAPS; i++) GetTMaps(i);
	for(i=0; i<NUM_B_MAPS; i++) GetBMaps(i);
	memset(bits, 0, BOTTOM*bitmap->BytesPerRow());
	object[0]=new Object(&parent, "object/test.3db", -10, -5, -120,
			255, GOURAD_SHADED, z_buffer, tex[1], NULL);
	object[1]=new Object(&parent, "object/test.3db", 10, 5, -80,
			100, GOURAD_SHADED, z_buffer, NULL, bump[0]);
	light=new Light(200, 100, 0, 0, 10);
	light2=new Light(150, 0, 0, 0, 10);
	light2->Rotate(90, 90, 180);	
	light->Rotate(90, 90, 180);	
	object[0]->Rotate(200, 200, 200);
	object[1]->Rotate(45, 45, 45);
	AddChild(view);
	Show();
	time=system_time();
	}

Win :: ~Win() {
	uint16 i;
	time=system_time()-time;
	printf("%dframes %fsecs %ffps\n", frames, time/1e6, frames*1e6/time);
	RemoveChild(view);
	for(i=0; i<NUM_T_MAPS; i++) if(tex[i]) free(tex[i]);
	for(i=0; i<NUM_B_MAPS; i++) if(bump[i]) free(bump[i]);
	delete light;
	delete light2;
	delete bitmap;	bitmap=NULL;
	delete view;	view=NULL;
	}

void Win :: MakeTables() {
	uint32 i, j;
	for(i=0; i<256; i++) {
		sine[i] = sin(i*M_PI/128);
		cosine[i] = cos(i*M_PI/128);
		}
	}

void Win :: GetTMaps(uint16 i) {
	const char *texture_file;
	switch(i) {
		case 2:
			texture_file="texture/aw.tga";
			break;
		case 1:
			texture_file="texture/fish.tga";
			break;
		default:
			texture_file="texture/web.tga";
			break;
		}
	BEntry file_entry=parent;		
	file_entry.SetTo(texture_file);
	BFile file;
	if(file.SetTo(&file_entry, B_READ_ONLY) != B_NO_ERROR) return;
	file.Seek(21, 0);
	uchar *raw, *tex_r, *tex_g, *tex_b;
	raw = new uchar[256*256*3];
	tex_r=new uchar[256*256];
	tex_g=new uchar[256*256];
	tex_b=new uchar[256*256];
	if(!tex[i]) tex[i]=(uchar *)malloc(256*256*3*sizeof(uchar));
	file.Read(raw, 256*256*3);
	uchar *r=raw;
	for(int32 j=0; j<256*256; j++) {
		tex_b[j]=*r++;
		tex_g[j]=*r++;
		tex_r[j]=*r++;
		}
	uchar *t=tex[i];
	memcpy(t, tex_r, 256*256);
	memcpy(&t[256*256], tex_g, 256*256);
	memcpy(&t[256*256*2], tex_b, 256*256);
	delete(raw, tex_r, tex_g, tex_b);
	}

void Win :: GetBMaps(uint16 i) {
	const char *texture_file;
	switch(i) {
		case 2:
			texture_file="bump/water.tga";
			break;
		case 1:
			texture_file="bump/smooth.tga";
			break;
		default:
			texture_file="bump/web.tga";
			break;
		}
	BEntry file_entry=parent;		
	file_entry.SetTo(texture_file);
	BFile file;
	if(file.SetTo(&file_entry, B_READ_ONLY) != B_NO_ERROR) return;
	file.Seek(21, 0);
	uchar *raw, *tex_r, *tex_g, *tex_b;
	raw = new uchar[256*256*3];
	tex_r=new uchar[256*256];
	tex_g=new uchar[256*256];
	tex_b=new uchar[256*256];
	if(!bump[i]) bump[i]=(char *)malloc(256*256*sizeof(char));
	file.Read(raw, 256*256*3);
	uchar *r=raw;
	int32 j;
	for(int32 j=0; j<256*256; j++) {
		tex_b[j]=*r++;
		tex_g[j]=*r++;
		tex_r[j]=*r++;
		}
	char *b=bump[i];
	for(j=0; j<256*256; j++) b[j]=(tex_r[j]+tex_g[j]+tex_b[j])/3-128;
	delete(raw, tex_r, tex_g, tex_b);
	}

void Win :: Water(int16 phase) {
	char *swap;
	memcpy(t_bump, &bump[2][256*250], 256*6);
	memcpy(&t_bump[256*6], bump[2], 256*250);
	memcpy(bump[2], t_bump, 256*256);
	}

void Win :: Draw() {
	int i;
/*	if(dir==2) {
		zoom=rand();
		zoom=0;
		zoom/=32;
		dir=0;
		}
	else if(dir==0) {
		if(object[zoom]->z >-25) dir++;
		object[zoom]->z+=2;
		object[zoom]->x /= 2;
		object[zoom]->y /= 2;
		}
	else if(dir==1) {
		if(object[zoom]->z <-60) dir++;
		object[zoom]->z-=2;
		object[zoom]->x *= 2;
		object[zoom]->y *= 2;
		}
*/	thread_id thrd[2];
	int32 exit;
	frames++;
	a[0]+=1;
	if(a[0]>=256) a[0]-=256;
//	Water(a[0]);
	if(z_buffer) memset(z_buffer, -128, (BOTTOM-TOP)*(RIGHT-LEFT)*sizeof(int32));
	for(i=0; i<2; i++ ) object[i]->Dark();
	Lock();
	view->Sync();
	Unlock();
	for(i=0; i<2; i++) object[i]->Erase(bits);
	for(i=0; i<2; i++) object[i]->Rotate(a[0], a[0], a[0]);
	light->Rotate(3, 3, 3);
	light2->Rotate(7, 7, 7);
	for(i=0; i<2; i++) object[i]->Shade(light);
	for(i=0; i<2; i++) object[i]->Shade(light2);
	for(i=0; i<2; i++) thrd[i]=object[i]->Draw(bits);
#ifdef BE_CRAP
	for(i=0; i<2; i++) wait_for_thread(thrd[i], &exit);
#endif
	Lock();
	view->DrawBitmapAsync(bitmap);
	Unlock();
	PostMessage('draw');
	}

#ifdef BE_CRAP
void Win :: MessageReceived(BMessage *msg) {
	switch(msg->what) {
		case 'draw':
			Draw();
		}
	}

bool Win :: QuitRequested() {
	be_app->PostMessage(B_QUIT_REQUESTED);
	return TRUE;
	}
#endif
