#include "main.h"

Vertex :: Vertex() {
	}

Vertex :: ~Vertex() {
	}

void Vertex :: Move(float *pnt) {
	x=pnt[0];
	y=pnt[1];
	z=pnt[2];
	CalcNormal();
	}

void Vertex :: CalcNormal(void) {	//calculate normal once
	float length = sqrt(x*x + y*y + z*z);
#ifdef PC_CRAP
	if(!length) length=0.000001;
#endif
	X = x/length;
	Y = y/length;
	Z = z/length;
	}

void Vertex :: Rotate(Object *o) {
	float sin_a, cos_a, sin_b, cos_b, sin_c, cos_c;
	sin_a = o->sin_a;	cos_a = o->cos_a;
	sin_b = o->sin_b;	cos_b = o->cos_b;
	sin_c = o->sin_c;	cos_c = o->cos_c;
	wz = y*cos_a - z*sin_a;		//rotate about x-axis
	wy = y*sin_a + z*cos_a;
	wx = x*cos_b - wz*sin_b;		//rotate about y-axis
	wz = x*sin_b + wz*cos_b;
	float temp = wx*cos_c - wy*sin_c;	//rotate about z-axis
	wy = wx*sin_c + wy*cos_c;
	wx = temp;
	sz = wz+o->z;
//	if(!sz) sz=0.000001;
	sx = MID_H+(wx+o->x)/sz*EYE_DIST;	//project 3-D to 2-D
	sy = MID_V+(wy+o->y)/sz*EYE_DIST;
//	sx = MID_H+(wx+o->x)*2;	//project 3-D to 2-D	//no depth scaling
//	sy = MID_V+(wy+o->y)*2;
	int32 xs=sx, ys=sy;
	if(xs < o->erase.left) o->erase.left = sx;
	if(xs > o->erase.right) o->erase.right = sx;
	if(ys < o->erase.top) o->erase.top = sy;
	if(ys > o->erase.bottom) o->erase.bottom = sy;
	if(o->flat | o->gourad) {
		wZ = Y*cos_a - Z*sin_a;		//rotate about x-axis
		wY = Y*sin_a + Z*cos_a;
		wX = X*cos_b - wZ*sin_b;		//rotate about y-axis
		wZ = X*sin_b + wZ*cos_b;
		temp = wX*cos_c - wY*sin_c;	//rotate about z-axis
		wY = wX*sin_c + wY*cos_c;
		wX = temp;
		}
	}

void Vertex :: Dark() {		//darken vertex before shade
	shade = 0;
	}

void Vertex :: Shade(Light *l) {	//add light
	shade += (wX*l->wx+wY*l->wy+wZ*l->wz)*(l->intensity)+(l->ambient);
	if(shade<0) shade=0;		//no light =0
	//if(shade>1.0) shade=1.0;		//used to limit brightness
	}
