#include "main.h"

Section :: Section() {
	z_buffered=flat=textured=bumped = FALSE;
	c_left = NULL;
	m_left = NULL;
	}

Section :: ~Section() {
	if(c_left) free(c_left);
	if(m_left) free(m_left);
	}

void Section :: AllocCol() {
	if(!c_left) c_left = (uchar *)malloc(pps*(BOTTOM-TOP)*sizeof(uchar));
	}

void Section :: AllocMap() {
	if(!m_left) m_left = (uchar *)malloc(pps*(BOTTOM-TOP)*sizeof(uchar));
	}

void Section :: SetTo(uchar polys, float *t, float *b, uint32 *colors, uint16 sec, uint16 secs,
		bool flat_shaded, bool gourad, int32 *z_buff, uchar *text, char *bum, uchar opac) {
	pps = polys;
	section = sec;
	sections = secs;
	flat=flat_shaded;
	vertex = new Vertex[pps*2];
	left = (int16 *)malloc(sizeof(int16)*pps*(BOTTOM-TOP));
	memset(left ,0,pps*(BOTTOM-TOP)*sizeof(int16));
	if(text || bum) AllocMap();
	if(gourad) AllocCol();
	if(opac<255) {
		opacity = opac;
		opaque = FALSE;
		}
	else opaque = TRUE;
	if(z_buff) {
		z_buffer = z_buff;
		z_buffered = TRUE;
		}
	if(text) {
		textured=TRUE;
		tex_r=&text[0];
		tex_g=&text[256*256];
		tex_b=&text[2*256*256];
		}
	else {
		red = (uchar *)malloc(sizeof(uchar)*pps);
		green = (uchar *)malloc(sizeof(uchar)*pps);
		blue = (uchar *)malloc(sizeof(uchar)*pps);
		for(char i=0; i<pps; i++) {
			red[i]=(uchar )(colors[i]>>8);
			green[i]=(uchar )(colors[i]>>16);
			blue[i]=(uchar )(colors[i]>>24);
			}
		}
	if(bum) {
		bump=bum;
		bumped=TRUE;
		}
	if(sec) for(char i=0; i<pps; i++) {
		vertex[i+pps].Move(&b[i*3]);
		}
	else for(char i=0; i<pps; i++) {
		vertex[i].Move(&t[i*3]);
		vertex[i+pps].Move(&b[i*3]);
		}
	}

//flat shade
void Section :: Edge(int16 *edge, Vertex *v1, Vertex *v2) {
	int16 y1, y2, temp;
	y1=v1->sy;
	y2=v2->sy;
	temp=y2-y1;
	if(temp) {
		int32 x1, x2, slope;
		if(temp<0) {		//swap
			temp*=-1;
			y1^=y2;	y2^=y1;	y1^=y2;
			x2=v1->sx;	x1=v2->sx;
			}
		else {x2=v2->sx;	x1=v1->sx;}
		x2<<=16;	x1<<=16;
		slope=(x2-x1)/temp;
		if(y2>BOTTOM) y2=BOTTOM;
		if(y1<TOP) {
			x1 += (TOP-y1)*slope;
			y1=TOP;
			}
		for(; y1<y2; y1++) {
			edge[y1]=x1>>16;
			x1+=slope;
			}
		}
	}

//gourad shading with no mapping
void Section :: Edge(int16 *edge, Vertex *v1, Vertex *v2, uchar *shade) {
	int16 y1, y2, temp;
	y1=v1->sy;
	y2=v2->sy;
	temp = y2-y1;
	if(temp) {
		int32 c1, c2, c_slope;
		int32 x1, x2, slope;
		if(temp<0) {
			temp *= -1;
			y1^=y2;	y2^=y1;	y1^=y2;
			x1=v2->sx;	x2=v1->sx;
			c1=v2->shade;	c2=v1->shade;
			}
		else {
			x1=v1->sx;	x2=v2->sx;
			c1=v1->shade;	c2=v2->shade;
			}
		x2<<=16;	x1<<=16;
		c2<<=16;	c1<<=16;
		slope=(x2-x1)/temp;
		c_slope=(c2-c1)/temp;
		if(y2>BOTTOM) y2=BOTTOM;
		if(y1<TOP) {
			x1 += (TOP-y1)*slope;
			c1 += (TOP-y1)*c_slope;
			y1=TOP;
			}
		for(; y1<y2; y1++) {
			uint32 temp=c1>>16;
			if(temp>=256) temp=255;
			edge[y1]=x1>>16;
			shade[y1]=temp;
			x1+=slope;
			c1+=c_slope;
			}
		}
	}

//flat shading with maping
void Section :: Edge(int16 *edge, uchar *m,
		Vertex *v1, Vertex *v2, uint16 index, uint16 max) {
	int16 y1, y2, temp;
	y1=v1->sy;
	y2=v2->sy;
	temp = y2-y1;
	if(temp) {
		int32 x1, x2, slope;
		float m1, m2, m_slope;
		if(temp>0) {		//swap
			m1=255.9*index/max;		m2=255.9*(index+1)/max;
			x1=v1->sx;	x2=v2->sx;
			}
		else {
			temp *= -1;
			y1^=y2;	y2^=y1;	y1^=y2;
			x1=v2->sx;	x2=v1->sx;
			m1=255.9*(index+1)/max;		m2=255.9*index/max;
			}
		x1<<=16;	x2<<=16;
		slope=(x2-x1)/temp;
		m_slope=(m2-m1)/temp;
		if(y2>BOTTOM) y2=BOTTOM;
		if(y1<TOP) {
			x1 += (TOP-y1)*slope;
			m1 += (TOP-y1)*m_slope;
			y1=TOP;
			}
		for(; y1<y2; y1++) {
			edge[y1]=x1>>16;
			m[y1]=m1;
			x1+=slope;
			m1+=m_slope;
			}
		}
	}

//gourad shaping with mapping
void Section :: Edge(int16 *edge, uchar *m, Vertex *v1, Vertex *v2,
		uchar *shade, uint16 index, uint16 max) {
	int16 y1, y2, temp;
	y1=v1->sy;
	y2=v2->sy;
	temp = y2-y1;
	if(temp) {
		int32 c1, c2, c_slope, x1, x2, slope;
		float m_slope, m1, m2;
		if(temp>0) {		//swap
			m1=255.9*index/max;		m2=255.9*(index+1)/max;
			x1=v1->sx;	x2=v2->sx;
			c1=v1->shade;	c2=v2->shade;
			}
		else {
			temp *= -1;
			y1^=y2;	y2^=y1;	y1^=y2;
			x1=v2->sx;	x2=v1->sx;
			c1=v2->shade;	c2=v1->shade;
			m1=255.9*(index+1)/max;		m2=255.9*index/max;
			}
		x1<<=16;	x2<<=16;
		c1<<=16;	c2<<=16;
		slope=(x2-x1)/temp;
		c_slope=(c2-c1)/temp;
		m_slope=(m2-m1)/temp;
		if(y2>BOTTOM) y2=BOTTOM;
		if(y1<TOP) {
			x1 += (TOP-y1)*slope;
			c1 += (TOP-y1)*c_slope;
			m1 += (TOP-y1)*m_slope;
			y1=TOP;
			}
		for(; y1<y2; y1++) {
			uint32 temp=c1>>16;
			if(temp>=256) temp=255;
			edge[y1]=x1>>16;
			shade[y1]=temp;
			m[y1]=m1;
			x1+=slope;
			c1+=c_slope;
			m1+=m_slope;
			}
		}
	}

void Section :: SortV(char *order, Vertex **v) {
	int32 i, j, max;
	float max_val;
	//get top
	max=0;
	max_val=v[0]->sy;
	for(i=1; i<4; i++) {
		if(v[i]->sy < max_val) {
			max = i;
			max_val = v[i]->sy;
			}
		}
	order[0]=max;
	if(max>=3) i=0;
	else i=max+1;
	if(max<=0) j=3;
	else j=max-1;
	//get second
	if(v[i]->sy>v[j]->sy) {
		i^=j;
		j^=i;
		i^=j;
		}
	order[1]=i;
	i=max-2;
	if(i<0) i+=4;
	if(v[i]->sy<v[j]->sy) {
		order[2]=i;
		order[3]=j;
		}
	else {
		order[2]=j;
		order[3]=i;
		}
	}

void Section :: Mapping(float *x, float *y, uchar point, char edge, uchar index) {
	switch(edge) {
		case 0:
			*x = point;
			*y = 255*(section+1)/sections;
			break;
		case 1:
			*x = 255*index/pps;
			*y = point;
			break;
		case 2:
			*x = point;
			*y = 255*section/sections;
			break;
		default:
			*x = 255*(index+1)/pps;
			*y = point;
		}
	}

//basic shading
void Section :: Draw(uint32 *bits, int16 *up, int16 *top, uchar index) {
	int16 i, *e[4];
	Vertex *trans[4];
	trans[0]=&vertex[index+pps];
	if(index>0) i=index+pps-1;
	else i=2*pps-1;
	trans[1]=&vertex[i];
	if(top) {
		trans[2]=&vertex[i-pps];
		trans[3]=&vertex[index];
		e[2]=top;
		Edge(e[2], trans[2], trans[3]);
		}
	else {
		Section *s = this;
		s--;
		trans[2]=&s->vertex[i];
		trans[3]=&s->vertex[index+pps];
		e[2] = &s->left[index*(BOTTOM-TOP)];
		}
	e[0] = &left[index*(BOTTOM-TOP)];
	if(index%2) {
		e[1] = &up[BOTTOM-TOP];
		e[3] = &up[0];
		}
	else {
		e[1] = &up[0];
		e[3] = &up[BOTTOM-TOP];
		}
	if(index>pps) e[3] = &up[2*(BOTTOM-TOP)];
	else if(index<=0) {
		e[1] = &up[2*(BOTTOM-TOP)];
		Edge(e[1], trans[2], trans[1]);
		}
	Edge(e[0], trans[1], trans[0]);
	Edge(e[3], trans[3], trans[0]);

	int16 k, end, temp_l, temp_r, *r;
	char order[4];
	SortV(order, trans);
	temp_r=order[0];
	k=trans[temp_r]->sy;
	end=trans[order[1]]->sy;
	if(k>end) return;
	temp_l = temp_r;
	r=e[temp_r];
	if(k<TOP) k=TOP;
	ushort re, gr, bl;
	re=red[index];
	gr=green[index];
	bl=blue[index];
	if(flat) {
		int16 shade;
		shade=(trans[0]->shade+trans[1]->shade
				+trans[2]->shade+trans[3]->shade)/4;
		re *= shade;
		gr *= shade;
		bl *= shade;
		re >>= 8;
		gr >>= 8;
		bl >>= 8;
		if(re>255) re=255;
		if(gr>255) gr=255;
		if(bl>255) bl=255;		
		}
	int32 depth;
	if(z_buffered) {
		depth=(trans[0]->sz+trans[1]->sz
				+trans[2]->sz+trans[3]->sz)/4;
		}
	for(i=0; i<3; i++) {
		int16 *l;
		if(order[i]==temp_l) {
			temp_l = temp_l ? temp_l-1 : 3;
			l=e[temp_l];
			}
		else {
			if(temp_r>=3) temp_r=0;
			else temp_r++;
			r=e[temp_r];
			}
		end=trans[order[i+1]]->sy;
		if(end>BOTTOM) end=BOTTOM;
		int32 temp;
		for(; k<end; k++) {
			int16 j, temp;
			j=l[k];
			temp=r[k];
			if(temp>j) {
				if(j<LEFT) j=LEFT;
				if(temp>RIGHT) temp=RIGHT;
				uint32 *bit = &bits[k*RIGHT];
				int32 *z_buff;
				if(z_buffered) z_buff = &z_buffer[k*RIGHT];
				for(; j<temp; j++) {
					if(z_buffered) {
						if(depth<=z_buff[j]) goto END;
						z_buff[j]=depth;
						}
					if(opaque) bit[j] = (re|(gr<<8)|(bl<<16))<<8;
					else {
						uint16 t_r, t_g, t_b;
						uint32 t_c = bit[j];
						t_b = 256-opacity;
						t_r = t_b*(uchar )(t_c>>8)+opacity*re;
						t_r >>= 8;
						t_g = t_b*(uchar )(t_c>>16)+opacity*gr;
						t_g >>= 8;
						t_b = t_b*(uchar )(t_c>>24)+opacity*bl;
						t_b >>= 8;
						bit[j] = (t_r|(t_g<<8)|(t_b<<16))<<8;
						}
				END:
					;
					}
				}
			}
		}
	}	

//Gourad
void Section :: Draw(uint32 *bits, int16 *up, int16 *top, uchar index, uchar *c_up, uchar *c_top) {
	int16 i, j, *e[4];
	uchar *c[4];
	Vertex *trans[4];
	trans[0]=&vertex[index+pps];
	if(index>0) i=index+pps-1;
	else i=2*pps-1;
	trans[1]=&vertex[i];
	j = index*(BOTTOM-TOP);
	if(top) {
		trans[2]=&vertex[i-pps];
		trans[3]=&vertex[index];
		e[2]=top;
		c[2]=c_top;
		Edge(e[2], trans[2], trans[3], c[2]);
		}
	else {
		Section *s = this;
		s--;
		trans[2]=&s->vertex[i];
		trans[3]=&s->vertex[index+pps];
		e[2] = &s->left[j];
		c[2] = &s->c_left[j];
		}
	e[0] = &left[j];
	c[0] = &c_left[j];
	if(index%2) {
		e[1] = &up[BOTTOM-TOP];
		e[3] = &up[0];
		c[1] = &c_up[BOTTOM-TOP];
		c[3] = &c_up[0];
		}
	else {
		e[1] = &up[0];
		e[3] = &up[BOTTOM-TOP];
		c[1] = &c_up[0];
		c[3] = &c_up[BOTTOM-TOP];
		}
	if(index>pps) {
		j=2*(BOTTOM-TOP);
		e[3] = &up[j];
		c[3] = &c_up[j];
		}
	else if(index<=0) {
		j=2*(BOTTOM-TOP);
		e[1] = &up[j];
		c[1] = &c_up[j];
		Edge(e[1], trans[2], trans[1], c[1]);
		}
	Edge(e[0], trans[1], trans[0], c[0]);
	Edge(e[3], trans[3], trans[0], c[3]);

	int16 k, end, temp_l, temp_r, *r;
	uchar *c_l, *c_r;
	char order[4];
	SortV(order, trans);
	temp_r=order[0];
	k=trans[temp_r]->sy;
	end=trans[order[1]]->sy;
	if(k>end) return;
	temp_l = temp_r;
	r=e[temp_r];
	c_r=c[temp_r];
	k=trans[temp_r]->sy;
	if(k<TOP) k=TOP;
	int32 depth;
	if(z_buffered) {
		depth=(trans[0]->sz+trans[1]->sz
				+trans[2]->sz+trans[3]->sz)/4;
		}

	for(i=0; i<3; i++) {
		int16 *l;
		if(order[i]==temp_l) {
			temp_l = temp_l ? temp_l-1 : 3;
			l=e[temp_l];
			c_l=c[temp_l];
			}
		else {
			if(temp_r>=3) temp_r=0;
			else temp_r++;
			r=e[temp_r];
			c_r=c[temp_r];
			}
		end=trans[order[i+1]]->sy;
		if(end>BOTTOM) end=BOTTOM;
		for(; k<end; k++) {
			int16 temp;
			j=l[k];
			temp=r[k];
			if(temp>j) {
				int32 slope, re, gr, bl, Re, Gr, Bl;
				slope=(c_r[k]-c_l[k])*256/(temp-j);
				if(j<LEFT) j=LEFT;
				if(temp>RIGHT) temp=RIGHT;
				re=red[index]*c_l[k]<<8;
				gr=green[index]*c_l[k]<<8;
				bl=blue[index]*c_l[k]<<8;
				Re =red[index]*slope;
				Gr =green[index]*slope;
				Bl =blue[index]*slope;
				uint32 *bit = &bits[k*RIGHT];
				int32 *z_buff;
				if(z_buffered) z_buff = &z_buffer[k*RIGHT];
				for(; j<temp; j++) {
					if(z_buffered) {
						if(depth<=z_buff[j]) goto END;
						z_buff[j]=depth;
						}
					int32 temp3;
					uint32 temp2;
					uchar t_c;
					temp3 = re>>16;
					if(!opaque) {
						t_c = bit[j];
						temp3 *= opacity;
						temp3 += (256-opacity)*(uchar )(t_c>>8);
						temp3 >>= 8;
						}
					if(temp3>255) temp3=255;
					temp2 = temp3<<8;
					temp3 = gr>>16;
					if(!opaque) {
						temp3 *= opacity;
						temp3 += (256-opacity)*(uchar )(t_c>>16);
						temp3 >>= 8;
						}
					if(temp3>255) temp3=255;
					temp2 |= temp3<<16;
					temp3 = bl>>16;
					if(!opaque) {
						temp3 *= opacity;
						temp3 += (256-opacity)*(uchar )(t_c>>24);
						temp3 >>= 8;
						}
					if(temp3>255) temp3=255;
					temp2 |= temp3<<24;
					bit[j] = temp2;
				END:
					re+=Re;
					gr+=Gr;
					bl+=Bl;
					}
				}
			}
		}
	}

//Textured
void Section :: Draw(uint32 *bits, int16 *up, int16 *top,
		uchar *m_up, uchar *m_top, uchar index) {
	int16 i, j, *e[4];
	uchar *m[4];
	Vertex *trans[4];
	trans[0]=&vertex[index+pps];
	if(index>0) i=index+pps-1;
	else i=2*pps-1;
	trans[1]=&vertex[i];
	j = index*(BOTTOM-TOP);
	if(top) {
		trans[2]=&vertex[i-pps];
		trans[3]=&vertex[index];
		e[2]=top;
		m[2]=m_top;
		Edge(e[2], m[2], trans[2], trans[3], index, pps);
		}
	else {
		Section *s = this;
		s--;
		trans[2]=&s->vertex[i];
		trans[3]=&s->vertex[index+pps];
		e[2] = &s->left[j];
		m[2] = &s->m_left[j];
		}
	e[0] = &left[j];
	m[0] = &m_left[j];
	if(index%2) {
		e[1] = &up[BOTTOM-TOP];
		e[3] = &up[0];
		m[1] = &m_up[BOTTOM-TOP];
		m[3] = &m_up[0];
		}
	else {
		e[1] = &up[0];
		e[3] = &up[BOTTOM-TOP];
		m[1] = &m_up[0];
		m[3] = &m_up[BOTTOM-TOP];
		}
	if(index>=pps-1) {
		j=2*(BOTTOM-TOP);
		e[3] = &up[j];
		m[3] = &m_up[j];
		}
	else if(index<=0) {
		j=2*(BOTTOM-TOP);
		e[1] = &up[j];
		m[1] = &m_up[j];
		Edge(e[1], m[1], trans[2], trans[1], section, sections);
		}
	Edge(e[0], m[0], trans[1], trans[0], index, pps);
	Edge(e[3], m[3], trans[3], trans[0], section, sections);

	int16 k, end, temp_l, temp_r, *r;
	uchar *m_l, *m_r;
	int16 shade;
	char order[4];
	SortV(order, trans);
	temp_r=order[0];
	k=trans[temp_r]->sy;
	end=trans[order[1]]->sy;
	if(k>end) return;
	temp_l = temp_r;
	r=e[temp_r];
	m_r=m[temp_r];
	k=trans[temp_r]->sy;
	if(k<TOP) k=TOP;
	if(flat) shade = (trans[0]->shade+trans[1]->shade
			+trans[2]->shade+trans[3]->shade)/4;
	int32 depth;
	if(z_buffered) {
		depth=(trans[0]->sz+trans[1]->sz
				+trans[2]->sz+trans[3]->sz)/4;
		}
	for(i=0; i<3; i++) {
		int16 *l;
		uchar *m_l;
		if(order[i]==temp_l) {
			temp_l = temp_l ? temp_l-1 : 3;
			l=e[temp_l];
			m_l=m[temp_l];
			}
		else {
			if(temp_r>=3) temp_r=0;
			else temp_r++;
			r=e[temp_r];
			m_r=m[temp_r];
			}
		end=trans[order[i+1]]->sy;
		if(end>BOTTOM) end=BOTTOM;
		for(; k<end; k++) {
			int16 temp;
			j=l[k];
			temp=r[k];
			if(temp>j) {
				uint32 *bit;
				float slope_x, slope_y;
				float map_x1, map_y1, map_x2, map_y2;
				if(j<LEFT) j=LEFT;
				if(temp>RIGHT) temp=RIGHT;
				Mapping(&map_x1, &map_y1, m_l[k], temp_l, index);
				Mapping(&map_x2, &map_y2, m_r[k], temp_r, index);
				slope_x = (map_x2-map_x1)/(temp-j);
				slope_y = (map_y2-map_y1)/(temp-j);
				bit = &bits[k*RIGHT];
				int32 *z_buff;
				if(z_buffered) z_buff = &z_buffer[k*RIGHT];
				for(; j<temp; j++) {
					if(z_buffered) {
						if(depth<=z_buff[j]) goto END;
						z_buff[j]=depth;
						}
					uint16 locale, temp3;
					uint32 temp2, t_c;
					locale = (uchar )map_y1*256+(uchar )map_x1;
					if(flat) {
						temp3 = tex_r[locale]*shade;
						temp3 >>=8;
						if(!opaque) {
							t_c = bit[j];
							temp3 *= opacity;
							temp3 += (256-opacity)*(uchar )(t_c>>8);
							temp3 >>= 8;
							}
						if(temp3>255) temp3=255;
						temp2 = temp3<<8;
						temp3 = tex_g[locale]*shade;
						temp3 >>=8;
						if(!opaque) {
							temp3 *= opacity;
							temp3 += (256-opacity)*(uchar )(t_c>>16);
							temp3 >>= 8;
							}
						if(temp3>255) temp3=255;
						temp2 |= temp3<<16;
						temp3 = tex_b[locale]*shade;
						temp3 >>=8;
						if(!opaque) {
							temp3 *= opacity;
							temp3 += (256-opacity)*(uchar )(t_c>>24);
							temp3 >>= 8;
							}
						if(temp3>255) temp3=255;
						temp2 |= temp3<<24;
						}
					else {
						temp3 = tex_r[locale];
						if(!opaque) {
							t_c = bit[j];
							temp3 *= opacity;
							temp3 += (256-opacity)*(uchar )(t_c>>8);
							temp3 >>= 8;
							}
						temp2 = temp3<<8;
						temp3 = tex_g[locale];
						if(!opaque) {
							temp3 *= opacity;
							temp3 += (256-opacity)*(uchar )(t_c>>16);
							temp3 >>=8;
							}
						temp2 |= temp3<<16;
						temp3 = tex_b[locale];
						if(!opaque) {
							temp3 *= opacity;
							temp3 += (256-opacity)*(uchar )(t_c>>24);
							temp3 >>=8;
							}
						temp2 |= temp3<<24;
						}
					bit[j] = temp2;
				END:
					map_x1 += slope_x;
					map_y1 += slope_y;
					}
				}
			}
		}
	}
	
//GouradMapped
void Section :: Draw(uint32 *bits,
		int16 *up, int16 *top, uchar *m_up, uchar *m_top,
		uchar index, uchar *c_up, uchar *c_top) {
	int16 i, j, *e[4];
	uchar *c[4];
	uchar *m[4];
	Vertex *trans[4];
	trans[0]=&vertex[index+pps];
	if(index>0) i=index+pps-1;
	else i=2*pps-1;
	trans[1]=&vertex[i];
	j = index*(BOTTOM-TOP);
	if(top) {
		trans[2]=&vertex[i-pps];
		trans[3]=&vertex[index];
		e[2]=top;
		c[2]=c_top;
		m[2]=m_top;
		Edge(e[2], m[2], trans[2], trans[3], c[2], index, pps);
		}
	else {
		Section *s = this;
		s--;
		trans[2]=&s->vertex[i];
		trans[3]=&s->vertex[index+pps];
		e[2] = &s->left[j];
		c[2] = &s->c_left[j];
		m[2] = &s->m_left[j];
		}
	e[0] = &left[j];
	c[0] = &c_left[j];
	m[0] = &m_left[j];
	if(index%2) {
		e[1] = &up[BOTTOM-TOP];
		e[3] = &up[0];
		c[1] = &c_up[BOTTOM-TOP];
		c[3] = &c_up[0];
		m[1] = &m_up[BOTTOM-TOP];
		m[3] = &m_up[0];
		}
	else {
		e[1] = &up[0];
		e[3] = &up[BOTTOM-TOP];
		c[1] = &c_up[0];
		c[3] = &c_up[BOTTOM-TOP];
		m[1] = &m_up[0];
		m[3] = &m_up[BOTTOM-TOP];
		}
	if(index>pps) {
		j=2*(BOTTOM-TOP);
		e[3] = &up[j];
		c[3] = &c_up[j];
		m[3] = &m_up[j];
		}
	else if(index<=0) {
		j=2*(BOTTOM-TOP);
		e[1] = &up[j];
		c[1] = &c_up[j];
		m[1] = &m_up[j];
		Edge(e[1], m[1], trans[2], trans[1], c[1], section, sections);
		}
	Edge(e[0], m[0], trans[1], trans[0], c[0], index, pps);
	Edge(e[3], m[3], trans[3], trans[0], c[3], section, sections);

	char order[4];
	int16 k, end, temp_l, temp_r, *r;
	uchar *c_r;
	uchar *m_r;
	SortV(order, trans);
	temp_r=order[0];
	k=trans[temp_r]->sy;
	end=trans[order[1]]->sy;
	if(k>end) return;
	temp_l = temp_r;
	r=e[temp_r];
	c_r=c[temp_r];
	m_r=m[temp_r];
	k=trans[temp_r]->sy;
	if(k<TOP) k=TOP;
	int32 depth;
	if(z_buffered) {
		depth=(trans[0]->sz+trans[1]->sz
				+trans[2]->sz+trans[3]->sz)/4;
		}
	for(i=0; i<3; i++) {
		int16 *l;
		uchar *c_l;
		uchar *m_l;
		if(order[i]==temp_l) {
			temp_l = temp_l ? temp_l-1 : 3;
			l=e[temp_l];
			c_l=c[temp_l];
			m_l=m[temp_l];
			}
		else {
			if(temp_r>=3) temp_r=0;
			else temp_r++;
			r=e[temp_r];
			c_r=c[temp_r];
			m_r=m[temp_r];
			}
		end=trans[order[i+1]]->sy;
		if(end>BOTTOM) end=BOTTOM;
		for(; k<end; k++) {
			int16 temp;
			j=l[k];
			temp=r[k];
			if(temp>j) {
				uint32 temp2, *bit;
				float temp_s;
				int32 slope_mult;
				float slope_x, slope_y;
				float map_x1, map_y1, map_x2, map_y2;
				int32 slope, re, gr, bl, Re, Gr, Bl;
				if(j<LEFT) j=LEFT;
				if(temp>RIGHT) temp=RIGHT;
				Mapping(&map_x1, &map_y1, m_l[k], temp_l, index);
				Mapping(&map_x2, &map_y2, m_r[k], temp_r, index);
				slope_x = (map_x2-map_x1)/(temp-j);
				slope_y = (map_y2-map_y1)/(temp-j);
				slope=(c_r[k]-c_l[k])*256/(temp-j);
				if(bumped) {
					if(slope>256) slope_mult=0x10100*4;
					else if(slope<-256) slope_mult=-0x10100*4;
					else if(slope<0) slope_mult=-256*4+slope*256*4;
					else slope_mult=256*4+slope*256*4;
					}
				if(textured) temp_s=c_l[k]<<8;
				else {
					
					re=red[index]*c_l[k]<<8;
					gr=green[index]*c_l[k]<<8;
					bl=blue[index]*c_l[k]<<8;
					Re =red[index]*slope;
					Gr =green[index]*slope;
					Bl =blue[index]*slope;
					}
				bit = &bits[k*RIGHT];
				int32 *z_buff;
				if(z_buffered) z_buff = &z_buffer[k*RIGHT];
				for(; j<temp; j++) {
					if(z_buffered) {
						if(depth<=z_buff[j]) goto END;
						z_buff[j]=depth;
						}
					int16 prev;
					uint16 temp4;
					int32 add, temp3, t_c;
					temp4 = (uchar )map_y1*256+(uchar )map_x1;
					if(bumped) {
						if(temp4>=1) {
							prev = bump[temp4-1];
							if(temp4>=256) prev += bump[temp4-256];
							add = (bump[temp4]*2-prev)*slope_mult;
							}
						else add=0;
						}
					if(textured && bumped) {
						temp3 = tex_r[temp4]*temp_s+add;
						temp3 >>= 16;
						if(!opaque) {
							t_c = bit[j];
//							temp3 &= opacity;
//							temp3 |= (uchar )(t_c>>8) & ~opacity;
							temp3 *= opacity;
							temp3 += (256-opacity)*(uchar )(t_c>>8);
							temp3 >>= 8;
							}
						if(temp3>255) temp3=255;
						if(temp3<0) temp2=0;
						else temp2 = temp3<<8;
						temp3 = tex_g[temp4]*temp_s+add;
						temp3 >>= 16;
						if(!opaque) {
//							temp3 &= opacity;
//							opacity = ~opacity;
//							temp3 |= (uchar )(t_c>>16) & opacity;
//							opacity = ~opacity;
							temp3 *= opacity;
							temp3 += (256-opacity)*(uchar )(t_c>>16);
							temp3 >>= 8;
							}
						if(temp3>255) temp3=255;
						if(temp3>0) temp2 |= temp3<<16;
						temp3 = tex_b[temp4]*temp_s+add;
						temp3 >>= 16;
						if(!opaque) {
//							temp3 &= opacity;
//							temp3 |= (uchar )(t_c>>24) & ~opacity;
							temp3 *= opacity;
							temp3 += (256-opacity)*(uchar )(t_c>>24);
							temp3 >>= 8;
							}
						if(temp3>255) temp3=255;
						if(temp3>0) temp2 |= temp3<<24;
						temp_s += slope;
						}
					else if(textured) {
						temp3 = tex_r[temp4]*temp_s;
						temp3 >>= 16;
						if(!opaque) {
							t_c = bit[j];
//							temp3 &= opacity;
//							temp3 |= (uchar )(t_c>>8 & ~opacity);
							temp3 *= opacity;
							temp3 += (256-opacity)*(uchar )(t_c>>8);
							temp3 >>= 8;
							}
						if(temp3>255) temp3=255;
						temp2 = temp3<<8;
						temp3 = tex_g[temp4]*temp_s;
						temp3 >>= 16;
						if(!opaque) {
//							temp3 &= opacity;
//							temp3 |= (uchar )(t_c>>16 & ~opacity);
							temp3 *= opacity;
							temp3 += (256-opacity)*(uchar )(t_c>>16);
							temp3 >>= 8;
							}
						if(temp3>255) temp3=255;
						temp2 += temp3<<16;
						temp3 = tex_b[temp4]*temp_s;
						temp3 >>= 16;
						if(!opaque) {
							//temp3 &= opacity;
							//temp3 |= (uchar )(t_c>>24 & ~opacity);
							temp3 *= opacity;
							temp3 += (256-opacity)*(uchar )(t_c>>24);
							temp3 >>= 8;
							}
						if(temp3>255) temp3=255;
						temp2 += temp3<<24;
						temp_s += slope;
						}
					else {					//just bumped
						temp3 = re+add;
						temp3 >>= 16;
						if(!opaque) {
							t_c = bit[j];
							//temp3 &= opacity;
							//temp3 |= (uchar )(t_c>>8 & ~opacity);
							temp3 *= opacity;
							temp3 += (256-opacity)*(uchar )(t_c>>8);
							temp3 >>= 8;
							}
						if(temp3>255) temp3=255;
						if(temp3<0) temp2=0;
						else temp2 = temp3<<8;
						temp3 = gr+add;
						temp3 >>= 16;
						if(!opaque) {
							//temp3 &= opacity;
							//temp3 |= (uchar )(t_c>>16 & ~opacity);
							temp3 *= opacity;
							temp3 += (256-opacity)*(uchar )(t_c>>16);
							temp3 >>= 8;
							}
						if(temp3>255) temp3=255;
						if(temp3>0) temp2 |= temp3<<16;
						temp3 = bl+add;
						temp3 >>= 16;
						if(!opaque) {
//							temp3 &= opacity;
//							temp3 |= (uchar )(t_c>>24 & ~opacity);
							temp3 *= opacity;
							temp3 += (256-opacity)*(uchar )(t_c>>24);
							temp3 >>= 8;
							}
						if(temp3>255) temp3=255;
						if(temp3>0) temp2 |= temp3<<24;
						re+=Re;
						gr+=Gr;
						bl+=Bl;
						}
					bit[j] = temp2;
				END:
					map_x1 += slope_x;
					map_y1 += slope_y;
					}
				}
			}
		}
	}	
