#include "main.h"

Object :: Object(BEntry *entry, char *filename, float x, float y, float z,
		uchar opac, uint32 flags, int32 *z_buffer,
		uchar *tex=NULL, char *bump=NULL) {
	uint16 i, j;
	uint32 *color, size;
	float *pnts, *prev_p;
	a=b=c=0;
	c_up=c_top= NULL;
	m_up=m_top = NULL;
	erase.top=TOP;
	erase.bottom=BOTTOM;
	erase.left=LEFT;
	erase.right=RIGHT;
	memset(up ,0,3*(BOTTOM-TOP)*sizeof(int16));
	memset(top ,0,(BOTTOM-TOP)*sizeof(int16));
	flat=FALSE; gourad=FALSE;
	switch(flags & 0x3) {
		case 3:
			printf("not supported yet\n");
		case 2:
			if(tex || bump) {
				shader=3;
				AllocMap();
				}
			else shader=1;
			AllocCol();
			gourad=TRUE;
			break;
		case 1:
			if(bump) printf("not an option\n");
			if(tex) {
				shader=2;
				AllocMap();
				}
			else shader=0;
			flat=TRUE;
			break;
		default:
			if(bump) printf("not an option\n");
			if(tex) {
				shader=2;
				AllocMap();
				}
			else shader=0;
		}
	BEntry file_entry=*entry;
	file_entry.SetTo(filename);
	BFile file;
	uint32 value;
	if(file.SetTo(&file_entry, B_READ_ONLY) != B_NO_ERROR) return;
	uint32 magic;
	file.Read(&magic, sizeof(uint32));
	if(magic != '3db_') return;
	float version;
	file.Read(&version, sizeof(float));
	file.Read(&pps, sizeof(uint32));
	file.Read(&sections, sizeof(uint32));
	file.Read(&value, sizeof(uint32));

	color=(uint32 *)malloc(pps*sizeof(uint32));
	pnts=(float *)malloc(pps*3*sizeof(float));
	prev_p=(float *)malloc(pps*3*sizeof(float));
	section=new Section[sections];

	file.Read(prev_p, sizeof(float)*3*pps);
	for(i=0; i<pps; i++) color[i]=0xffffffff;
	for(i=0; i<sections; i++) {
		file.Read(pnts, sizeof(float)*3*pps);
		section[i].SetTo(pps, prev_p, pnts, color, i,
				sections, flat, gourad, z_buffer,
				tex, bump, opac);
		memmove(prev_p, pnts, sizeof(float)*3*pps);
		}
	file.Read(&size, sizeof(uint32));	//attrib list
	for(i=0; i<size; i++) {				//read attributes
		}
	file.Read(&value, sizeof(uint32));	//string attrib
	for(i=0; i<value; i++) {
		}
	file.Read(&children, sizeof(uint32));
	for(i=0; i<children; i++) {
		}

/*	uint32 size;
	uchar strings;
	file.Read(&size,
*/
	Move(x, y, z);
	}

Object :: ~Object() {
	if(c_up) free(c_up);
	if(c_top) free(c_top);
	if(m_up) free(m_up);
	if(m_top) free(m_top);
	}

void Object :: AllocCol() {
	if(!c_up) c_up = (uchar *)malloc(3*(BOTTOM-TOP)*sizeof(uchar));
	if(!c_top) c_top = (uchar *)malloc((BOTTOM-TOP)*sizeof(uchar));
	}

void Object :: AllocMap() {
	if(!m_up) m_up = (uchar *)malloc(3*(BOTTOM-TOP)*sizeof(uchar));
	if(!m_top) m_top = (uchar *)malloc((BOTTOM-TOP)*sizeof(uchar));
	}

void Object :: Move(float pos_x, float pos_y, float pos_z) {
	x=pos_x;
	y=pos_y;
	z=pos_z;
	}

void Object :: Dark() {
	int16 i, j;
	for(i=0; i<pps; i++) section[0].vertex[i].Dark();
	for(j=0; j<sections; j++) {
		for(i=pps; i<2*pps; i++) section[j].vertex[i].Dark();
		}
	}

void Object :: Shade(Light *l) {
	int16 i, j;
	for(i=0; i<pps; i++) section[0].vertex[i].Shade(l);
	for(j=0; j<sections; j++) {
		for(i=pps; i<2*pps; i++) section[j].vertex[i].Shade(l);
		}
	}

void Object :: Rotate(int16 a, int16 b, int16 c) {
	a=a;	b=b;	c=c;
	sin_a = sine[a];	cos_a = cosine[a];
	sin_b = sine[b];	cos_b = cosine[b];
	sin_c = sine[c];	cos_c = cosine[c];
	int16 i, j;
	for(i=0; i<pps; i++) section[0].vertex[i].Rotate(this);
	for(j=0; j<sections; j++) {
		for(i=pps; i<2*pps; i++) section[j].vertex[i].Rotate(this);
		}
	}

void Object :: Erase(uint32 *bits) {
	uint32 size;
	if(erase.top < TOP) erase.top = TOP;
	if(erase.left < LEFT) erase.left = LEFT;
	if(erase.bottom > BOTTOM) erase.bottom = BOTTOM;
	if(erase.right > RIGHT) erase.right = RIGHT;
	uint32 *b=&bits[erase.top*RIGHT+erase.left];
	size=4*(erase.right-erase.left);
	for(int16 i=erase.top; i<erase.bottom; i++) {
		memset(b, 0, size);
		b += RIGHT;
		}
	erase.left=RIGHT;
	erase.right=LEFT;
	erase.top=BOTTOM;
	erase.bottom=TOP;
	}

thread_id Object :: Draw(uint32 *bit_in) {
	bits=bit_in;
	calc_thrd=spawn_thread(CalcIn, "calculations", B_DISPLAY_PRIORITY, this);
	resume_thread(calc_thrd);
	return calc_thrd;
	}

int32 Object :: CalcIn(void *arg) {
	Object *other=(Object *)arg;
	return other->Calculate();
	}

int32 Object :: Calculate() {
	uint32 i, j;
	switch(shader) {
		case 3:		//gourad shaded texture and/or bump map
			for(i=0; i<pps; i++) section[0].Draw(bits, up, top,
					m_up, m_top, i, c_up, c_top);
			for(i=1; i<sections; i++) {
				for(j=0; j<pps; j++) section[i].Draw(bits,
						up, NULL, m_up, NULL, j, c_up, NULL);
				}
			break;
		case 2:		//flat or not shaded texture
			for(i=0; i<pps; i++) section[0].Draw(bits, up, top,
						m_up, m_top, i);
			for(i=1; i<sections; i++) {
				for(j=0; j<pps; j++) section[i].Draw(bits,
						up, NULL, m_up, NULL, j);
				}
			break;
		case 1:		//gourad shading with no texture
			for(i=0; i<pps; i++) section[0].Draw(bits,
					up, top, i, c_up, c_top);
			for(i=1; i<sections; i++) {
				for(j=0; j<pps; j++) section[i].Draw(bits,
						up, NULL, j, c_up, NULL);
				}
			break;
		default:	//draw with no shading or flat shading, no texture
			for(i=0; i<pps; i++) section[0].Draw(bits, up, top, i);
			for(i=1; i<sections; i++) {
				for(j=0; j<pps; j++) section[i].Draw(bits, up, NULL, j);
				}
		}
	return 0;
	}
