//PC main header file

#define BRect Rect;
#define BMessage char;

class Light;
class Object;
class SBuffer;

class BBitmap {
	uint32 *the_bitmap;
public:
	BBitmap(BRect, uint32, bool);
	~BBitmap();
	uint32 *Bits();
	};

class BView {
	uint16 right, bottom;
	uint32 size;
	uint32 bits;
public:
	BView(BRect, char *, uint32, uint32);
	~BView();
	DrawBitmap(BBitmap *);
	DrawBitmapAsync(BBitmap *);
	};

class BEntry {
	char filename[256];
public:
	BEntry(char *);
	~BEntry();
	void SetTo(char *);
	};

class BFile {
	FILE *file;
public:
	BFile();
	~BFile();
	uint32 SetTo(&BEntry, uint32);
	void Seek(int32, uint32);
	void Read(char *, uint32);
	};

class Win {
protected:
	BView *view;
	BBitmap *bitmap;
	double time;
private:
	uchar *tex[NUM_T_MAPS], zoom;
	char dir;
	char *bump[NUM_B_MAPS], t_bump[256*256];
	int16 a[2];
	uint32 *bits, frames;
	int32 *z_buffer;
	Rect rect;
	Light *light, *light2;
	Object *object[2];
	BEntry parent;
	SBuffer *s_buffer;
	void MakeTables();
	void GetTMaps(uint16);
	void GetBMaps(uint16);
	void Water(int16 i);
public:
	Win(BEntry, BRect);
	~Win();
	void AddChild(BView);
	void RemoveChild(BView);
	void Show();
	void Draw();
	void Lock();
	void Unlock();
	void PostMessage(BMessage *);
	};
