#ifndef MAIN_H
#define MAIN_H

#define BE_CRAP	//comment out for PC_CRAP
#ifndef BE_CRAP
	#define PC_CRAP
	#endif

#ifdef BE_CRAP
	#include <Application.h>
	#include <Window.h>
	#include <File.h>
	#include <View.h>
	#include <Bitmap.h>
	#include <math.be.h>
	#include <math.h>
	#endif

#include <malloc.h>

#define TOP 0
#define LEFT 0
#define RIGHT 320
#define BOTTOM 200
#define MID_H RIGHT/2
#define MID_V BOTTOM/2
#define EYE_DIST 256
#define NUM_T_MAPS 3
#define NUM_B_MAPS 3

#define Rand() rand()+(rand()<<8)+(rand()<<16)+(rand()<<24)
//#define Limit(x) 

//object rendering flags
enum {			//0x0 to 0x3
	NOT_SHADED,
	FLAT_SHADED,
	GOURAD_SHADED,
	PHONG_SHADED
	};

enum {
	SOLID_COLOR,
	SOLID_TEXTURE,
	FLAT_COLOR,
	FLAT_TEXTURE,
	GOURAD_COLOR,
	GOURAD_TEXTURE,
	GOURAD_BUMP,
	GOURAD_BUMP_TEXTURE
	};

typedef struct {
	int32 left, right, top, bottom;
	} Rect;

typedef struct stype {
	uint16 type;
	int16 x;
	int32 z;
	float mx, my, shade;
	stype *next;
	};

float sine[256], cosine[256];

class Light;
class Vertex;
class Section;
class Object;
class SBuffer;

#ifdef PC_CRAP
	#include "main_PC.h"
	#endif

class Vertex {
	float x, y, z;	//original coordinates
	float wx, wy, wz;	//working coordinates
	float X, Y, Z;	//original normals
	float wX, wY, wZ;	//working normals
public:
	float sx, sy;	//screen coordinates
	int16 shade;		//shade value
	int32 sz;
	Vertex();
	~Vertex();
	void Move(float *);
	void CalcNormal();
	void Rotate(Object *);
	void Dark();
	void Shade(Light *);
	};

class Section {
	bool z_buffered, flat, textured, bumped, opaque;
	char *bump;
	uchar *red, *green, *blue, *tex_r, *tex_g, *tex_b, opacity, pps;
	int16 *left;
	uint16 section, sections;
	int32 *z_buffer;
	uchar *m_left;
	uchar *c_left;
	void AllocCol();
	void AllocMap();
	void SortV(char *, Vertex **);
	void Mapping(float *, float *, uchar, char, uchar);
	void Edge(int16 *, Vertex *, Vertex *);
	void Edge(int16 *, Vertex *, Vertex *, uchar *);
	void Edge(int16 *, uchar *, Vertex *, Vertex *, uint16, uint16);
	void Edge(int16 *, uchar *, Vertex *, Vertex *, uchar *, uint16, uint16);
public:
	Vertex *vertex;
	Section();
	Section(float *, float *, uint32 *, uint16, uint16,
			bool, bool, int32 *, uchar *, char *, uchar);
	~Section();
	void SetTo(uchar, float *, float *, uint32 *, uint16, uint16,
			bool, bool, int32 *, uchar *, char *, uchar);
	void Draw(uint32 *, int16 *, int16 *, uchar);
	void Draw(uint32 *, int16 *, int16 *, uchar, uchar *, uchar *);
	void Draw(uint32 *, int16 *, int16 *, uchar *, uchar *, uchar);
	void Draw(uint32 *, int16 *, int16 *,
			uchar *, uchar *, uchar, uchar *, uchar *);
	};

class Object {
	uchar shader;
	uint32 pps;
	uint32 sections;
	uint32 children;
	Section *section;
	int16 a, b, c;	//angle
	int16 up[3*(BOTTOM-TOP)], top[BOTTOM-TOP];
	uchar *m_up, *m_top;
	uchar *c_up, *c_top;
	thread_id calc_thrd;
	Object *child;
	static long CalcIn(void *);
	void AllocCol();
	void AllocMap();
public:
	bool flat, gourad;
	uint32 *bits, *tex, *bump;
	float x, y, z, wx, wy, wz;
	float sin_a, cos_a, sin_b, cos_b, sin_c, cos_c;
	Rect erase;
	Object(BEntry *, char *, float, float, float,
			uchar, uint32, int32 *, uchar *, char *);
	~Object();
	void Move(float, float, float);
	void Dark();
	void Shade(Light *);
	void Erase(uint32 *);
	void Rotate(int16, int16, int16);
	thread_id Draw(uint32 *);
	int32 Calculate();
	};

class Light {
	float x, y, z;
public:
	uchar intensity, ambient;
	int16 a, b, c;
	float wx, wy, wz;
	float sin_a, sin_b, sin_c, cos_a, cos_b, cos_c;
	Light(uchar, uchar, float, float, float);
	~Light();
	void Move(float, float, float);
	void Rotate(int16, int16, int16);
	};

class SBuffer {
	stype *sform;
	uint16 segment, max_seg;
	sem_id mem_lock;
	int16 Alloc(uint16);
	uint16 Search(int16, uint16, uint16);
public:
	SBuffer();
	~SBuffer();
	void Insert(int16, int16, int32, int32, float, float, float, float,
			uchar, uchar, uchar, float, float);
	void Clear();
	void Draw(uint32);
	};

class Win : public BWindow {
protected:
	BView *view;
	BBitmap *bitmap;
	double time;
private:
	uchar *tex[NUM_T_MAPS], zoom;
	char dir;
	char *bump[NUM_B_MAPS], t_bump[256*256];
	int16 a[2];
	uint32 *bits, frames;
	int32 *z_buffer;
	Rect rect;
	Light *light, *light2;
	Object *object[2];
	BEntry parent;
	SBuffer *s_buffer;
	void MakeTables();
	void GetTMaps(uint16);
	void GetBMaps(uint16);
	void Water(int16 i);
public:
	Win(BEntry, BRect);
	~Win();
	void Draw();
#ifdef BE_CRAP
	virtual void MessageReceived(BMessage *);
	virtual bool QuitRequested();
#endif
	};

#ifdef BE_CRAP
class App : public BApplication {
protected:
	Win *win;
public:
	App();
	~App();
	virtual void ReadyToRun();
	};
#endif

#endif
