#include "main.h"

Light :: Light(uchar inten, uchar amb,
		float xlen, float ylen, float zlen) {
	a=b=c=0;
	intensity=inten;	//255 is max intensity
						//0 is min
	ambient=amb;		//255 is max light
						//0 is min
	Move(xlen, ylen, zlen);
	}

Light :: ~Light() {
	}

void Light :: Move(float xlen, float ylen, float zlen) {
	float length;
	length = sqrt(xlen*xlen + ylen*ylen + zlen*zlen);
	x = xlen/length;
	y = ylen/length;
	z = zlen/length;
	}

void Light :: Rotate(int16 a1, int16 b1, int16 c1) {
	a+=a1;	b+=b1;	c+=c1;
	while(a<0) a+=256;
	while(a>=256) a-=256;
	while(b<0) b+=256;
	while(b>=256) b-=256;
	while(c<0) c+=256;
	while(c>=256) c-=256;
	sin_a = sine[a];	cos_a = cosine[a];
	sin_b = sine[b];	cos_b = cosine[b];
	sin_c = sine[c];	cos_c = cosine[c];
	wz = y*cos_a - z*sin_a;
	wy = y*sin_a + z*cos_a;
	wx = x*cos_b - wz*sin_b;
	wz = -x*sin_b - wz*cos_b;
	float temp = wy*sin_c - wx*cos_c;
	wy = wy*cos_c - wx*sin_c;
	wx = temp;
	}
