#include "main.h"

extern int getopt (int argc, char *const *argv, const char *shortopts);

App :: App(char *path) : BApplication("application/x-joe.3DConvert") {
	uint32 value;
	float *buffer;
	entry_ref ref;

	poly_type=VERTEX_4;
	faces = 0;
	filename=(char *)malloc(strlen(path));
	out=(char *)malloc(strlen(path)+3);
	strcpy(filename, path);
	strcpy(out, filename);
	strcat(out, ".3db");
	get_ref_for_path(filename, &ref);
	entry.SetTo(&ref);
	entry.GetParent(&dir);
	BFile output;
	printf("Creating %s\n", out);
	dir.CreateFile(out, &output, false);

//file conversion here
	ReadFile();
	printf("done\n");
	PostMessage(B_QUIT_REQUESTED);
	}

App :: ~App() {
	free(filename);
	free(out);
	free(face);
	}

int16 App :: ReadFile() {
	char string[256];
	float f=0;
	int32 i;
	file=fopen(filename, "r");
	do {
		fscanf(file, "%s", string);
		i=strcmp("_3db", string);
		} while(i);
	magic = '3db_';
	output.SetTo(&dir, out, B_READ_WRITE);
	output.Write(&magic, sizeof(uint32));
	fscanf(file, "%f", &f);		//version number
	output.Write(&f, sizeof(float));
printf("%f",f);
	do {
		fscanf(file, "%s", string);
		i=strcmp("_pps", string);
		} while(i);
	fscanf(file, "%d", &i);
	pps = i;
	output.Write(&pps, sizeof(uint32));
	do {
		fscanf(file, "%s", string);
		i=strcmp("_sections", string);
		} while(i);
	fscanf(file, "%d", &i);
	sections = i;
	output.Write(&sections, sizeof(uint32));
	do {
		fscanf(file, "%s", string);
		i=strcmp("_coords", string);
		} while(i);
	fscanf(file, "%d", &i);		//vertecies per polygon
	output.Write(&i, sizeof(uint32));
	for(i=0; i<pps*(sections+1); i++) {
		fscanf(file, "%s", string);
		fscanf(file, "%f", &f);
		coords[0]=f;
		fscanf(file, "%f", &f);
		coords[1]=f;
		fscanf(file, "%f", &f);
		coords[2]=f;
		output.Write(coords, 3*sizeof(float));
		}
	uint32 j=0;
	do {
		fscanf(file, "%s", string);
		i=strcmp("_attributes", string);
		} while(i);
	fscanf(file, "%d", &i);
	output.Write(&j, sizeof(uint32));	//attrib length
/*	for(i=0; i<0; i++) {
		for(i=0; i<pps*(sections+1); i++) {	//texture x, y
			output.Write(&j, sizeof(uint32));
			}
		j=0xffffffff;
		for(i=0; i<pps*(sections+1); i++) {
			output.Write(&j, sizeof(uint32));	//rgbalpha
			}
		}
*/	j=0;
	output.Write(&j, sizeof(uint32));	//strings
	output.Write(&j, sizeof(uint32));	//children
	fclose(file);
	}

int16 App :: ReadFace() {
	int16 result = 0;
	int32 type, color;
	float coord;
	Face *f = &face[faces];
	f = NULL;
	f = (Face *)malloc(sizeof(Face));
	if(!f) {
		printf("could not allocate memory\n");
		return -1;
		}
	if(ReadGroup(&coord, &color) != 4) return -1;	//name
	if(ReadGroup(&coord, &color) != 2) return -1;	//color
	f->color = color;
	for(int16 i=0; i<4; i++) {
		for(int16 j=0; j<3; j++) {
			result = ReadGroup(&coord, &color);			//color
			if(result==-2 && i>=3) {
				poly_type = VERTEX_3;
				printf("error\n");
				f->vertex[i] = f->vertex[i-1];
				goto END;
				}
			else if(result != 1) return -1;
			f->vertex[i].coord[j] = coord;
			}
		}
END:
	faces++;
	}

int16 App :: ReadGroup(float *result, int32 *color) {
	int32 type=0;
	if(fscanf(file, "%d\n", &type) == EOF) {
		printf("no data\n");
		return -1;
		}
	if(type>=10 && type<=59) {
		fscanf(file, "%f\n", result);
		return 1;
		}
	if(type>=60 && type<=79) {
		fscanf(file, "%d\n", color);
		return 2;
		}
	if(type>=210 && type<=239) {
		double temp=NULL;
		fscanf(file, "%f\n", temp);
		return 3;
		}
	if(type==8) {
		char st[256];
		fscanf(file, "%s\n", st);		//face name;
		return 4;
		}
	return -2;
	}
