/*
	
	GraphicWindow.cpp
	
	Copyright 1997 Dirk Steins
	
*/

#ifndef _APPLICATION_H
#include <Application.h>
#endif

#ifndef BENCH_GRAPH_H
#include "GraphicWindow.h"
#endif

#include "BenchGlobal.h"
#include "colors.h"


GraphicWindow::GraphicWindow(BRect frame, BWindow* parent)
				: BWindow(frame, "Graphic Test", B_TITLED_WINDOW, 
				  B_NOT_CLOSABLE | B_NOT_RESIZABLE | B_NOT_MINIMIZABLE | B_NOT_ZOOMABLE)
{
	mParent = parent;
}

GraphicWindow::~GraphicWindow()
{
}

void GraphicWindow::RunBench (GfxBench* theBench, int bench, float& result)
{
	switch (bench)
	{
		case X_BEN_BLITSS:
			result = theBench->RunBitBlitSS();
			break;
		case X_BEN_BLITMS:
			result = theBench->RunBitBlitMS();
			break;	
		case X_BEN_FILLRC:
			result = theBench->RunFillRect();
			break;
		case X_BEN_PATTFL:
			result = theBench->RunPattFill();
			break;
		case X_BEN_VLINES:
			result = theBench->RunVlines();
			break;
		case X_BEN_HLINES:
			result = theBench->RunHlines();
			break;
		case X_BEN_DLINES:
			result = theBench->RunDlines();
			break;
		case X_BEN_VLINAR:
			result = theBench->RunVlineArray();
			break;
		case X_BEN_HLINAR:
			result = theBench->RunHlineArray();
			break;
		case X_BEN_DLINAR:
			result = theBench->RunDlineArray();
			break;
		case X_BEN_TEXTER:
			result = theBench->RunTextRender();
			break;
		default:
			break;
	}
} 

long GraphicWindow::BenchRunner(void	*data)
{
	float result;
	GraphicWindow*	thisWdw;
	GfxBench*	theBench;

	thisWdw = (GraphicWindow*) data;
	theBench = new GfxBench (thisWdw->mView);
	
	// Lock window
	thisWdw->Lock();
	
	if (thisWdw->mBench == X_BEN_RUNALL)
	{
		for (thisWdw->mBench = X_BEN_BLITSS; thisWdw->mBench <= X_BEN_TEXTER; thisWdw->mBench++)
		{
			thisWdw->SetBenchTitle();
			thisWdw->RunBench (theBench, thisWdw->mBench, result);
			
			// Post result
			BMessage* msg = new BMessage;
			
			msg->what = X_BEN_RESULT;
			msg->AddLong ("bench", thisWdw->mBench);
			msg->AddFloat ("bres", result);
			
			thisWdw->mParent->PostMessage (msg);
						
			snooze (5e5);
		}
	}
	else
	{
		thisWdw->RunBench (theBench, thisWdw->mBench, result);

		// Post result
		BMessage* msg = new BMessage;
		
		msg->what = X_BEN_RESULT;
		msg->AddLong ("bench", thisWdw->mBench);
		msg->AddFloat ("bres", result);
		
		thisWdw->mParent->PostMessage (msg);
		
	}
	
	
	// delete benchmark object
	delete theBench;
	
	thisWdw->PostMessage (B_QUIT_REQUESTED);

	// Unlock 
	thisWdw->Unlock();
}

void GraphicWindow::SetBenchTitle()
{
	char*	title;
	
	switch (mBench)
	{
		case X_BEN_BLITSS:
			title = "Running BitBlit S->S copy";
			break;
		case X_BEN_BLITMS:
			title = "Running BitBlit M->S copy";
			break;	
		case X_BEN_FILLRC:
			title = "Running filled rectangles";
			break;
		case X_BEN_PATTFL:
			title = "Running pattern fill";
			break;
		case X_BEN_VLINES:
			title = "Running vertical lines";
			break;
		case X_BEN_HLINES:
			title = "Running horizontal lines";
			break;
		case X_BEN_DLINES:
			title = "Running diagonal lines";
			break;
		case X_BEN_VLINAR:
			title = "Running vertical line array";
			break;
		case X_BEN_HLINAR:
			title = "Running horizontal line array";
			break;
		case X_BEN_DLINAR:
			title = "Running diagonal line array";
			break;
		case X_BEN_TEXTER:
			title = "Running text render";
			break;
		default:
			title = "Graphic benchmark";
			break;
	}
	
	SetTitle (title);
}

bool GraphicWindow::StartBench(BView* view)
{
	// Set window title 
	SetBenchTitle();
	
	mView = view;
	if ((mBenchSem = create_sem(1, "mBenchSem")) < B_NO_ERROR)
	{
		// unable to create semaphore
		return false;
	}
	mBenchThread = spawn_thread(BenchRunner, "mBenchThread", 
							    B_DISPLAY_PRIORITY, this);
	if (mBenchThread < B_NO_ERROR)
	{
		// delete semaphore
		delete_sem(mBenchSem);
		return false;
	}
	resume_thread(mBenchThread);
	return true;
}

bool GraphicWindow::QuitRequested()
{
	acquire_sem(mBenchSem);
	delete_sem(mBenchSem);
	
	long value = 0;
	kill_thread (mBenchThread);
	wait_for_thread(mBenchThread, &value);
	
	mBenchSem = -1;
	mBenchThread = -1;

	return(true);
}

void GraphicWindow::MessageReceived(
	BMessage	*inMessage)
{
	switch (inMessage->what) {
		default:
			BWindow::MessageReceived(inMessage);
			break;
		case X_BEN_START:
			// Find parameter 
			mBench = inMessage->FindLong ("bench", 0);
			if (inMessage->Error () != B_NO_ERROR)
			{
				break;
			}
			mView = (BView*) inMessage->FindObject ("bview", 0);
			if ((mView != NULL) && (inMessage->Error() == B_NO_ERROR))
			{
				// Start bench
				if (!StartBench (mView))
				{
					BAlert* alt = new BAlert (B_EMPTY_STRING,
							   "Unable to spawn thread for Bench",
							   "OK");
					alt->Go();
					Quit();
				}
			}
			break;
	}
}
