/*
	
	GraphicView.cpp
	
	Copyright 1997 Dirk Steins, All Rights Reserved.
	
*/

#ifndef GRAPH_VIEW_H
#include "GraphicView.h"
#endif

#ifndef BENCH_GRAPH_H
#include "GraphicWindow.h"
#endif

#include "colors.h"
#include "BenchGlobal.h"



GraphicView::GraphicView(BRect rect, char *name, long bench)
	   	   : BView(rect, name, B_FOLLOW_ALL, B_WILL_DRAW  )
{
	mBench = bench;
}

void GraphicView::AttachedToWindow()
{
	BMessage	*msg = new BMessage;
	
	msg->what = X_BEN_START;
	msg->AddLong ("bench", mBench);
	msg->AddObject ("bview", this);
	Window()->PostMessage (msg);

	SetLowColor (black);
}
