//*****************************************************************************
//
//	File:		 GfxWindow.h
//
//	Description: WindowScreen class for BeBench.
//
//  bases on Domino from Be
//
//	Copyright 1997, Dirk Steins
//
//*****************************************************************************

#ifndef __GfxWindow
#define __GfxWindow

#ifndef _WINDOW_SCREEN_H
#include <WindowScreen.h>
#endif
#ifndef _OS_H
#include <OS.h>
#endif

// Type definition for the graphics hooks.
typedef long     (*BLIT)(long,long,long,long,long,long);
typedef long 	 (*LINE8)(long, long, long, long, uchar, bool, short, short, short, short);
typedef long 	 (*LINE32)(long, long, long, long, ulong, bool, short, short, short, short);
typedef long	 (*RECT8)(long, long, long, long, uchar);
typedef long	 (*RECT32)(long, long, long, long, ulong);
typedef long	 (*ARRAY8)(indexed_color_line*, long, bool, short, short, short, short);
typedef long	 (*ARRAY32)(rgb_color_line*, long, bool, short, short, short, short);
typedef long 	 (*SYNC)();

class GfxWindow : public BWindowScreen {
public:
					GfxWindow (long bench, BWindow* parent, 
							   long space, char *name);
virtual void        Quit();
virtual	void		ScreenConnected(bool active);
thread_id           draw;
static long 		BenchRunner(void	*data);
private:

void RunBench (int bench, float& result);
bool CheckRunTime (double test_time, long &runs, long &runs_10);

	// bench methods
float RunVlines();
float RunHlines();
float RunDlines();
float RunFillRect();
float RunBitBlitSS();
float RunHlineArray();
float RunVlineArray();
float RunDlineArray();
	
	// "view" methods
void				StrokeLine (BPoint from, BPoint to);
void				StrokeLine8 (BPoint from, BPoint to);
void				StrokeLine32 (BPoint from, BPoint to);
void				FillRect (BRect rect);
void				FillRect8 (BRect rect);
void				FillRect32 (BRect rect);
void				BeginLineArray (long count);
void				AddLine (BPoint from, BPoint to, rgb_color color);
void				EndLineArray ();
void				SetHighColor (rgb_color color);
void				CopyBits (BRect source, BRect dest);
void				Sync ();

	int			mDepth;		// bit depth of frame buffer
	BWindow*	mParent;	// parent window
	long		mBench;		// current benchmark
	
	rgb_color*		color_list;	// array of cycle colors

	// "view" variables 
	rgb_color			mHighColor;
	indexed_color_line	*mIdxColArray;
	rgb_color_line		*mColArray;
	long	mIdxNum;		// number of entries in line array
	long	mLaIdx;			// current idx in line array
	BRect	bounds;
	
	// graphic card hooks
	BLIT	blit_jmp;
	LINE8	line_8;
	LINE32	line_32;
	RECT8	rect_8;
	RECT32	rect_32;
	ARRAY8	line_array_8;
	ARRAY32	line_array_32;
	SYNC	sync;
};

// Global Variables

extern 	int       drawing_enabled;
extern 	int       kill_play;
extern	int       page_num;
extern	sem_id    lock;
extern	sem_id    ender;
extern	GfxWindow *window;

extern  long     row;
extern  BRect	 gBounds;

extern  uchar    *draw_base;


#endif
