/*
	
	GfxBench.h
	
	core graphic benchmark routines
	
	Copyright 1997 Dirk Steins
	
*/

#ifndef _GFX_BENCH_H
#define _GFX_BENCH_H

#define MAX_COLS		240		/* colors in color list. */ 

#define BLIT_X 303 // not giving any special treatment to even numbered bitblits...
#define BLIT_Y 303

class GfxBench : public BObject
{
public:
	GfxBench(BView* view);
	~GfxBench(void);
	
float RunVlines();
float RunHlines();
float RunDlines();
float RunFillRect();
float RunPattFill();
float RunBitBlitSS();
float RunBitBlitMS();
float RunTextRender();
float RunHlineArray();
float RunVlineArray();
float RunDlineArray();

private:
bool CheckRunTime (double test_time, long &runs, long &runs_10);
void Sync();

	rgb_color*		color_list;	// array of cycle colors
	
	BView*			mView;
	int				syncMode;
};

#endif
