/*
	
	BenchWindow.cpp
	
	Copyright 1997 Dirk Steins
	
*/

#ifndef _APPLICATION_H
#include <Application.h>
#endif

#ifndef BENCH_WINDOW_H
#include "BenchWindow.h"
#endif

#ifndef BENCH_VIEW_H
#include "BenchView.h"
#endif

#ifndef BENCH_GRAPH_H
#include "GraphicWindow.h"
#endif

#ifndef GRAPH_VIEW_H
#include "GraphicView.h"
#endif

#ifndef __GfxWindow
#include "GfxWindow.h"
#endif

#include "BenchGlobal.h"


BenchWindow::BenchWindow(BRect frame)
				: BWindow(frame, "Bench", B_TITLED_WINDOW, 0)
{
	float		height;
	BMenu		*menu;
	BMenuBar	*menu_bar;
	BMenuItem	*item;
	BRect		r;
	BRect		aRect;
	
	bRunAllMode = false;

	r.Set(0, 0, 32767, 15);
	menu_bar = new BMenuBar(r, "");
	menu = new BMenu("File");

	menu->AddItem(new BMenuItem("Save result as...",
					new BMessage(M_BEN_SAVE), NULL));
	menu->AddItem(new BMenuItem("Copy result",
					new BMessage(B_COPY), 'C'));

	menu_bar->AddItem (menu);
	menu = new BMenu("Graphics");

	menu->AddItem(new BMenuItem("BitBlit S->S copy",
					new BMessage(M_BEN_BLITSS), 'S'));
	menu->AddItem(new BMenuItem("BitBlit M->S copy",
					new BMessage(M_BEN_BLITMS), 'M'));
	menu->AddItem(new BMenuItem("Filled Rect",
					new BMessage(M_BEN_FILLRC), 'F'));
	menu->AddItem(new BMenuItem("Pattern Fill",
					new BMessage(M_BEN_PATTRC), 'P'));
	menu->AddItem(new BMenuItem("Vertical Lines",
					new BMessage(M_BEN_VLINES), 'V'));
	menu->AddItem(new BMenuItem("Horizontal Lines",
					new BMessage(M_BEN_HLINES), 'H'));
	menu->AddItem(new BMenuItem("Diagonal Lines",
					new BMessage(M_BEN_DLINES), 'D'));
	menu->AddItem(new BMenuItem("Vertical Line Array",
					new BMessage(M_BEN_VLINAR), '1'));
	menu->AddItem(new BMenuItem("Horizontal Line Array",
					new BMessage(M_BEN_HLINAR), '2'));
	menu->AddItem(new BMenuItem("Diagonal Line Array",
					new BMessage(M_BEN_DLINAR), '3'));
	menu->AddItem(new BMenuItem("Text Render",
					new BMessage(M_BEN_TEXTER), 'T'));
	menu->AddSeparatorItem();
	menu->AddItem(new BMenuItem("All Tests",
					new BMessage(M_BEN_RUNALL), 'A'));

	menu_bar->AddItem(menu);

	menu = new BMenu("WindowScreen");

	menu->AddItem(new BMenuItem("BitBlit S->S copy",
					new BMessage(M_BEN_WBLITSS), 'S', B_SHIFT_KEY));
	menu->AddItem(new BMenuItem("Filled Rect",
					new BMessage(M_BEN_WFILLRC), 'F', B_SHIFT_KEY));
	menu->AddItem(new BMenuItem("Vertical Lines",
					new BMessage(M_BEN_WVLINES), 'V', B_SHIFT_KEY));
	menu->AddItem(new BMenuItem("Horizontal Lines",
					new BMessage(M_BEN_WHLINES), 'H', B_SHIFT_KEY));
	menu->AddItem(new BMenuItem("Diagonal Lines",
					new BMessage(M_BEN_WDLINES), 'D', B_SHIFT_KEY));
	menu->AddItem(new BMenuItem("Vertical Line Array",
					new BMessage(M_BEN_WVLINAR), '1', B_SHIFT_KEY));
	menu->AddItem(new BMenuItem("Horizontal Line Array",
					new BMessage(M_BEN_WHLINAR), '2', B_SHIFT_KEY));
	menu->AddItem(new BMenuItem("Diagonal Line Array",
					new BMessage(M_BEN_WDLINAR), '3', B_SHIFT_KEY));
	menu->AddSeparatorItem();
	menu->AddItem(new BMenuItem("All Tests",
					new BMessage(M_BEN_WRUNALL), 'A', B_SHIFT_KEY));
	
	menu_bar->AddItem(menu);

	Lock();
	AddChild (menu_bar);
	height = menu_bar->Bounds().bottom + 1;

	// set up a rectangle and instantiate a new view
	// view rect should be same size as window rect but with left top at (0, 0)
	aRect = Frame();
	aRect.OffsetTo(B_ORIGIN);
	aRect.top = height;
	mView = new BenchView(aRect, "BenchView", &mBenchRes);

	// add view to window
	AddChild(mView);
	
	mView->MakeFocus (true);
	Unlock();
}

bool BenchWindow::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(TRUE);
}

void BenchWindow::MessageReceived(BMessage	*inMessage)
{
	switch (inMessage->what) {
		default:
			inherited::MessageReceived(inMessage);
			break;
		case B_COPY:
			{
				long	start, end;
				Lock();
				mView->GetSelection (&start, &end);
				if (start == end)
				{
					mView->SelectAll();
				}
				mView->Copy(be_clipboard);
				if (start == end)
				{
					mView->Select (start, end);
				}
				Unlock();
			}
			break;
		case M_BEN_SAVE:
			RunSavePanel ("BeBenchResult");
			break;		
		case M_BEN_BLITSS:
			ExecuteBench (X_BEN_BLITSS);
			break;
		case M_BEN_BLITMS:
			ExecuteBench (X_BEN_BLITMS);
			break;
		case M_BEN_FILLRC:
			ExecuteBench (X_BEN_FILLRC);
			break;
		case M_BEN_PATTRC:
			ExecuteBench (X_BEN_PATTFL);
			break;
		case M_BEN_VLINES:
			ExecuteBench (X_BEN_VLINES);
			break;
		case M_BEN_HLINES:
			ExecuteBench (X_BEN_HLINES);
			break;
		case M_BEN_DLINES:
			ExecuteBench (X_BEN_DLINES);
			break;
		case M_BEN_VLINAR:
			ExecuteBench (X_BEN_VLINAR);
			break;
		case M_BEN_HLINAR:
			ExecuteBench (X_BEN_HLINAR);
			break;
		case M_BEN_DLINAR:
			ExecuteBench (X_BEN_DLINAR);
			break;
		case M_BEN_TEXTER:
			ExecuteBench (X_BEN_TEXTER);
			break;
		case M_BEN_RUNALL:
			ExecuteBench (X_BEN_RUNALL);
			/*
			bRunAllMode = true;
			ExecuteBench (X_BEN_BLITSS);
			*/
			break;
		case M_BEN_WBLITSS:
			ExecuteScreenBench (X_BEN_WBLITSS);
			break;
		case M_BEN_WVLINES:
			ExecuteScreenBench (X_BEN_WVLINES);
			break;
		case M_BEN_WHLINES:
			ExecuteScreenBench (X_BEN_WHLINES);
			break;
		case M_BEN_WDLINES:
			ExecuteScreenBench (X_BEN_WDLINES);
			break;
		case M_BEN_WFILLRC:
			ExecuteScreenBench (X_BEN_WFILLRC);
			break;
		case M_BEN_WVLINAR:
			ExecuteScreenBench (X_BEN_WVLINAR);
			break;
		case M_BEN_WHLINAR:
			ExecuteScreenBench (X_BEN_WHLINAR);
			break;
		case M_BEN_WDLINAR:
			ExecuteScreenBench (X_BEN_WDLINAR);
			break;
		case M_BEN_WRUNALL:
			ExecuteScreenBench (X_BEN_RUNALL);

		case X_BEN_RESULT:
			float res = inMessage->FindFloat ("bres", 0);
			if (inMessage->Error() != B_NO_ERROR)
			{
				break;
			}
			long ben = inMessage->FindLong ("bench", 0);
			if (inMessage->Error() != B_NO_ERROR)
			{
				break;
			}
			UpdateResult (ben, res);
			UpdateIfNeeded();
			if ((bRunAllMode == true) && (ben < X_BEN_TEXTER))
			{
				ben += 1;
				snooze (5e5);
				ExecuteBench (ben);
			}
			if (ben >= X_BEN_TEXTER)
			{
				bRunAllMode = false;
			}
			break;
	}
}

void BenchWindow::UpdateResult (long bench, float result)
{
	switch (bench)
	{
		case X_BEN_BLITSS:
			mBenchRes.blitSS = result;
			break;
		case X_BEN_BLITMS:
			mBenchRes.blitMS = result;
			break;	
		case X_BEN_FILLRC:
			mBenchRes.filledRect = result;
			break;
		case X_BEN_PATTFL:
			mBenchRes.pattFill = result;
			break;
		case X_BEN_VLINES:
			mBenchRes.vertLines = result;
			break;
		case X_BEN_HLINES:
			mBenchRes.horLines = result;
			break;
		case X_BEN_DLINES:
			mBenchRes.diagLines = result;
			break;
		case X_BEN_VLINAR:
			mBenchRes.vertLineAr = result;
			break;
		case X_BEN_HLINAR:
			mBenchRes.horLineAr = result;
			break;
		case X_BEN_DLINAR:
			mBenchRes.diagLineAr = result;
			break;
		case X_BEN_TEXTER:
			mBenchRes.textRender = result;
			break;
		case X_BEN_WBLITSS:
			mBenchRes.wBlit = result;
			break;
		case X_BEN_WFILLRC:
			mBenchRes.wFilledRect = result;
			break;
		case X_BEN_WVLINES:
			mBenchRes.wVertLines = result;
			break;
		case X_BEN_WHLINES:
			mBenchRes.wHorLines = result;
			break;
		case X_BEN_WDLINES:
			mBenchRes.wDiagLines = result;
			break;
		case X_BEN_WVLINAR:
			mBenchRes.wVertLineAr = result;
			break;
		case X_BEN_WHLINAR:
			mBenchRes.wHorLineAr = result;
			break;
		case X_BEN_WDLINAR:
			mBenchRes.wDiagLineAr = result;
			break;
		default:
			break;
	}
	mView->Update();
}

void BenchWindow::ExecuteBench (long bench)
{
	GraphicWindow*	gWdw;
	GraphicView*	gView;
	
	BRect			aRect;

	// set up a rectangle and instantiate a new window
	aRect.Set(30, 30, 630, 430);
	gWdw = new GraphicWindow(aRect, this);
	
	// set up a rectangle and instantiate a new view
	// view rect should be same size as window rect but with left top at (0, 0)
	aRect.OffsetTo(B_ORIGIN);
	gView = new GraphicView(aRect, "GraphicView", bench);
	
	// add view to window
	gWdw->AddChild(gView);
	
	// make window visible
	gWdw->Show();
}

void BenchWindow::ExecuteScreenBench (long bench)
{
	GfxWindow*		gWdw;
	long			lSpace;
	BRect			aRect;
	screen_info screeninfo;
	
	get_screen_info (&screeninfo);
	
	lSpace = (screeninfo.mode==B_COLOR_8_BIT)?B_8_BIT_640x480:B_32_BIT_640x480;

	// set up a rectangle and instantiate a new window
	gWdw = new GfxWindow(bench, this, lSpace, "Gfx Bench screen");
}

void BenchWindow::ScreenChanged (BRect frame, color_space mode)
{
	// Update view
	mView->Update();
	inherited::ScreenChanged (frame, mode);
}

void BenchWindow::SaveRequested (record_ref directory, const char *filename)
{
	long	result;
	BDirectory	dir;
	BFile		file;

	dir.SetRef(directory);
	if ((result = dir.Create(filename, &file)) == B_NO_ERROR) {
		file.Open(B_READ_WRITE);
		if ((result = file.Error()) == B_NO_ERROR) {
	
			file.Write(mView->Text(),
					   mView->TextLength());

			result = file.Error();
			file.Close();
			file.SetTypeAndApp('TEXT', 'EDIT');
		}
	}
	if (result != B_NO_ERROR) {
		char	str[255];
		sprintf(str, "An error occurred trying to save %s (0x%.8x).", filename,
																	  result);
		beep();
		(new BAlert("", str, "OK"))->Go();
	}
	else
	{
		CloseSavePanel();
	}
}
