/*
	
	BenchView.cpp
	
	Copyright 1997 Dirk Steins, All Rights Reserved.
	
*/
#ifndef BENCH_VIEW_H
#include "BenchView.h"
#endif

#include "BenchGlobal.h"

BenchView::BenchView(BRect rect, char *name, TBenchRes* tRes)
	   	   : BTextView(rect, name, rect, B_FOLLOW_ALL, B_WILL_DRAW)
{
	benchRes = tRes;
	tRes->blitSS = 0.0;
	tRes->blitMS = 0.0;
	tRes->filledRect = 0.0;
	tRes->pattFill = 0.0;
	tRes->vertLines = 0.0;
	tRes->horLines = 0.0;
	tRes->diagLines = 0.0;
	tRes->vertLineAr = 0.0;
	tRes->horLineAr = 0.0;
	tRes->diagLineAr = 0.0;
	tRes->textRender = 0.0;
	// window screen results
	tRes->wBlit = 0.0;
	tRes->wFilledRect = 0.0;
	tRes->wVertLines = 0.0;
	tRes->wHorLines = 0.0;
	tRes->wDiagLines = 0.0;
	tRes->wVertLineAr = 0.0;
	tRes->wHorLineAr = 0.0;
	tRes->wDiagLineAr = 0.0;
}


void BenchView::Update()
{
	char* 	buffer;
	long	length;
	
	// build initial stats
	BuildStats (&buffer, length);
	
	// Set buffer in view
	SetText (buffer, length);
	
	if (buffer != NULL)
		free (buffer);

	// Invalidate this view	
	Invalidate();
}

void BenchView::AttachedToWindow()
{
	char* 	buffer;
	long	length;
	
	// build initial stats
	BuildStats (&buffer, length);
	
	// Set buffer in view
	SetText (buffer, length);
	
	if (buffer != NULL)
		free (buffer);

	SetFontName("Kate");
	SetFontSize(12);
	
	// disable editing
	MakeEditable (false);
}

void BenchView::BuildStats (char** buffer, long& length)
{
	// buffer for formatValue
	char	fBuf[80];
	char	*tmp, *newBuf;
	system_info	sysinfo;
	screen_info screeninfo;
	
	get_system_info (&sysinfo);
	get_screen_info (&screeninfo);
	// the buffer will not get longer
	tmp = (char*) malloc (65536);
	newBuf = tmp;
	newBuf += sprintf (newBuf, " System info\n"
					 "   BeBench version       :         %s \n" 
					 "   CPU type              :         %s \n" 
					 "   CPU count             :         %d \n" 
					 "   CPU clock speed       :         %-3d    MHz\n",
					 BENCH_VERSION ", " BENCH_DATE,
					 Cpu2String(fBuf, sysinfo.cpu_type),
					 sysinfo.cpu_count,
					 (long) ((sysinfo.cpu_clock_speed / 1e6) + 0.5));
	newBuf += sprintf (newBuf, 
					 "   Resolution            :         %d x %d Pixel\n"
					 "   Bitdepth              :         %-2d     bpp\n"
					 "   Refreshrate           :         %-2.2f  Hz\n\n\n",
					 (long) screeninfo.frame.Width() + 1,
					 (long) screeninfo.frame.Height() + 1,
					 (screeninfo.mode==B_COLOR_8_BIT)?8:32,
					 screeninfo.refresh_rate);
	newBuf += sprintf (newBuf, " Graphics\n"
					 "   BitBlt S->S copy      :       %s \n", 
					 FormatValue (fBuf, benchRes->blitSS, 1e6, "MPixels/s"));
	newBuf += sprintf (newBuf,"   BitBlt M->S copy      :       %s\n",
					FormatValue (fBuf, benchRes->blitMS, 1e6, "MPixels/s"));
	newBuf += sprintf (newBuf,"   Filled Rectangle      :       %s\n",
					 FormatValue (fBuf, benchRes->filledRect, 1e6, "MPixels/s"));	
	newBuf += sprintf (newBuf,"   Pattern Fill          :       %s\n",
					 FormatValue (fBuf, benchRes->pattFill, 1e6, "MPixels/s"));	
	newBuf += sprintf (newBuf,"   Vertical Lines        :       %s\n",
					 FormatValue (fBuf, benchRes->vertLines, 1e6, "MPixels/s"));	
	newBuf += sprintf (newBuf,"   Horizontal Lines      :       %s\n",
					 FormatValue (fBuf, benchRes->horLines, 1e6, "MPixels/s"));	
	newBuf += sprintf (newBuf,"   Diagonal Lines        :       %s\n",
					 FormatValue (fBuf, benchRes->diagLines, 1e6, "MPixels/s"));	
	newBuf += sprintf (newBuf,"   Vertical Line Array   :       %s\n",
					 FormatValue (fBuf, benchRes->vertLineAr, 1e6, "MPixels/s"));	
	newBuf += sprintf (newBuf,"   Horizontal Line Array :       %s\n",
					 FormatValue (fBuf, benchRes->horLineAr, 1e6, "MPixels/s"));	
	newBuf += sprintf (newBuf,"   Diagonal Line Array   :       %s\n",
					 FormatValue (fBuf, benchRes->diagLineAr, 1e6, "MPixels/s"));	
	newBuf += sprintf (newBuf,"   Text Render           :       %s\n",
					 FormatValue (fBuf, benchRes->textRender, 1e6, "MPixels/s"));
	newBuf += sprintf (newBuf,"   ------------------------------------------------\n"
							  "   Total                 :       %s\n\n\n",
					 FormatValue (fBuf, CalcGfxAv(), 1, "Be-Marks"));
	newBuf += sprintf (newBuf, " WindowScreen\n"
					 "   BitBlt S->S copy      :       %s \n", 
					 FormatValue (fBuf, benchRes->wBlit, 1e6, "MPixels/s"));
	newBuf += sprintf (newBuf,"   Filled Rectangle      :       %s\n",
					 FormatValue (fBuf, benchRes->wFilledRect, 1e6, "MPixels/s"));	
	newBuf += sprintf (newBuf,"   Vertical Lines        :       %s\n",
					 FormatValue (fBuf, benchRes->wVertLines, 1e6, "MPixels/s"));	
	newBuf += sprintf (newBuf,"   Horizontal Lines      :       %s\n",
					 FormatValue (fBuf, benchRes->wHorLines, 1e6, "MPixels/s"));	
	newBuf += sprintf (newBuf,"   Diagonal Lines        :       %s\n",
					 FormatValue (fBuf, benchRes->wDiagLines, 1e6, "MPixels/s"));	
	newBuf += sprintf (newBuf,"   Vertical Line Array   :       %s\n",
					 FormatValue (fBuf, benchRes->wVertLineAr, 1e6, "MPixels/s"));	
	newBuf += sprintf (newBuf,"   Horizontal Line Array :       %s\n",
					 FormatValue (fBuf, benchRes->wHorLineAr, 1e6, "MPixels/s"));	
	newBuf += sprintf (newBuf,"   Diagonal Line Array   :       %s\n",
					 FormatValue (fBuf, benchRes->wDiagLineAr, 1e6, "MPixels/s"));	
	newBuf += sprintf (newBuf,"   ------------------------------------------------\n"
							  "   Total                 :       %s\n\n\n",
					 FormatValue (fBuf, CalcScreenAv(), 1, "Be-Marks"));
					 
	length = strlen (tmp);
	*buffer = (char*) malloc (length+1);
	strcpy (*buffer, tmp);
	free (tmp);
}

char* BenchView::Cpu2String (char* buffer, long cputype)
{
	switch (cputype)
	{
		case B_CPU_PPC_601:
			sprintf (buffer, "PPC 601");
			break;
		case B_CPU_PPC_603:
			sprintf (buffer, "PPC 603");
			break;
		case B_CPU_PPC_603e:
			sprintf (buffer, "PPC 603e");
			break;
		case B_CPU_PPC_604:
			sprintf (buffer, "PPC 604");
			break;
		case B_CPU_PPC_604e:
			sprintf (buffer, "PPC 604e");
			break;
		case B_CPU_PPC_686:
			sprintf (buffer, "Intel x86");
			break;
		default:
			sprintf (buffer, "unknown CPU");
			break;
	}
	return buffer;
}

char* BenchView::FormatValue (char* buffer, float value, float scale, char* units)
{
	if (value < 0.0)
		sprintf (buffer, "  not supported");
	else if (value > 0.0)
		sprintf (buffer, "%8.3f %s", value/scale, units);
	else
		sprintf (buffer, "  --.--- %s", units);
	return buffer;
}

float BenchView::CalcGfxAv(void)
{
	return ( 
	      (benchRes->blitSS * 8) +
	      (benchRes->blitMS * 6) + 
	      (benchRes->filledRect * 5) + 
	      (benchRes->pattFill * 5) + 
	      (benchRes->vertLines * 5) + 
	      (benchRes->horLines * 5) + 
	      (benchRes->diagLines * 4) + 
	      (benchRes->vertLineAr * 5) + 
	      (benchRes->horLineAr * 5) + 
	      (benchRes->diagLineAr * 4) + 
	      (benchRes->textRender * 8) 
          ) / 60 / 1.0e6;
}

float BenchView::CalcScreenAv(void)
{
	float sum;
	float divider;
	
	sum = (
		  ((benchRes->wBlit>0.0?benchRes->wBlit:0.0) * 8) +
	      ((benchRes->wFilledRect>0.0?benchRes->wFilledRect:0.0) * 6) +
	      ((benchRes->wVertLines>0.0?benchRes->wVertLines:0.0) * 5) +
	      ((benchRes->wHorLines>0.0?benchRes->wHorLines:0.0) * 5) +
	      ((benchRes->wDiagLines>0.0?benchRes->wDiagLines:0.0) * 5) +
	      ((benchRes->wVertLineAr>0.0?benchRes->wVertLineAr:0.0) * 5) +
	      ((benchRes->wHorLineAr>0.0?benchRes->wHorLineAr:0.0) * 5) +
	      ((benchRes->wDiagLineAr>0.0?benchRes->wDiagLineAr:0.0) * 5)
          );
    divider = (
		  (benchRes->wBlit>0.0?8:0) +
	      (benchRes->wFilledRect>0.0?6:0) +
	      (benchRes->wVertLines>0.0?5:0) +
	      (benchRes->wHorLines>0.0?5:0) +
	      (benchRes->wDiagLines>0.0?5:0) +
	      (benchRes->wVertLineAr>0.0?5:0) +
	      (benchRes->wHorLineAr>0.0?5:0) +
	      (benchRes->wDiagLineAr>0.0?5:0)
          );
    if (divider > 0)
    	return sum / divider / 1.0e6;
    else
    	return 0;
}

