/*****************************************************************************

	Projet	: Pulsar Sample FFT AddOn

	Fichier	: sample_addon.cpp
	Partie	: End

	Auteur	: RM
	Date		: 040597 -- version 0.2 (C funcs)
	Date		: 010797 -- version 0.3 (CFilter)
	Format	: tabs==2

	This Sample FFT Add-on does something : blit the two fft on screen.
	This is a hack.

	The simple way to do this :
	- implement & export the C function "CFilter * filterInit(uint32 index)",
	  where  you simply create your CFilter derived class.
	- derive a class from CFilter, you should at least implement two methods
	- CFilter::load() must be implemented, this is where you will fill info about
	  your add-on, name, auhtor, etc. You DON'T need to call the inherited function,
	  it does nothing.
	- CFilter::processFrame() is where you draw the output, by using the info about
	  the sound and the stream.

*****************************************************************************/

#include "CFilter.h"

#pragma export on
CFilter * filterInit(uint32 index);
#pragma export reset

//--------------------------------------------------------------------

//*************************************
class CSampleFftFilter : public CFilter
//*************************************
{
public:

	CSampleFftFilter(void) : CFilter()	{ /* nothing */ }
	virtual ~CSampleFftFilter(void) 		{ /* nothing */ }

	virtual bool load(void);
	virtual bool prepare(void) { return true; } // don't miss that call !
	virtual void processFrame(void);

}; // end of class defs for CSampleFftFilter


//--------------------------------------------------------------------


//**********************************************
CFilter * filterInit(uint32 index)
//**********************************************
/*
	This function is called when the add-on is loaded.
	This occurs when Pulsar is starting.
	This function is called several times with index=0 then 1 etc
	until it returns NULL. This give you the opportunity to code
	several filters in one add-on.

	Here you must create a new instance of your derived CFilter class.
	You return the pointer on the instance.
	You get called several times until you return NULL.
	You must return a valid object pointer, since the caller will verify
	using ClassInfo that the class is derived from CFilter but is not a
	CFilter instance.
*/
{
	// this add-on only declares ONE filter
	if (index > 0) return NULL;

	CSampleFftFilter *info = new CSampleFftFilter;
	if (!info) return NULL;		// memory error, give up

	// returns the instance -- the caller will check that this instance
	// is derived from CFilter but is _not_ a CFilter...
	return info;
} // end of filterInit


//*******************************
bool CSampleFftFilter::load(void)
//*******************************
/*
	Called just after the add-on has succesfully been loaded.
	If you return false, <the add-on will be unloaded immediatly
	and its unload() hook will be called>.
	Use this to set up the vital info about the filter, i.e. the
	strings (optional) and the supported color mode (currently fixed to 8 bits).
	This can also be done in you class constructor.
	The main difference with the constructor is that when you get here,
	the main program will have set up your main members, like the directories,
	the pointers onto buffers, etc. Also you can get back the index of the
	instance indicated by filterInit here. Check the CFilter.h for more info ;-)
*/
{
	sFilter.name = "FFT Addon";
	sFilter.author = "R'alf";
	sFilter.info = "Sample code";
	sFilter.majorVersion = 0;
	sFilter.minorVersion = 3;

	return(sLoad.majorPulsarVersion == sFilter.majorVersion
			&& sLoad.minorPulsarVersion == sFilter.minorVersion);
}  // end of load for CSampleFftFilter


//***************************************
void CSampleFftFilter::processFrame(void)
//***************************************
/*
	Real blit into the screen.
	<Updated fields : frame, lastFps>

	Bad implementation, may be *that* slow...

	Warning !
	NO THESE ARE NO LONGER CONSTANT !
	I WIL SWITCH TO DOUBLE BUFFER IN 0.4 !!
*/
{
float *chanL;
float *chanR;
int i,j;
uchar *p;
uchar *base;
long bpr;
long frame;
int y1;
int y2;
int h = sPrepare.sy;
int w = sPrepare.sx;
int w2 = w/2;
int h2 = h/2;

	base	= sFrame.screen;
	bpr		= sPrepare.bpr;
	chanL	= sFrame.fftHigh;
	chanR	= sFrame.fftBass;
	frame	= sFrame.frame;

	long meanR=0;
	p = base+w2;
	j=256;
	if (j>w) j=w;
	for(i=0; i<h; i++, p+=bpr)
	{
		long a = (i+frame)&0x1ff;
		if (a > 255) continue;
		y1 = (chanR[a]) / 32768;
		if (y1 < 0) y1 = -y1;
		if (y1 < 3) continue;
		if (y1 > w2) y1 = w2;
		meanR+=y1;
		uchar *a1 = p-y1;
		uchar *a2 = p+y1;
		uchar c=i+y1;
		for(;a1<a2; a1++) *a1=c;	
	}

	// fft droite (right)

	i = meanR*4/256;
	i = 10+100-i;
	if (i<0) i=0;
	if (i>479) i=479;
	p = base+10+i*bpr;
	memset(p, 250, 256);

	long meanL=0;
	p = base+10+10*bpr;
	for(i=0; i<255; i++, p++)
	{
		y1 = 100-(chanR[i])/16384*2;
		y2 = 100-(chanR[i+1])/16384*2;
		meanL+=(chanL[i])/16384*2;
		if (y1<0) y1=0;
		if (y2<0) y2=0;
		if (y1 > y2) { int a=y1; y1=y2; y2=a; }
		if (y1 > 99) y1=99;
		if (y2 > 99) y2=99;

		uchar *a = p+y1*bpr;
		int y;

		for(y=y1; y<=y2; y++, a+=bpr) *a = 52;	// vert pomme (apple green)
	}

	// fft gauche (left)

	i = meanL*4/256;
	i = 50+10+100-i;
	if (i<0) i=0;
	if (i>479) i=479;
	p = base+640-256-10+i*bpr;
	memset(p, 52, 256);

	p = base+640-256-10+(50+10)*bpr;
	for(i=0; i<255; i++, p++)
	{
		y1 = 100-(chanL[i])/16384*2;
		y2 = 100-(chanL[i+1])/16384*2;
		if (y1<0) y1=0;
		if (y2<0) y2=0;
		if (y1 > y2) { int a=y1; y1=y2; y2=a; }
		if (y1 > 99) y1=99;
		if (y2 > 99) y2=99;

		uchar *a = p+y1*bpr;
		int y;

		for(y=y1; y<=y2; y++, a+=bpr) *a = 250;	// vert pomme
	}
}  // end of processFrame for CSampleFftFilter


// eoc
