/*
 *  @(#) obuffer.h 1.8, last edit: 6/15/94 16:51:56
 *  @(#) Copyright (C) 1993, 1994 Tobias Bading (bading@cs.tu-berlin.de)
 *  @(#) Berlin University of Technology
 *
 *  Idea and first implementation for u-law output with fast downsampling by
 *  Jim Boucher (jboucher@flash.bu.edu)
 *
 *  LinuxObuffer class written by
 *  Louis P. Kruger (lpkruger@phoenix.princeton.edu)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef OBUFFER_H
#define OBUFFER_H

#include "all.h"
#include "header.h"
#include "cAudioWrap.h"

static const uint32 OBUFFERSIZE = 2 * 1152;	// max. 2 * 1152 samples per frame
static const uint32 MAXCHANNELS = 2;		// max. number of channels

// Abstract base class for audio output classes:
class Obuffer
{
public:
  virtual     ~Obuffer (void) {}		// dummy


  virtual void append (uint32 channel, int16 value) = 0;
			 // this function takes a 16 Bit PCM sample
  virtual void write_buffer (int fd) = 0;
			 // this function should write the samples to the filedescriptor
			 // or directly to the audio hardware
};

class FileObuffer : public Obuffer
{
private:
  int16 buffer[OBUFFERSIZE];
  int16 *bufferp[MAXCHANNELS];
  uint32 channels;
				  
public:
  FileObuffer (uint32 number_of_channels);
  ~FileObuffer (void) {}
  void	append (uint32 channel, int16 value);
  void	write_buffer (int fd);
};

class BeObuffer : public Obuffer
{
public:
  int16 buffer[OBUFFERSIZE];
  int16 *bufferp[MAXCHANNELS];
  uint32 channels;
  cAudioWrap *audio_wrapper;



  BeObuffer(uint32 number_of_channels);
  ~BeObuffer (void) {}
  void	append (uint32 channel, int16 value);
  void	write_buffer (int fd);
};

#endif
