//TermSound version 1.0


#include <stdio.h>
#include <PlaySound.h>


void main(int argc, char **argv);
void MyPlaySound(char *FileName);

void main(int argc, char **argv)
{
	int counter;

	if(argc < 2)
		printf("Usage: playsnd soundfilename [soundfilename2...]\n"
			   "Plays the specified sound files in the order specified, then quits\n");
	else
		for(counter = 1; counter < argc; counter++)
			MyPlaySound(argv[counter]);
}


void MyPlaySound(char *FileName)
{
	BEntry SoundEntry(FileName);
	if(SoundEntry.InitCheck() != B_NO_ERROR)
	{
		printf("Failed to obtain BEntry for %s\n",FileName);
		return;
	}
	if(!SoundEntry.Exists())
	{
		printf("%s: File not found\n",FileName);	
		return;
	}
	entry_ref SoundRef;
	status_t Status = SoundEntry.GetRef(&SoundRef);
	if(Status != B_NO_ERROR)
	{
		printf("Failed to obtain entry_ref for %s\n",FileName);
		return;
	}
	sound_handle handle = play_sound(&SoundRef, true, true, true);
	if(handle >= 0)
		wait_for_sound(handle);
	snooze(100);	//Necessary to prevent crash due to quitting before sound has been freed up
}
