/*
 *  volprop.cpp - Volume slider
 *
 *  SIDPlayer (C) 1996 Christian Bauer
 *  Stereo support by Marco Nelissen
 */

#include "volprop.h"


volprop::volprop(float ihprop,float ihval,float ivprop,float ivval, 
					BBitmap *kr, void (*func)(volprop*,void*), void *arg )
	: PropGadget(ihprop, ihval, ivprop, ivval, kr,  (void (*)(PropGadget*,void*))func,  arg )
{
}

void volprop::DrawContainer(BRect rec)
{
	BRect back=Bounds();
	int x;
	int height;

	inherited::DrawContainer(rec);
	SetHighColor(50,50,50);
	x=(back.left+back.right)/2+1;
	height=back.Height()-rec.Height();
	SetPenSize(2);
	StrokeLine(BPoint(x,back.top+rec.Height()/2),BPoint(x,back.bottom-rec.Height()/2));
	SetPenSize(1);

	for(float f=0;f<=1;f=f+0.25)
	{
		StrokeLine(BPoint(x-3,height*f+rec.Height()/2),BPoint(x+2,height*f+rec.Height()/2));
	}
}

