/*
 *	SpaceScope V1.0
 *
 *  Sources are copyrighted by Tinic Urou in 1997. All rights reserved.
 */

#include <SupportKit.h>
#include <AppKit.h>
#include <InterfaceKit.h>
#include "Post.h"
#include "ZSlider.h"

#define POST_NAME 		"Balance"			
#define POST_VALUE		"BalanceValue"
#define MIK_VAL 'mkvl'

class MyView;

struct instance_struct						// instance of our class
{
	BMessage 	*prefs;
	long   		balance;
	MyView		*view;
};

static void _SliderHook(char *dest, long allowedsize, long value)
{
	if(value==128)
	{
		sprintf(dest,"centered");
	}
	else if(value>128)
	{
		sprintf(dest,"%d%% right",min_c(100,(((value-128)*100)/128)+1));
	}
	else
	{
		sprintf(dest,"%d%% left",min_c(100,(((128-value)*100)/128)+1));
	}
}

class MyView : public BView
{
	instance_struct *inst;
	ZSlider	*reverb;

	public:
	
				MyView(BRect frame, instance_struct *i):BView(frame,"",NULL,B_WILL_DRAW)
				{
					inst=i;
					reverb = new ZSlider(BRect(6,26,131,44),"BalanceSlider","","144% right",_SliderHook,new BMessage(MIK_VAL),FALSE, B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW);
					AddChild(reverb);
				};

	void		AttachedToWindow()
				{
					Window()->Lock();
					reverb->SetTarget(this);
					reverb->SetMaxValue(256);
					reverb->SetMinValue(0);
					reverb->SetValue(inst->prefs->FindInt32(POST_VALUE));
					reverb->SetCrazy(TRUE);
					Window()->Unlock();
				};
				
	void		MessageReceived(BMessage *msg)
				{
					switch(msg->what)
					{
						case	MIK_VAL:
								Window()->Lock();
								inst->prefs->ReplaceInt32(POST_VALUE,reverb->GetValue());
						    	inst->balance = inst->prefs->FindInt32(POST_VALUE);
								Window()->Unlock();
								break;
						default:
								BView::MessageReceived(msg);
					}
				};
};

/*
 	Dispatcher of our zOOnic class
*/

long class_dispatcher(Class *c, Object *o, ulong MethodID, ulong *data)
{
	instance_struct *inst=(instance_struct *)o->Instance(c);

	switch(MethodID)
	{
		case	B_METHOD_CONSTRUCT:				// like the C++ constructor method
				{
					inst->view= new MyView(BRect(0,0,131,60),inst);
					return 0;
				}

		case	B_METHOD_DESTROY:				// like the C++ constructor method
				{
					delete inst->view;
					return 0;
				}

		case	PO_STREAM:						// void (char *buffer, int size)
				{
					short *buffer=(short *)data[0];
					int size=(int)data[1]/2;					

					int lvol=min_c(128,256-inst->balance);
					int rvol=min_c(128,000+inst->balance);
					
				    for (int c=0;c<size;c+=2)
				    {
				   		buffer[c+0]=((int)buffer[c+0]*lvol)/128;
				   		buffer[c+1]=((int)buffer[c+1]*rvol)/128;
				    }
					
					return 0;
				}
				
		case	PO_NEWFILE:						// void (BAudioSubscriber *auds)
				{
					return 0;
				}
		
		case	PO_ENDFILE:						// void (void)
				{
					return 0;
				}

		case	PO_SETATTR:						
				{
					ulong ATTR =(ulong)data[0];
					ulong DATA =(ulong)data[1];

					switch(ATTR)
					{
						case	PO_ATTR_PREFS:
								inst->prefs=(BMessage *)DATA;
								if(!inst->prefs->HasInt32(POST_VALUE))inst->prefs->AddInt32(POST_VALUE,128);
								inst->balance = inst->prefs->FindInt32(POST_VALUE);
								break;
					}
					o->DoSuperMethod(c,PO_SETATTR,data);
					return 0;
				}

		case	PO_GETATTR:						
				{
					ulong ATTR =(ulong)data[0];
					ulong DATA =(ulong)data[1];

					switch(ATTR)
					{
						case	PO_ATTR_ID:			
								*((char **)DATA)=POST_NAME;
								return 0;
						case	PO_ATTR_BVIEW:			
								*((BView **)DATA)=inst->view;
								return 0;
						default:
								return o->DoSuperMethod(c,PO_GETATTR,data);
					}
				}
	}
}

char *class_superclass()
{
	return "dualplayer/post/baseprocessor.zclass";
};

long class_instancesize()
{
	return sizeof(struct instance_struct);
};

long class_superversion()
{
	return 1;
};

long class_version()
{
	return 1;
};
