
#ifndef _GUS_H_
#define _GUS_H_

#include <stdio.h>
#include "mikmod.h"

// MDRIVER tickhandler
extern void tickhandler(void);

// General GUS driver information
typedef void (*PFV)(void);

typedef struct
{  UBYTE kick;               // =1 -> sample has to be restarted
   UBYTE active;             // =1 -> sample is playing
   UWORD flags;              // 16/8 bits looping/one-shot
   SWORD handle;             // identifies the sample
   ULONG start;              // start index
   ULONG size;               // samplesize
   ULONG reppos;             // loop start
   ULONG repend;             // loop end
   ULONG frq;                // current frequency
   UWORD vol;                // current volume
   UWORD pan;                // current panning position
} GHOLD;

// Variables defined in DRV_GUS.C
extern GHOLD *ghld;
extern UBYTE timeskip;
extern UBYTE timecount;
extern UBYTE GUS_BPM;
extern UWORD GUS_DRAM_DMA;
extern SWORD playertimer;


void UltraStopTimer(int timer);
PFV UltraTimer1Handler(PFV handler);
PFV UltraDMAHandler(PFV handler);
void UltraClose(void);
void UltraStopTimer(int timer);
void UltraDisableOutput(void);
void UltraStartDramDma(void);
void UltraStopDramDma(void);
void UltraWaitDramDma(void);
BOOL UltraDramDmaActive(void);
void UltraDownloadDma(ULONG dest);
ULONG UltraMalloc(ULONG reqsize);
ULONG UltraMalloc16(ULONG reqsize);
void UltraFree(ULONG size,ULONG location);


// Prototypes from DRV_GUS.C
BOOL GUS_Common_Init(void);
void GUS_Common_Start(void);
void GUS_Common_Update(void);
void UltraSetBPM(UBYTE bpm);
SWORD GUS_Load(SAMPLOAD *sload, FILE *fp);
void GUS_UnLoad(SWORD handle);
BOOL GUS_IsThere(void);
BOOL GUS_SetNumChannels(void);
void GUS_VoiceSetVolume(UBYTE voice,UWORD vol);
void GUS_VoiceSetFrequency(UBYTE voice,ULONG frq);
void GUS_VoiceSetPanning(UBYTE voice,ULONG pan);
void GUS_VoicePlay(UBYTE voice,SWORD handle,ULONG start,ULONG size,ULONG reppos,ULONG repend,UWORD flags);
void GUS_VoiceStop(UBYTE voice);
void GUS_VoiceReleaseSustain(UBYTE voice);
BOOL GUS_VoiceStopped(UBYTE voice);
SLONG GUS_VoiceGetPosition(UBYTE voice);
ULONG GUS_RealVolume(UBYTE voice);
ULONG GUS_SampleSpace(int type);
ULONG GUS_SampleLength(int type, SAMPLE *s);
void GUS_Dummy(void);


#endif
