/*
	DUALPLAYER V1.02 (c) by Tinic Uro

	Player class
*/	
#ifndef _P_OBJECT_
#define _P_OBJECT_

#include "zoonic.h"
#include "Dual.h"	// dualplayer object methods

/* 
	Methods
*/
enum
{
	P_LOAD			=0x100,				// bool (char *path)
	P_FREE			=0x101,				// void (void)
	P_RESUME		=0x103,				// void (void)
	P_PAUSE			=0x104,				// void (void)
	P_SETUPSTREAM	=0x105,				// void (BSubscriber *subs, BDACStream *dac)
	P_STREAM		=0x106,				// bool (char *buffer, int32 size)
	P_CREATEINFO	=0x107,				// void (char ***info, int32 *lines)
	P_FREEINFO		=0x108,				// void (char ***info, int32 *lines)
	P_DRAWSTATUS	=0x109,				// void (BView *view)
	P_POSITIONSTRING=0x10a,				// void (char *str, int32 allowedlength, int32 value)
	P_SETATTR		=B_METHOD_SETATTR,	// int32 (int32 attribute, int32 data)
	P_GETATTR		=B_METHOD_GETATTR,	// int32 (int32 attribute, int32 data)
};

/*
	Attributes
	
	These attributes should preferably be ONLY accessed by DualPlayer or other clients
*/
enum
{
	P_ATTR_STREAMARG=0x10,				// -G-	Argument which should be forwarded to P_STREAM, default is 0
	P_ATTR_MODLENGTH,					// -G-	Module/File-length, default is 0
	P_ATTR_MODPOS,						// SG-	actual Module/File-position, must be between 0 and P_ATTR_MODLENGTH. If set, forward to requested position., default is 0
	P_ATTR_TRACKNUM,					// -G-  Number of tracks, return 0 when there are none. default is 0
	P_ATTR_TRACK,						// SG-  Actual track. When set, forward to requested track. default is 0
	P_ATTR_UNUSED,						// obsolete attribute
	P_ATTR_BOOST,						// S--  Volume 0..128. Anything over 128 is a special boost and is VALID. Use min_c() to limit the volume for your use.
	P_ATTR_LOOP,						// S--  Loop file when possible, preferably without reloading, e.g. never return 0 in the stream function.
	P_ATTR_ID,							// -G-  ID string which appears on the list. default is "Please supply P_ATTR_ID".
	P_ATTR_PREFS,						// S--  Access to the main preferences BMessage. Store your own preferences in here. Can be 0 or even not be set!!!
	P_ATTR_VIEW,						// -G-  Return a valid BView. It should contain preferences stuff. Size should be BRect(0,0,199,179). default is an empty BView.
	P_ATTR_RECOGNITION,					// -G-	0..100%. 0% = File are hardly recognizable, 100% = Files can be itendified without any problem. default is 25.
	P_ATTR_DUALOBJECT,					// S--  Dualplayerobject gives you the possibilty to call and access functions of DualPlayer, can be 0 or even not be set!!!
	P_ATTR_ACTIVATED,					// Implemented by baseclass
	P_ATTR_MIME,						// -G-  return a list of supported mime types.
};										//
										// |||
										// ||+- Direct return
										// ||
										// |+-- Getable Attribute
										// |
										// +--- Setable Attribute
#endif