// TermHire.cpp
// v0.97
// version for AADR9 release of the BeOS
// release date 24/05/97
/*
	ExpandMe
	Add-on for tracked by R'alf.
	v0.1 - test code, use at your own risk
	31/5/97
	-- not a clean source !! --
	derived from TermHire v0.97, by Pierre BRUA (brua@dess-info.u-strasbg.fr
*/

#include <Directory.h>
#include <Window.h>
#include <StringView.h>
#include <File.h>
#include <Alert.h>
#include <Message.h>
#include <Errors.h>
//#include <Debug.h>
#include <Path.h>
#include <NodeInfo.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>


#pragma once
// use this define if you want little windows to explain you what's going on
//#define VERBOSE 1


#define CHANGE_TYPE_RC			"mimeswitch.rc"
#define CHANGE_TYPE_PATH1		"/boot/"
#define CHANGE_TYPE_PATH2		"/boot/system/settings/"


// global variables. I know it is ugly, but this is just an add-on

char *argv[3] = { "/boot/apps/Terminal" ,NULL,NULL}; // the app which is launched
#define ARGC 1 // the number of arguments in argv
int numOK = 0; // number of Terminals launched correctly
extern char **environ; // this is the global context of the shell

#ifdef VERBOSE
BWindow *win;
BStringView *status;
#endif

// rules list
struct a_rule
{
	char *ext;
	char *mime;
};

BList	ruleList;		// a list of a_rule ptrs

#pragma export on
void process_refs(entry_ref dir_ref, BMessage* msg, void*);
#pragma export reset
int changeType(const char *file, const char *leaf, const char *dir);
int loadRules(void);
char *mystrdup(char *s);


static void error(const char *message)
{
	BAlert *alert = new BAlert("ExpandMe Error :\n", message, "OK");
	alert->Go();
}

char *mystrdup(char *s)
{
	if (!s) return "";
	long n = strlen(s);
	char *d = new char[n+1];
	strcpy(d, s);
	return d;
}

int loadRules(void)
{
FILE *f;
char name[1024];
a_rule *r;

	sprintf(name, "%s%s", CHANGE_TYPE_PATH1, CHANGE_TYPE_RC);
	f = fopen(name, "r");
	if (!f)
	{
		sprintf(name, "%s%s", CHANGE_TYPE_PATH2, CHANGE_TYPE_RC);
		f = fopen(name, "r");
		if (!f) return B_ERROR;
	}

	while(!feof(f))
	{
		fgets(name, 1023, f);
		if (strlen(name) < 5) continue;
		if (name[0] != '.') continue;

		const char sep[] = " \t\n\r";
		char *p1, *p2;
		p1 = strtok(name, sep);
		p2 = strtok(NULL, sep);
		r = new a_rule;
		r->ext = mystrdup(p1);
		r->mime = mystrdup(p2);
		ruleList.AddItem(r);
		//printf("found rule ext \"%s\", mime \"%s\"\n", r->ext, r->mime);
	}

	return B_NO_ERROR;
}


int changeType(const char *file, const char *leaf, const char *dir)
{
//char buf[1024];
long len;

	//printf("changeType file %s, leaf %s in dir %s\n", file,leaf,dir);

	//getcwd(buf, 1023);
	//printf("cwd before is %s\n", buf);

	// chdir might not be necessary -- unless I do recursive expand
	chdir(dir);
	//getcwd(buf, 1023);
	//printf("cwd after is %s\n", buf);

	len = strlen(leaf);

// check postfix : 'n' is strlen('x')
#define POSTFIX(x,n) (len > n && strncmp(&leaf[len-n], x, n) == 0)

	// try every postfix and change when found
	int32 nbrule = ruleList.CountItems();
	for(nbrule--; nbrule>=0; nbrule--)
	{
		a_rule *r;
		r = (a_rule *)ruleList.ItemAt(nbrule);
		if (!r || !r->ext || !r->mime) continue;
		long ln = strlen(r->ext);
		if (POSTFIX(r->ext, ln))
		{
			BNode node(file);
			if (node.InitCheck() >= B_NO_ERROR)
			{
				BNodeInfo info(&node);
				info.SetType(r->mime);
				// info.SetPreferredApp(textApp->Text());
			}
			break;
		}
	}

	return B_NO_ERROR;
}



// this is the function the Tracker call when the add-on is selected
// dir_ref is the folder you have launched it from
// msg is a BMessage containing the references to BEntry's(Files/Folders)
// and for "void *", I don't know yet...
void process_refs(entry_ref dir_ref, BMessage* msg, void*)
{
	long count; // number of references stored in the BMessage
	ulong type; // type of the BMessage
	BPath path; // path to use to launch the terminal

	if (loadRules() != B_NO_ERROR) return;

// this creates an informative window about the completion of the add-on
#ifdef VERBOSE
	char strpath[1000];
	BRect area(0,0, 250,15);
	screen_info info;

	get_screen_info(&info);
	area.OffsetBy(info.frame.Width()/2-125, info.frame.Height()/2-10);
	win = new BWindow(area, "TermHire Progress", B_TITLED_WINDOW,
		B_NOT_ZOOMABLE | B_NOT_RESIZABLE | B_NOT_CLOSABLE);
	status = new BStringView(win->Bounds(), "status", "TermHire");
	win->AddChild(status);
	win->Show();
#endif


	// first, we consider the case when the add-on has been selected
	// from the file menu of the browser window or by right-clicking
	// in the background of the window
	// i.e : in this case, there is no refs on the BMessage
	msg->GetInfo("refs", &type, &count);
	if (count == 0)
	{
		error("Please select a file or a directory to exand !");
	}
	else
	{
		BDirectory dir;
		BEntry entry;
		// if there are datas on the BMessage, but not from the
		// directory type, exit...
		if (dir.SetTo(&dir_ref) != B_NO_ERROR) 
		{
			error("You must launch ExandMe from folders.");
			return;
		}
		if(dir.GetEntry(&entry) != B_NO_ERROR)
		{
			error("Sorry, I cannot access the folder while launching"
			      "a Terminal");
			return;
		}
		entry_ref ref;
		BFile file;
		for (int ix=0; ix<count; ix++)
		{
			if(msg->FindRef("refs", ix, &ref) == B_NO_ERROR)
			// if the ref is a folder, launch a Terminal on this folder
			if(dir.SetTo(&ref) == B_NO_ERROR)
			{
				//entry.SetTo(&ref);
				//entry.GetPath(&path);
				//if(!LaunchTerminal(path.Path())) goto exit;
				// HOOK -- should process recusively every file
			}
			// if the ref is not a folder, launch a Terminal on the parent folder
			else if(entry.SetTo(&ref) == B_NO_ERROR) 
			{
				// I ask for the parent directory of the entry
				BEntry entry2;
				BPath path2;
				entry.GetParent(&entry2);
				entry.GetPath(&path);
				entry2.GetPath(&path2);
				if(changeType(path.Path(), path.Leaf(), path2.Path()) != B_NO_ERROR) goto exit;
			}
		}
	}
	
#ifdef VERBOSE
	sprintf(strpath, "%d out of %d were set", numOK, count);
	win->Lock();
	status->SetText(strpath);
	win->Unlock();
#endif
exit:
#ifdef VERBOSE
	snooze(100000);
	win->Quit();
#endif
	;

	// freeRules(); -- ugly but this is a fast hack
}
